/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanel;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.CtmPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.blockentity.FramedStackedSlopePanelBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedStackedSlopePanelBlock
extends AbstractFramedDoubleBlock {
    public static final CtmPredicate CTM_PREDICATE = CtmPredicate.HOR_DIR_AXIS.or((state, side) -> {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rot = (HorizontalRotation)((Object)((Object)state.m_61143_(PropertyHolder.ROTATION)));
        return side == rot.withFacing(dir).m_122424_();
    });

    public FramedStackedSlopePanelBlock() {
        super(BlockType.FRAMED_STACKED_SLOPE_PANEL);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, FramedProperties.Y_SLOPE, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_();
        Direction side = context.m_43719_();
        HorizontalRotation rotation = side == facing.m_122424_() ? HorizontalRotation.fromWallCross(context.m_43720_(), side) : HorizontalRotation.fromDirection(facing, side);
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation));
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        double xz;
        Direction face = hit.m_82434_();
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        if (face == rotation.withFacing(dir) && (xz = Utils.fractionInDir(hit.m_82450_(), dir.m_122424_())) > 0.5) {
            face = dir.m_122424_();
        }
        return this.rotate(state, face, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (face.m_122434_() == dir.m_122434_()) {
            HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            return (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return FramedSlopePanelBlock.mirrorPanel(state, mirror);
    }

    @Override
    protected Tuple<BlockState, BlockState> getBlockPair(BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        boolean ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
        return new Tuple((Object)((BlockState)((Block)FBContent.blockFramedPanel.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)), (Object)((BlockState)((BlockState)((BlockState)((BlockState)((Block)FBContent.blockFramedSlopePanel.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation))).m_61124_((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedStackedSlopePanelBlockEntity(pos, state);
    }

    public static BlockState itemModelSource() {
        return (BlockState)((Block)FBContent.blockFramedStackedSlopePanel.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

