/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.predicate.CtmPredicate;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slope.FramedVerticalHalfSlopeBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedSlopedStairsBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == dir || side == dir.m_122428_()) {
            return true;
        }
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        return top ? side == Direction.UP : side == Direction.DOWN;
    };

    public FramedSlopedStairsBlock() {
        super(BlockType.FRAMED_SLOPED_STAIRS);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, FramedProperties.SOLID, PropertyHolder.RIGHT, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction side = context.m_43719_();
        Vec3 hitVec = context.m_43720_();
        BlockState state = FramedSlopedStairsBlock.withCornerFacing(this.m_49966_(), context.m_43719_(), context.m_8125_(), context.m_43720_());
        state = FramedSlopedStairsBlock.withTop(state, side, hitVec);
        return FramedSlopedStairsBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        return (BlockState)state.m_61122_((Property)FramedProperties.TOP);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return this.rotate(state, Direction.UP, rotation);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeBottom = Shapes.m_83110_((VoxelShape)FramedVerticalHalfSlopeBlock.SHAPE_TOP, (VoxelShape)FramedSlopedStairsBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0)).m_83296_();
        VoxelShape shapeTop = Shapes.m_83110_((VoxelShape)FramedVerticalHalfSlopeBlock.SHAPE_BOTTOM, (VoxelShape)FramedSlopedStairsBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).m_83296_();
        for (BlockState state : states) {
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            VoxelShape shape = top ? shapeTop : shapeBottom;
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR), shape));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

