/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.crafting;

import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.util.MathUtils;

public final class FramingSawRecipe
implements Recipe<Container> {
    public static final int CUBE_MATERIAL_VALUE = 6144;
    private static final Lazy<ItemStack> TOAST_ICON = Lazy.of(() -> new ItemStack((ItemLike)FBContent.blockFramingSaw.get()));
    private final ResourceLocation id;
    private final int materialAmount;
    private final boolean hasAdditive;
    private final Ingredient additive;
    private final int additiveCount;
    private final ItemStack result;
    private final IBlockType resultType;
    private final boolean disabled;

    FramingSawRecipe(ResourceLocation id, int materialAmount, @Nullable Ingredient additive, int additiveCount, ItemStack result, IBlockType resultType, boolean disabled) {
        this.id = id;
        this.materialAmount = materialAmount;
        this.hasAdditive = additive != null;
        this.additive = additive;
        this.additiveCount = additiveCount;
        this.result = result;
        this.resultType = resultType;
        this.disabled = disabled;
    }

    public boolean m_5818_(Container container, Level level) {
        return this.matchWithReason(container, level).success();
    }

    public FailReason matchWithReason(Container container, Level level) {
        ItemStack input = container.m_8020_(0);
        if (input.m_41619_()) {
            return FailReason.MATERIAL_VALUE;
        }
        int inputValue = FramingSawRecipeCache.get(level.m_5776_()).getMaterialValue(input.m_41720_());
        int totalInputValue = inputValue * input.m_41613_();
        if (totalInputValue < this.materialAmount) {
            return FailReason.MATERIAL_VALUE;
        }
        long matLcm = MathUtils.lcm(inputValue, this.materialAmount);
        if (matLcm > (long)totalInputValue) {
            return FailReason.MATERIAL_LCM;
        }
        ItemStack addStack = container.m_8020_(1);
        if (!this.hasAdditive && !addStack.m_41619_()) {
            return FailReason.UNEXPECTED_ADDITIVE;
        }
        if (this.hasAdditive && addStack.m_41619_()) {
            return FailReason.MISSING_ADDITIVE;
        }
        if (this.hasAdditive && !this.additive.test(addStack)) {
            return FailReason.INCORRECT_ADDITIVE;
        }
        int addCount = this.additiveCount * (int)(matLcm / (long)this.materialAmount);
        if (addStack.m_41613_() < addCount) {
            return FailReason.INSUFFICIENT_ADDITIVE;
        }
        return FailReason.NONE;
    }

    public ItemStack m_5874_(Container container) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public int getMaterialAmount() {
        return this.materialAmount;
    }

    @Nullable
    public Ingredient getAdditive() {
        return this.additive;
    }

    public int getAdditiveCount() {
        return this.additive != null ? this.additiveCount : 0;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public int getResultSize(Container container, Level level) {
        ItemStack input = container.m_8020_(0);
        int inputValue = FramingSawRecipeCache.get(level.m_5776_()).getMaterialValue(input.m_41720_());
        long lcm = MathUtils.lcm(inputValue, this.materialAmount);
        return (int)(lcm / (long)this.materialAmount) * this.result.m_41613_();
    }

    public IntIntPair getInputOutputCount(Item input, boolean client) {
        int inputValue = FramingSawRecipeCache.get(client).getMaterialValue(input);
        long lcm = MathUtils.lcm(inputValue, this.materialAmount);
        return IntIntPair.of((int)((int)(lcm / (long)inputValue)), (int)((int)(lcm / (long)this.materialAmount) * this.result.m_41613_()));
    }

    public IntIntPair getInputAndAdditiveCount(Container container, Level level) {
        return this.getInputAndAdditiveCount(container.m_8020_(0), level.m_5776_());
    }

    public IntIntPair getInputAndAdditiveCount(ItemStack input, boolean client) {
        int inputValue = FramingSawRecipeCache.get(client).getMaterialValue(input.m_41720_());
        long lcm = MathUtils.lcm(inputValue, this.materialAmount);
        return IntIntPair.of((int)((int)(lcm / (long)inputValue)), (int)(this.hasAdditive ? (int)(lcm / (long)this.materialAmount) * this.additiveCount : 0));
    }

    public IBlockType getResultType() {
        return this.resultType;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_8042_() {
        return (ItemStack)TOAST_ICON.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FBContent.recipeSerializerFramingSawRecipe.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)FBContent.recipeTypeFramingSawRecipe.get();
    }

    public static enum FailReason {
        NONE(true),
        MATERIAL_VALUE(false),
        MATERIAL_LCM(false),
        MISSING_ADDITIVE(false),
        UNEXPECTED_ADDITIVE(false),
        INCORRECT_ADDITIVE(false),
        INSUFFICIENT_ADDITIVE(false);

        private final boolean success;
        private final Component translation;

        private FailReason(boolean success) {
            this.success = success;
            this.translation = Utils.translate("msg", "frame_crafter.fail." + this.toString().toLowerCase(Locale.ROOT)).m_130940_(success ? ChatFormatting.GREEN : ChatFormatting.RED);
        }

        public boolean success() {
            return this.success;
        }

        public Component translation() {
            return this.translation;
        }
    }
}

