/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.common.FBContent;

public final class FramingSawRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private final int count;
    private int material = 0;
    private List<Additive> additives = null;
    private boolean disabled = false;

    private FramingSawRecipeBuilder(ItemLike result, int count) {
        this.result = result.m_5456_();
        this.count = count;
    }

    public static <T extends ItemLike> FramingSawRecipeBuilder builder(RegistryObject<T> result) {
        return FramingSawRecipeBuilder.builder((ItemLike)result.get());
    }

    public static FramingSawRecipeBuilder builder(ItemLike result) {
        return FramingSawRecipeBuilder.builder(result, 1);
    }

    public static <T extends ItemLike> FramingSawRecipeBuilder builder(RegistryObject<T> result, int count) {
        return FramingSawRecipeBuilder.builder((ItemLike)result.get(), count);
    }

    public static FramingSawRecipeBuilder builder(ItemLike result, int count) {
        Preconditions.checkNotNull((Object)result, (Object)"Result must be non-null");
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Result count must be greater than 0");
        return new FramingSawRecipeBuilder(result, count);
    }

    public FramingSawRecipeBuilder material(int material) {
        Preconditions.checkArgument((material > 0 ? 1 : 0) != 0, (Object)"Material value must be greater than 0");
        this.material = material;
        return this;
    }

    public FramingSawRecipeBuilder additive(Additive additive) {
        this.additives = additive != null ? List.of(additive) : null;
        return this;
    }

    public FramingSawRecipeBuilder additives(List<Additive> additives) {
        this.additives = additives;
        return this;
    }

    public FramingSawRecipeBuilder disabled() {
        this.disabled = true;
        return this;
    }

    public RecipeBuilder m_126132_(String criterionName, CriterionTriggerInstance criterionTrigger) {
        throw new UnsupportedOperationException("Advancements are not supported");
    }

    public RecipeBuilder m_126145_(@Nullable String groupName) {
        throw new UnsupportedOperationException("Recipe groups are not supported");
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> finishedRecipeConsumer, ResourceLocation recipeId) {
        Preconditions.checkState((this.material > 0 ? 1 : 0) != 0, (Object)"Material value not set");
        Preconditions.checkState((this.material / this.count * this.count == this.material ? 1 : 0) != 0, (Object)"Material value not divisible by result size");
        recipeId = recipeId.m_246208_("framing_saw/");
        finishedRecipeConsumer.accept(new Result(recipeId, this.result, this.count, this.material, this.additives, this.disabled));
    }

    private record Result(ResourceLocation id, Item result, int count, int material, List<Additive> additives, boolean disabled) implements FinishedRecipe
    {
        public void m_7917_(JsonObject json) {
            json.addProperty("material", (Number)this.material);
            if (this.additives != null) {
                JsonArray additiveArr = new JsonArray();
                this.additives.forEach(add -> {
                    JsonObject additive = new JsonObject();
                    additive.add("ingredient", add.additive.m_43942_());
                    additive.addProperty("count", (Number)add.count);
                    additiveArr.add((JsonElement)additive);
                });
                json.add("additives", (JsonElement)additiveArr);
            }
            JsonObject resultObj = new JsonObject();
            resultObj.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.result)).toString());
            if (this.count > 1) {
                resultObj.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)resultObj);
            if (this.disabled) {
                json.addProperty("disabled", Boolean.valueOf(true));
            }
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public ResourceLocation m_6448_() {
            return null;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)FBContent.recipeSerializerFramingSawRecipe.get();
        }
    }

    public record Additive(Ingredient additive, int count) {
        public Additive {
            Preconditions.checkArgument((additive != null ? 1 : 0) != 0, (Object)"Additive ingredient must be non-null");
            Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Additive count must be greater than 0");
        }

        public static Additive of(TagKey<Item> tag) {
            return Additive.of(tag, 1);
        }

        public static Additive of(TagKey<Item> tag, int count) {
            return new Additive(Ingredient.m_204132_(tag), count);
        }

        public static Additive of(ItemLike item) {
            return Additive.of(item, 1);
        }

        public static Additive of(ItemLike item, int count) {
            return new Additive(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), count);
        }
    }
}

