/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Locale;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.predicate.CtmPredicate;
import xfacthd.framedblocks.api.predicate.SideSkipPredicate;
import xfacthd.framedblocks.api.shapes.ShapeGenerator;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.common.block.cube.FramedCollapsibleBlock;
import xfacthd.framedblocks.common.block.cube.FramedOneWayWindowBlock;
import xfacthd.framedblocks.common.block.door.FramedDoorBlock;
import xfacthd.framedblocks.common.block.door.FramedTrapDoorBlock;
import xfacthd.framedblocks.common.block.interactive.FramedItemFrameBlock;
import xfacthd.framedblocks.common.block.interactive.FramedWallSignBlock;
import xfacthd.framedblocks.common.block.pane.FramedFloorBlock;
import xfacthd.framedblocks.common.block.pane.FramedWallBoardBlock;
import xfacthd.framedblocks.common.block.pillar.FramedCornerPillarBlock;
import xfacthd.framedblocks.common.block.pillar.FramedHalfPillarBlock;
import xfacthd.framedblocks.common.block.pillar.FramedLatticeBlock;
import xfacthd.framedblocks.common.block.pillar.FramedPillarBlock;
import xfacthd.framedblocks.common.block.prism.FramedDoublePrismBlock;
import xfacthd.framedblocks.common.block.prism.FramedDoubleSlopedPrismBlock;
import xfacthd.framedblocks.common.block.prism.FramedPrismBlock;
import xfacthd.framedblocks.common.block.prism.FramedSlopedPrismBlock;
import xfacthd.framedblocks.common.block.slab.FramedDoublePanelBlock;
import xfacthd.framedblocks.common.block.slab.FramedPanelBlock;
import xfacthd.framedblocks.common.block.slab.FramedSlabBlock;
import xfacthd.framedblocks.common.block.slab.FramedSlabCornerBlock;
import xfacthd.framedblocks.common.block.slab.FramedSlabEdgeBlock;
import xfacthd.framedblocks.common.block.slope.FramedCornerSlopeBlock;
import xfacthd.framedblocks.common.block.slope.FramedDoubleCornerBlock;
import xfacthd.framedblocks.common.block.slope.FramedDoubleHalfSlopeBlock;
import xfacthd.framedblocks.common.block.slope.FramedDoubleSlopeBlock;
import xfacthd.framedblocks.common.block.slope.FramedDoubleThreewayCornerBlock;
import xfacthd.framedblocks.common.block.slope.FramedHalfSlopeBlock;
import xfacthd.framedblocks.common.block.slope.FramedPrismCornerBlock;
import xfacthd.framedblocks.common.block.slope.FramedPyramidBlock;
import xfacthd.framedblocks.common.block.slope.FramedSlopeBlock;
import xfacthd.framedblocks.common.block.slope.FramedThreewayCornerBlock;
import xfacthd.framedblocks.common.block.slope.FramedVerticalDoubleHalfSlopeBlock;
import xfacthd.framedblocks.common.block.slope.FramedVerticalHalfSlopeBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedDoubleSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedExtendedDoubleSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedExtendedSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedFlatDoubleSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedFlatExtendedDoubleSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedFlatExtendedSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedFlatInverseDoubleSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedFlatSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedInverseDoubleSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedDoubleSlopeSlabBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedElevatedDoubleSlopeSlabBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedElevatedSlopeSlabBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedFlatDoubleSlopeSlabCornerBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedFlatElevatedDoubleSlopeSlabCornerBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedFlatElevatedSlopeSlabCornerBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedFlatInverseDoubleSlopeSlabCornerBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedFlatSlopeSlabCornerBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedInverseDoubleSlopeSlabBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedSlopeSlabBlock;
import xfacthd.framedblocks.common.block.stairs.FramedDividedStairsBlock;
import xfacthd.framedblocks.common.block.stairs.FramedDoubleStairsBlock;
import xfacthd.framedblocks.common.block.stairs.FramedHalfStairsBlock;
import xfacthd.framedblocks.common.block.stairs.FramedSlopedStairsBlock;
import xfacthd.framedblocks.common.block.stairs.FramedStairsBlock;
import xfacthd.framedblocks.common.block.stairs.FramedVerticalDividedStairsBlock;
import xfacthd.framedblocks.common.block.stairs.FramedVerticalDoubleStairsBlock;
import xfacthd.framedblocks.common.block.stairs.FramedVerticalHalfStairsBlock;
import xfacthd.framedblocks.common.block.stairs.FramedVerticalSlopedStairsBlock;
import xfacthd.framedblocks.common.block.stairs.FramedVerticalStairsBlock;
import xfacthd.framedblocks.common.data.skippreds.door.DoorSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.door.FenceGateSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.door.GateSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.door.TrapdoorSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.misc.CollapsibleBlockSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.misc.OneWayWindowSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.pane.FloorBoardSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.pane.HorizontalPaneSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.pane.PaneSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.pane.WallBoardSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.pillar.FenceSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.pillar.HalfPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.pillar.LatticeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.pillar.PillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.pillar.PostSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.pillar.WallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.prism.InnerPrismSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.prism.InnerSlopedPrismSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.prism.PrismSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.prism.SlopedPrismSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.CornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.HalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.InnerCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.InnerThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.SlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.ThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.VerticalHalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.ExtendedSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.ElevatedSlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatElevatedInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.SlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalSlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

public enum BlockType implements IBlockType
{
    FRAMED_CUBE(true, false, false, false, true, true, false, false, CtmPredicate.TRUE, SideSkipPredicate.CTM, Shapes.m_83144_()),
    FRAMED_SLOPE(true, true, false, true, true, true, false, false, FramedSlopeBlock.CTM_PREDICATE, (SideSkipPredicate)SlopeSkipPredicate.INSTANCE, FramedSlopeBlock::generateShapes),
    FRAMED_CORNER_SLOPE(true, true, false, true, true, true, false, false, FramedCornerSlopeBlock.CTM_PREDICATE, (SideSkipPredicate)new CornerSkipPredicate(), FramedCornerSlopeBlock::generateCornerShapes),
    FRAMED_INNER_CORNER_SLOPE(true, true, false, true, true, true, false, false, FramedCornerSlopeBlock.CTM_PREDICATE_INNER, (SideSkipPredicate)new InnerCornerSkipPredicate(), FramedCornerSlopeBlock::generateInnerCornerShapes),
    FRAMED_PRISM_CORNER(true, true, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new ThreewayCornerSkipPredicate(), FramedPrismCornerBlock::generatePrismShapes),
    FRAMED_INNER_PRISM_CORNER(true, true, false, true, true, true, false, false, FramedThreewayCornerBlock.CTM_PREDICATE, (SideSkipPredicate)new InnerThreewayCornerSkipPredicate(), FramedPrismCornerBlock::generateInnerPrismShapes),
    FRAMED_THREEWAY_CORNER(true, true, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new ThreewayCornerSkipPredicate(), FramedThreewayCornerBlock::generateThreewayShapes),
    FRAMED_INNER_THREEWAY_CORNER(true, true, false, true, true, true, false, false, FramedThreewayCornerBlock.CTM_PREDICATE, (SideSkipPredicate)new InnerThreewayCornerSkipPredicate(), FramedThreewayCornerBlock::generateInnerThreewayShapes),
    FRAMED_SLAB(true, false, false, true, true, true, false, false, CtmPredicate.TOP, (SideSkipPredicate)new SlabSkipPredicate(), FramedSlabBlock::generateShapes),
    FRAMED_SLAB_EDGE(false, false, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new SlabEdgeSkipPredicate(), FramedSlabEdgeBlock::generateShapes),
    FRAMED_SLAB_CORNER(false, false, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new SlabCornerSkipPredicate(), FramedSlabCornerBlock::generateShapes),
    FRAMED_DIVIDED_SLAB(true, false, true, true, true, true, true, false, FramedSlabBlock::generateShapes),
    FRAMED_PANEL(true, false, false, true, true, true, false, false, CtmPredicate.HOR_DIR, (SideSkipPredicate)new PanelSkipPredicate(), FramedPanelBlock::generateShapes),
    FRAMED_CORNER_PILLAR(false, false, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new CornerPillarSkipPredicate(), FramedCornerPillarBlock::generateShapes),
    FRAMED_DIVIDED_PANEL_HORIZONTAL(true, false, true, true, true, true, true, false, FramedPanelBlock::generateShapes),
    FRAMED_DIVIDED_PANEL_VERTICAL(true, false, true, true, true, true, true, false, FramedPanelBlock::generateShapes),
    FRAMED_STAIRS(true, false, false, true, true, true, false, true, FramedStairsBlock.CTM_PREDICATE, new StairsSkipPredicate()),
    FRAMED_DOUBLE_STAIRS(true, false, true, false, true, true, true, false, FramedDoubleStairsBlock.CTM_PREDICATE, SideSkipPredicate.FALSE, Shapes.m_83144_()),
    FRAMED_HALF_STAIRS(false, false, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new HalfStairsSkipPredicate(), FramedHalfStairsBlock::generateShapes),
    FRAMED_DIVIDED_STAIRS(true, false, true, true, true, true, true, false, FramedDividedStairsBlock::generateShapes),
    FRAMED_VERTICAL_STAIRS(true, false, false, true, true, true, false, true, FramedVerticalStairsBlock.CTM_PREDICATE, (SideSkipPredicate)new VerticalStairsSkipPredicate(), FramedVerticalStairsBlock::generateShapes),
    FRAMED_VERTICAL_DOUBLE_STAIRS(true, false, true, false, true, true, true, false, FramedVerticalDoubleStairsBlock.CTM_PREDICATE, SideSkipPredicate.FALSE, Shapes.m_83144_()),
    FRAMED_VERTICAL_HALF_STAIRS(false, false, false, true, true, false, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new VerticalHalfStairsSkipPredicate(), FramedVerticalHalfStairsBlock::generateShapes),
    FRAMED_VERTICAL_DIVIDED_STAIRS(true, false, true, true, true, true, true, false, FramedVerticalDividedStairsBlock::generateShapes),
    FRAMED_WALL(false, false, false, true, true, false, false, true, CtmPredicate.FALSE, new WallSkipPredicate()),
    FRAMED_FENCE(false, false, false, true, true, false, false, true, CtmPredicate.FALSE, new FenceSkipPredicate()),
    FRAMED_FENCE_GATE(false, false, false, true, true, false, false, false, CtmPredicate.FALSE, new FenceGateSkipPredicate()),
    FRAMED_DOOR(true, false, false, false, true, false, false, false, FramedDoorBlock.CTM_PREDICATE, new DoorSkipPredicate()),
    FRAMED_IRON_DOOR(true, false, false, false, true, false, false, false, FramedDoorBlock.CTM_PREDICATE, new DoorSkipPredicate()),
    FRAMED_TRAPDOOR(true, false, false, true, true, false, false, false, FramedTrapDoorBlock.CTM_PREDICATE, new TrapdoorSkipPredicate()),
    FRAMED_IRON_TRAPDOOR(true, false, false, true, true, false, false, false, FramedTrapDoorBlock.CTM_PREDICATE, new TrapdoorSkipPredicate()),
    FRAMED_PRESSURE_PLATE(false, false, false, false, true, false, false, false),
    FRAMED_WATERLOGGABLE_PRESSURE_PLATE(false, false, false, true, false, false, false, false),
    FRAMED_STONE_PRESSURE_PLATE(false, false, false, false, true, false, false, false),
    FRAMED_WATERLOGGABLE_STONE_PRESSURE_PLATE(false, false, false, true, false, false, false, false),
    FRAMED_OBSIDIAN_PRESSURE_PLATE(false, false, false, false, true, false, false, false),
    FRAMED_WATERLOGGABLE_OBSIDIAN_PRESSURE_PLATE(false, false, false, true, false, false, false, false),
    FRAMED_GOLD_PRESSURE_PLATE(false, false, false, false, true, false, false, false),
    FRAMED_WATERLOGGABLE_GOLD_PRESSURE_PLATE(false, false, false, true, false, false, false, false),
    FRAMED_IRON_PRESSURE_PLATE(false, false, false, false, true, false, false, false),
    FRAMED_WATERLOGGABLE_IRON_PRESSURE_PLATE(false, false, false, true, false, false, false, false),
    FRAMED_LADDER(false, false, false, true, true, false, false, false),
    FRAMED_BUTTON(false, false, false, false, true, false, false, false),
    FRAMED_STONE_BUTTON(false, false, false, false, true, false, false, false),
    FRAMED_LARGE_BUTTON(false, false, false, false, true, false, false, false),
    FRAMED_LARGE_STONE_BUTTON(false, false, false, false, true, false, false, false),
    FRAMED_LEVER(false, false, false, false, true, false, false, false),
    FRAMED_SIGN(false, false, true, false, true, false, false, false),
    FRAMED_WALL_SIGN(false, false, true, false, false, false, false, false, FramedWallSignBlock::generateShapes),
    FRAMED_DOUBLE_SLAB(true, false, true, false, true, true, true, false, CtmPredicate.Y_AXIS, Shapes.m_83144_()),
    FRAMED_DOUBLE_PANEL(true, false, true, false, true, true, true, false, FramedDoublePanelBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_DOUBLE_SLOPE(true, false, true, false, true, true, true, false, FramedDoubleSlopeBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_DOUBLE_CORNER(true, false, true, false, true, true, true, false, FramedDoubleCornerBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_DOUBLE_PRISM_CORNER(true, false, true, false, true, true, true, false, FramedDoubleThreewayCornerBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_DOUBLE_THREEWAY_CORNER(true, false, true, false, true, true, true, false, FramedDoubleThreewayCornerBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_TORCH(false, false, false, false, true, false, false, false),
    FRAMED_WALL_TORCH(false, false, false, false, false, false, false, false),
    FRAMED_SOUL_TORCH(false, false, false, false, true, false, false, false),
    FRAMED_SOUL_WALL_TORCH(false, false, false, false, false, false, false, false),
    FRAMED_REDSTONE_TORCH(false, false, false, false, true, false, false, false),
    FRAMED_REDSTONE_WALL_TORCH(false, false, false, false, false, false, false, false),
    FRAMED_FLOOR_BOARD(true, false, false, true, true, true, false, false, CtmPredicate.TOP, (SideSkipPredicate)new FloorBoardSkipPredicate(), FramedFloorBlock::generateShapes),
    FRAMED_WALL_BOARD(true, false, false, true, true, true, false, false, CtmPredicate.HOR_DIR, (SideSkipPredicate)new WallBoardSkipPredicate(), FramedWallBoardBlock::generateShapes),
    FRAMED_LATTICE_BLOCK(false, false, false, true, true, true, false, true, CtmPredicate.FALSE, (SideSkipPredicate)new LatticeSkipPredicate(), FramedLatticeBlock::generateShapes),
    FRAMED_CHEST(false, false, true, true, true, false, false, false, Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.875, (double)0.9375)),
    FRAMED_SECRET_STORAGE(true, false, true, false, true, false, false, false, CtmPredicate.TRUE, SideSkipPredicate.CTM, Shapes.m_83144_()),
    FRAMED_BARS(false, false, false, true, true, true, false, true),
    FRAMED_PANE(false, false, false, true, true, true, false, true, CtmPredicate.FALSE, new PaneSkipPredicate()),
    FRAMED_HORIZONTAL_PANE(true, false, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new HorizontalPaneSkipPredicate(), Shapes.m_83048_((double)0.0, (double)0.4375, (double)0.0, (double)1.0, (double)0.5625, (double)1.0)),
    FRAMED_RAIL_SLOPE(true, true, false, true, true, false, false, false, FramedSlopeBlock.CTM_PREDICATE, (SideSkipPredicate)SlopeSkipPredicate.INSTANCE, FramedSlopeBlock::generateShapes),
    FRAMED_POWERED_RAIL_SLOPE(true, true, false, true, true, false, false, false, FramedSlopeBlock.CTM_PREDICATE, (SideSkipPredicate)SlopeSkipPredicate.INSTANCE, FramedSlopeBlock::generateShapes),
    FRAMED_DETECTOR_RAIL_SLOPE(true, true, false, true, true, false, false, false, FramedSlopeBlock.CTM_PREDICATE, (SideSkipPredicate)SlopeSkipPredicate.INSTANCE, FramedSlopeBlock::generateShapes),
    FRAMED_ACTIVATOR_RAIL_SLOPE(true, true, false, true, true, false, false, false, FramedSlopeBlock.CTM_PREDICATE, (SideSkipPredicate)SlopeSkipPredicate.INSTANCE, FramedSlopeBlock::generateShapes),
    FRAMED_FLOWER_POT(false, false, true, false, true, false, false, false, Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.375, (double)0.6875)),
    FRAMED_PILLAR(false, false, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new PillarSkipPredicate(), FramedPillarBlock::generatePillarShapes),
    FRAMED_HALF_PILLAR(false, false, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new HalfPillarSkipPredicate(), FramedHalfPillarBlock::generateShapes),
    FRAMED_POST(false, false, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new PostSkipPredicate(), FramedPillarBlock::generatePostShapes),
    FRAMED_COLLAPSIBLE_BLOCK(false, true, true, true, true, true, false, false, FramedCollapsibleBlock.CTM_PREDICATE, new CollapsibleBlockSkipPredicate()),
    FRAMED_BOUNCY_CUBE(true, false, false, false, true, false, false, false, CtmPredicate.TRUE, SideSkipPredicate.CTM, Shapes.m_83144_()),
    FRAMED_REDSTONE_BLOCK(true, false, false, false, true, true, false, false, CtmPredicate.TRUE, SideSkipPredicate.CTM, Shapes.m_83144_()),
    FRAMED_PRISM(true, true, false, true, true, true, false, false, FramedPrismBlock.CTM_PREDICATE, (SideSkipPredicate)new PrismSkipPredicate(), FramedPrismBlock::generateShapes),
    FRAMED_INNER_PRISM(true, true, false, true, true, true, false, false, FramedPrismBlock.CTM_PREDICATE_INNER, (SideSkipPredicate)new InnerPrismSkipPredicate(), FramedPrismBlock::generateInnerShapes),
    FRAMED_DOUBLE_PRISM(true, false, true, false, true, true, true, false, FramedDoublePrismBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_SLOPED_PRISM(true, true, false, true, true, true, false, false, FramedSlopedPrismBlock.CTM_PREDICATE, (SideSkipPredicate)new SlopedPrismSkipPredicate(), FramedSlopedPrismBlock::generateShapes),
    FRAMED_INNER_SLOPED_PRISM(true, true, false, true, true, true, false, false, FramedSlopedPrismBlock.CTM_PREDICATE_INNER, (SideSkipPredicate)new InnerSlopedPrismSkipPredicate(), FramedSlopedPrismBlock::generateInnerShapes),
    FRAMED_DOUBLE_SLOPED_PRISM(true, false, true, false, true, true, true, false, FramedDoubleSlopedPrismBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_SLOPE_SLAB(true, true, false, true, true, true, false, false, FramedSlopeSlabBlock.CTM_PREDICATE, (SideSkipPredicate)new SlopeSlabSkipPredicate(), FramedSlopeSlabBlock::generateShapes),
    FRAMED_ELEVATED_SLOPE_SLAB(true, true, true, true, true, true, false, false, FramedElevatedSlopeSlabBlock.CTM_PREDICATE, (SideSkipPredicate)new ElevatedSlopeSlabSkipPredicate(), FramedElevatedSlopeSlabBlock::generateShapes),
    FRAMED_DOUBLE_SLOPE_SLAB(true, false, true, true, true, true, true, false, FramedDoubleSlopeSlabBlock.CTM_PREDICATE, SideSkipPredicate.FALSE),
    FRAMED_INV_DOUBLE_SLOPE_SLAB(true, true, true, true, true, true, true, false, FramedInverseDoubleSlopeSlabBlock::generateShapes),
    FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB(true, false, true, false, true, true, true, false, FramedElevatedDoubleSlopeSlabBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_STACKED_SLOPE_SLAB(true, true, true, true, true, true, true, false, CtmPredicate.TOP, FramedElevatedSlopeSlabBlock::generateShapes),
    FRAMED_FLAT_SLOPE_SLAB_CORNER(true, true, false, true, true, true, false, false, FramedFlatSlopeSlabCornerBlock.CTM_PREDICATE, (SideSkipPredicate)new FlatSlopeSlabCornerSkipPredicate(), FramedFlatSlopeSlabCornerBlock::generateShapes),
    FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER(true, true, false, true, true, true, false, false, FramedFlatSlopeSlabCornerBlock.CTM_PREDICATE, (SideSkipPredicate)new FlatInnerSlopeSlabCornerSkipPredicate(), FramedFlatSlopeSlabCornerBlock::generateInnerShapes),
    FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER(true, true, false, true, true, true, false, false, FramedFlatElevatedSlopeSlabCornerBlock.CTM_PREDICATE, (SideSkipPredicate)new FlatElevatedSlopeSlabCornerSkipPredicate(), FramedFlatElevatedSlopeSlabCornerBlock::generateShapes),
    FRAMED_FLAT_ELEV_INNER_SLOPE_SLAB_CORNER(true, true, false, true, true, true, false, false, FramedFlatElevatedSlopeSlabCornerBlock.CTM_PREDICATE_INNER, (SideSkipPredicate)new FlatElevatedInnerSlopeSlabCornerSkipPredicate(), FramedFlatElevatedSlopeSlabCornerBlock::generateInnerShapes),
    FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER(true, false, true, true, true, true, true, false, FramedFlatDoubleSlopeSlabCornerBlock.CTM_PREDICATE, FramedFlatDoubleSlopeSlabCornerBlock::generateShapes),
    FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER(true, true, true, true, true, true, true, false, FramedFlatInverseDoubleSlopeSlabCornerBlock::generateShapes),
    FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER(true, false, true, false, true, true, true, false, CtmPredicate.Y_AXIS, Shapes.m_83144_()),
    FRAMED_FLAT_ELEV_INNER_DOUBLE_SLOPE_SLAB_CORNER(true, false, true, false, true, true, true, false, FramedFlatElevatedDoubleSlopeSlabCornerBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER(true, true, true, true, true, true, true, false, CtmPredicate.TOP, FramedFlatElevatedSlopeSlabCornerBlock::generateShapes),
    FRAMED_FLAT_STACKED_INNER_SLOPE_SLAB_CORNER(true, true, true, true, true, true, true, false, CtmPredicate.TOP, FramedFlatElevatedSlopeSlabCornerBlock::generateInnerShapes),
    FRAMED_SLOPE_PANEL(true, true, false, true, true, true, false, false, FramedSlopePanelBlock.CTM_PREDICATE, (SideSkipPredicate)new SlopePanelSkipPredicate(), FramedSlopePanelBlock::generateShapes),
    FRAMED_EXTENDED_SLOPE_PANEL(true, true, true, true, true, true, false, false, FramedExtendedSlopePanelBlock.CTM_PREDICATE, (SideSkipPredicate)new ExtendedSlopePanelSkipPredicate(), FramedExtendedSlopePanelBlock::generateShapes),
    FRAMED_DOUBLE_SLOPE_PANEL(true, false, true, true, true, true, true, false, FramedDoubleSlopePanelBlock.CTM_PREDICATE, FramedDoubleSlopePanelBlock::generateShapes),
    FRAMED_INV_DOUBLE_SLOPE_PANEL(true, true, true, true, true, true, true, false, FramedInverseDoubleSlopePanelBlock::generateShapes),
    FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL(true, false, true, false, true, true, true, false, FramedExtendedDoubleSlopePanelBlock.CTM_PREDICATE, SideSkipPredicate.FALSE, Shapes.m_83144_()),
    FRAMED_STACKED_SLOPE_PANEL(true, true, true, true, true, true, true, false, CtmPredicate.HOR_DIR, FramedExtendedSlopePanelBlock::generateShapes),
    FRAMED_FLAT_SLOPE_PANEL_CORNER(true, true, false, true, true, true, false, false, FramedSlopePanelBlock.CTM_PREDICATE, (SideSkipPredicate)new FlatSlopePanelCornerSkipPredicate(), FramedFlatSlopePanelCornerBlock::generateShapes),
    FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER(true, true, false, true, true, true, false, false, FramedSlopePanelBlock.CTM_PREDICATE, (SideSkipPredicate)new FlatInnerSlopePanelCornerSkipPredicate(), FramedFlatSlopePanelCornerBlock::generateInnerShapes),
    FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER(true, true, false, true, true, true, false, false, CtmPredicate.HOR_DIR, (SideSkipPredicate)new FlatExtendedSlopePanelCornerSkipPredicate(), FramedFlatExtendedSlopePanelCornerBlock::generateShapes),
    FRAMED_FLAT_EXT_INNER_SLOPE_PANEL_CORNER(true, true, false, true, true, true, false, false, FramedFlatExtendedSlopePanelCornerBlock.CTM_PREDICATE, (SideSkipPredicate)new FlatExtendedInnerSlopePanelCornerSkipPredicate(), FramedFlatExtendedSlopePanelCornerBlock::generateInnerShapes),
    FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER(true, false, true, true, true, true, true, false, FramedFlatDoubleSlopePanelCornerBlock.CTM_PREDICATE, FramedFlatDoubleSlopePanelCornerBlock::generateShapes),
    FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER(true, true, true, true, true, true, true, false, FramedFlatInverseDoubleSlopePanelCornerBlock::generateShapes),
    FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER(true, false, true, false, true, true, true, false, CtmPredicate.HOR_DIR_AXIS, Shapes.m_83144_()),
    FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER(true, false, true, false, true, true, true, false, FramedFlatExtendedDoubleSlopePanelCornerBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_FLAT_STACKED_SLOPE_PANEL_CORNER(true, true, true, true, true, true, true, false, CtmPredicate.HOR_DIR, FramedFlatExtendedSlopePanelCornerBlock::generateShapes),
    FRAMED_FLAT_STACKED_INNER_SLOPE_PANEL_CORNER(true, true, true, true, true, true, true, false, CtmPredicate.HOR_DIR, FramedFlatExtendedSlopePanelCornerBlock::generateInnerShapes),
    FRAMED_GLOWING_CUBE(true, false, false, false, true, true, false, false, CtmPredicate.TRUE, SideSkipPredicate.CTM, Shapes.m_83144_()),
    FRAMED_PYRAMID(true, true, false, true, true, true, false, false, CtmPredicate.DIR_OPPOSITE, SideSkipPredicate.CTM, FramedPyramidBlock::generateShapes),
    FRAMED_PYRAMID_SLAB(true, true, false, true, true, true, false, false, CtmPredicate.DIR_OPPOSITE, SideSkipPredicate.CTM, FramedPyramidBlock::generateSlabShapes),
    FRAMED_TARGET(true, false, true, false, true, true, false, false, CtmPredicate.TRUE, SideSkipPredicate.CTM, Shapes.m_83144_()),
    FRAMED_GATE(true, false, false, false, true, false, false, false, FramedDoorBlock.CTM_PREDICATE, new GateSkipPredicate()),
    FRAMED_IRON_GATE(true, false, false, false, true, false, false, false, FramedDoorBlock.CTM_PREDICATE, new GateSkipPredicate()),
    FRAMED_ITEM_FRAME(false, true, true, false, true, false, false, false, FramedItemFrameBlock::generateShapes),
    FRAMED_GLOWING_ITEM_FRAME(false, true, true, false, true, false, false, false, FramedItemFrameBlock::generateShapes),
    FRAMED_FANCY_RAIL(false, false, false, true, true, false, false, false, CtmPredicate.FALSE, SideSkipPredicate.FALSE),
    FRAMED_FANCY_POWERED_RAIL(false, false, false, true, true, false, false, false, CtmPredicate.FALSE, SideSkipPredicate.FALSE),
    FRAMED_FANCY_DETECTOR_RAIL(false, false, false, true, true, false, false, false, CtmPredicate.FALSE, SideSkipPredicate.FALSE),
    FRAMED_FANCY_ACTIVATOR_RAIL(false, false, false, true, true, false, false, false, CtmPredicate.FALSE, SideSkipPredicate.FALSE),
    FRAMED_FANCY_RAIL_SLOPE(true, true, false, true, true, false, true, false, CtmPredicate.FALSE, SideSkipPredicate.FALSE, FramedSlopeBlock::generateShapes),
    FRAMED_FANCY_POWERED_RAIL_SLOPE(true, true, false, true, true, false, true, false, CtmPredicate.FALSE, SideSkipPredicate.FALSE, FramedSlopeBlock::generateShapes),
    FRAMED_FANCY_DETECTOR_RAIL_SLOPE(true, true, false, true, true, false, true, false, CtmPredicate.FALSE, SideSkipPredicate.FALSE, FramedSlopeBlock::generateShapes),
    FRAMED_FANCY_ACTIVATOR_RAIL_SLOPE(true, true, false, true, true, false, true, false, CtmPredicate.FALSE, SideSkipPredicate.FALSE, FramedSlopeBlock::generateShapes),
    FRAMED_HALF_SLOPE(false, true, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new HalfSlopeSkipPredicate(), FramedHalfSlopeBlock::generateShapes),
    FRAMED_VERTICAL_HALF_SLOPE(false, true, false, true, false, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new VerticalHalfSlopeSkipPredicate(), FramedVerticalHalfSlopeBlock::generateShapes),
    FRAMED_DIVIDED_SLOPE(true, true, true, true, true, true, true, false, FramedSlopeBlock::generateShapes),
    FRAMED_DOUBLE_HALF_SLOPE(true, false, true, true, true, true, true, false, FramedDoubleHalfSlopeBlock::generateShapes),
    FRAMED_VERTICAL_DOUBLE_HALF_SLOPE(true, false, true, true, false, true, true, false, FramedVerticalDoubleHalfSlopeBlock::generateShapes),
    FRAMED_SLOPED_STAIRS(true, true, false, true, true, true, false, false, FramedSlopedStairsBlock.CTM_PREDICATE, (SideSkipPredicate)new SlopedStairsSkipPredicate(), FramedSlopedStairsBlock::generateShapes),
    FRAMED_VERTICAL_SLOPED_STAIRS(true, true, false, true, true, true, false, false, FramedVerticalSlopedStairsBlock.CTM_PREDICATE, (SideSkipPredicate)new VerticalSlopedStairsSkipPredicate(), FramedVerticalSlopedStairsBlock::generateShapes),
    FRAMED_MINI_CUBE(false, false, false, true, true, true, false, false, Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)),
    FRAMED_ONE_WAY_WINDOW(false, false, true, false, true, false, false, false, FramedOneWayWindowBlock.CTM_PREDICATE, (SideSkipPredicate)new OneWayWindowSkipPredicate(), Shapes.m_83144_());

    private final String name = this.toString().toLowerCase(Locale.ROOT);
    private final boolean canOcclude;
    private final boolean specialHitbox;
    private final boolean specialTile;
    private final boolean waterloggable;
    private final boolean blockItem;
    private final boolean allowIntangible;
    private final boolean doubleBlock;
    private final boolean lockable;
    private final CtmPredicate ctmPredicate;
    private final SideSkipPredicate skipPredicate;
    private final ShapeGenerator shapeGen;

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, CtmPredicate.FALSE, SideSkipPredicate.FALSE, ShapeGenerator.EMPTY);
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, VoxelShape shape) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, CtmPredicate.FALSE, SideSkipPredicate.FALSE, shape);
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, ShapeGenerator shapeGen) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, CtmPredicate.FALSE, SideSkipPredicate.FALSE, shapeGen);
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, CtmPredicate ctmPredicate, VoxelShape shape) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, ctmPredicate, SideSkipPredicate.FALSE, shape);
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, CtmPredicate ctmPredicate, ShapeGenerator shapeGen) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, ctmPredicate, SideSkipPredicate.FALSE, shapeGen);
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, CtmPredicate ctmPredicate, SideSkipPredicate skipPredicate) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, ctmPredicate, skipPredicate, ShapeGenerator.EMPTY);
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, CtmPredicate ctmPredicate, SideSkipPredicate skipPredicate, VoxelShape shape) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, ctmPredicate, skipPredicate, ShapeGenerator.singleShape(shape));
        Preconditions.checkArgument((!waterloggable || !Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83144_(), (BooleanOp)BooleanOp.f_82687_).m_83281_() ? 1 : 0) != 0, (Object)"Blocks with full cube shape can't be waterloggable");
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, CtmPredicate ctmPredicate, SideSkipPredicate skipPredicate, ShapeGenerator shapeGen) {
        this.canOcclude = canOcclude;
        this.specialHitbox = specialHitbox;
        this.specialTile = specialTile;
        this.waterloggable = waterloggable;
        this.blockItem = blockItem;
        this.allowIntangible = allowIntangible;
        this.doubleBlock = doubleBlock;
        this.lockable = lockable;
        this.ctmPredicate = ctmPredicate;
        this.skipPredicate = skipPredicate;
        this.shapeGen = shapeGen;
    }

    @Override
    public boolean canOccludeWithSolidCamo() {
        return this.canOcclude;
    }

    @Override
    public boolean hasSpecialHitbox() {
        return this.specialHitbox;
    }

    @Override
    public CtmPredicate getCtmPredicate() {
        return this.ctmPredicate;
    }

    @Override
    public SideSkipPredicate getSideSkipPredicate() {
        return this.skipPredicate;
    }

    @Override
    public ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        return this.shapeGen.generate(states);
    }

    @Override
    public boolean hasSpecialTile() {
        return this.specialTile;
    }

    @Override
    public boolean hasBlockItem() {
        return this.blockItem;
    }

    @Override
    public boolean supportsWaterLogging() {
        return this.waterloggable;
    }

    @Override
    public boolean allowMakingIntangible() {
        return this.allowIntangible;
    }

    @Override
    public boolean isDoubleBlock() {
        return this.doubleBlock;
    }

    @Override
    public boolean canLockState() {
        return this.lockable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(IBlockType other) {
        if (!(other instanceof BlockType)) {
            return 1;
        }
        BlockType type = (BlockType)other;
        return this.compareTo(type);
    }
}

