/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.prism;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CompoundDirection;
import xfacthd.framedblocks.common.data.property.DirectionAxis;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.prism.InnerPrismSkipPredicate;

public final class InnerSlopedPrismSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.m_61143_(PropertyHolder.FACING_DIR));
        Direction orientation = cmpDir.orientation();
        if (side != orientation) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        if (orientation.m_122434_() == cmpDir.direction().m_122434_()) {
            return false;
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_INNER_SLOPED_PRISM -> InnerSlopedPrismSkipPredicate.testAgainstInnerSlopedPrism(level, pos, state, cmpDir, adjState, side);
                case BlockType.FRAMED_INNER_PRISM -> InnerSlopedPrismSkipPredicate.testAgainstInnerPrism(level, pos, state, cmpDir, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPED_PRISM -> InnerSlopedPrismSkipPredicate.testAgainstDoubleSlopedPrism(level, pos, state, cmpDir, adjState, side);
                case BlockType.FRAMED_DOUBLE_PRISM -> InnerSlopedPrismSkipPredicate.testAgainstDoublePrism(level, pos, state, cmpDir, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstInnerSlopedPrism(BlockGetter level, BlockPos pos, BlockState state, CompoundDirection cmpDir, BlockState adjState, Direction side) {
        CompoundDirection adjCmpDir = (CompoundDirection)((Object)adjState.m_61143_(PropertyHolder.FACING_DIR));
        if (InnerSlopedPrismSkipPredicate.getTriDir(cmpDir, side).isEqualTo(InnerSlopedPrismSkipPredicate.getTriDir(adjCmpDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstInnerPrism(BlockGetter level, BlockPos pos, BlockState state, CompoundDirection cmpDir, BlockState adjState, Direction side) {
        DirectionAxis adjDirAxis = (DirectionAxis)((Object)adjState.m_61143_(PropertyHolder.FACING_AXIS));
        if (InnerSlopedPrismSkipPredicate.getTriDir(cmpDir, side).isEqualTo(InnerPrismSkipPredicate.getTriDir(adjDirAxis, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopedPrism(BlockGetter level, BlockPos pos, BlockState state, CompoundDirection cmpDir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return InnerSlopedPrismSkipPredicate.testAgainstInnerSlopedPrism(level, pos, state, cmpDir, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstDoublePrism(BlockGetter level, BlockPos pos, BlockState state, CompoundDirection cmpDir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return InnerSlopedPrismSkipPredicate.testAgainstInnerPrism(level, pos, state, cmpDir, (BlockState)states.m_14418_(), side);
    }

    public static HalfDir getTriDir(CompoundDirection cmpDir, Direction side) {
        Direction dir = cmpDir.direction();
        Direction orientation = cmpDir.orientation();
        if (dir.m_122434_() != orientation.m_122434_() && side == orientation) {
            return HalfDir.fromDirections(side, dir);
        }
        return HalfDir.NULL;
    }
}

