/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.prism;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CompoundDirection;
import xfacthd.framedblocks.common.data.property.DirectionAxis;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.prism.SlopedPrismSkipPredicate;

public final class PrismSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        DirectionAxis dirAxis = (DirectionAxis)((Object)state.m_61143_(PropertyHolder.FACING_AXIS));
        Direction dir = dirAxis.direction();
        if (side == dir.m_122424_()) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Direction.Axis axis = dirAxis.axis();
        if (axis == dir.m_122434_() || side.m_122434_() != axis) {
            return false;
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_PRISM -> PrismSkipPredicate.testAgainstPrism(level, pos, state, dirAxis, adjState, side);
                case BlockType.FRAMED_SLOPED_PRISM -> PrismSkipPredicate.testAgainstSlopedPrism(level, pos, state, dirAxis, adjState, side);
                case BlockType.FRAMED_DOUBLE_PRISM -> PrismSkipPredicate.testAgainstDoublePrism(level, pos, state, dirAxis, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPED_PRISM -> PrismSkipPredicate.testAgainstDoubleSlopedPrism(level, pos, state, dirAxis, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstPrism(BlockGetter level, BlockPos pos, BlockState state, DirectionAxis dirAxis, BlockState adjState, Direction side) {
        DirectionAxis adjDirAxis = (DirectionAxis)((Object)adjState.m_61143_(PropertyHolder.FACING_AXIS));
        if (PrismSkipPredicate.getTriDir(dirAxis, side).isEqualTo(PrismSkipPredicate.getTriDir(adjDirAxis, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstSlopedPrism(BlockGetter level, BlockPos pos, BlockState state, DirectionAxis dirAxis, BlockState adjState, Direction side) {
        CompoundDirection adjCmpDir = (CompoundDirection)((Object)adjState.m_61143_(PropertyHolder.FACING_DIR));
        if (PrismSkipPredicate.getTriDir(dirAxis, side).isEqualTo(SlopedPrismSkipPredicate.getTriDir(adjCmpDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoublePrism(BlockGetter level, BlockPos pos, BlockState state, DirectionAxis dirAxis, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PrismSkipPredicate.testAgainstPrism(level, pos, state, dirAxis, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstDoubleSlopedPrism(BlockGetter level, BlockPos pos, BlockState state, DirectionAxis dirAxis, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PrismSkipPredicate.testAgainstSlopedPrism(level, pos, state, dirAxis, (BlockState)states.m_14418_(), side);
    }

    public static HalfDir getTriDir(DirectionAxis dirAxis, Direction side) {
        Direction dir = dirAxis.direction();
        Direction.Axis axis = dirAxis.axis();
        if (dir.m_122434_() != axis && side.m_122434_() == axis) {
            return HalfDir.fromDirections(side, dir);
        }
        return HalfDir.NULL;
    }
}

