/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CornerDir;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.slab.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.HalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.VerticalHalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.ExtendedSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.ElevatedSlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.SlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalSlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

public final class SlabEdgeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            return switch (type) {
                case BlockType.FRAMED_SLAB_EDGE -> SlabEdgeSkipPredicate.testAgainstEdge(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLAB -> SlabEdgeSkipPredicate.testAgainstDividedSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL -> SlabEdgeSkipPredicate.testAgainstDividedPanelHor(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_SLAB -> SlabEdgeSkipPredicate.testAgainstSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLAB -> SlabEdgeSkipPredicate.testAgainstDoubleSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> SlabEdgeSkipPredicate.testAgainstCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_PANEL -> SlabEdgeSkipPredicate.testAgainstPanel(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> SlabEdgeSkipPredicate.testAgainstDoublePanel(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_STAIRS -> SlabEdgeSkipPredicate.testAgainstStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> SlabEdgeSkipPredicate.testAgainstDoubleStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> SlabEdgeSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> SlabEdgeSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_STAIRS -> SlabEdgeSkipPredicate.testAgainstDividedStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> SlabEdgeSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> SlabEdgeSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> SlabEdgeSkipPredicate.testAgainstDoubleSlopeSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> SlabEdgeSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB -> SlabEdgeSkipPredicate.testAgainstElevatedDoubleSlopeSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_STACKED_SLOPE_SLAB -> SlabEdgeSkipPredicate.testAgainstStackedSlopeSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatDoubleSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatInverseDoubleSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatElevatedDoubleSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatStackedSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_SLAB_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatStackedInnerSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> SlabEdgeSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DIVIDED_STAIRS -> SlabEdgeSkipPredicate.testAgainstVerticalDividedStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> SlabEdgeSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> SlabEdgeSkipPredicate.testAgainstExtendedSlopePanel(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> SlabEdgeSkipPredicate.testAgainstDoubleSlopePanel(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> SlabEdgeSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> SlabEdgeSkipPredicate.testAgainstExtendedDoubleSlopePanel(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_STACKED_SLOPE_PANEL -> SlabEdgeSkipPredicate.testAgainstStackedSlopePanel(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_SLOPE_PANEL_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatStackedSlopePanelCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_PANEL_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatStackedInnerSlopePanelCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_HALF_SLOPE -> SlabEdgeSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_SLOPE -> SlabEdgeSkipPredicate.testAgainstVerticalHalfSlope(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> SlabEdgeSkipPredicate.testAgainstDividedSlope(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_HALF_SLOPE -> SlabEdgeSkipPredicate.testAgainstDoubleHalfSlope(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_HALF_SLOPE -> SlabEdgeSkipPredicate.testAgainstVerticalDoubleHalfSlope(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> SlabEdgeSkipPredicate.testAgainstSlopedStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> SlabEdgeSkipPredicate.testAgainstVerticalSlopedStairs(level, pos, state, dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstEdge(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (SlabEdgeSkipPredicate.getCornerDir(dir, top, side).isEqualTo(SlabEdgeSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstEdge(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstEdge(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDividedPanelHor(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstEdge(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstEdge(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(SlabSkipPredicate.getHalfDir(adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstSlab(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (SlabEdgeSkipPredicate.getCornerDir(dir, top, side).isEqualTo(SlabCornerSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(PanelSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstPanel(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstPanel(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        Half adjHalf = (Half)adjState.m_61143_((Property)BlockStateProperties.f_61402_);
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (SlabEdgeSkipPredicate.getCornerDir(dir, top, side).isEqualTo(StairsSkipPredicate.getCornerDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstStairs(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstEdge(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(VerticalStairsSkipPredicate.getHalfDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (SlabEdgeSkipPredicate.getCornerDir(dir, top, side).isEqualTo(VerticalStairsSkipPredicate.getCornerDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(HalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (SlabEdgeSkipPredicate.getCornerDir(dir, top, side).isEqualTo(HalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(SlopeSlabSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstElevatedSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(ElevatedSlopeSlabSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstElevatedDoubleSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstStackedSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(FlatElevatedSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatInverseDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatElevatedDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatStackedSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatStackedInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(VerticalHalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (SlabEdgeSkipPredicate.getCornerDir(dir, top, side).isEqualTo(VerticalHalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalDividedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(SlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstExtendedDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstExtendedSlopePanel(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstStackedSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstPanel(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, top, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, top, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatStackedSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstPanel(level, pos, state, dir, top, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatStackedInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstPanel(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(HalfSlopeSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(VerticalHalfSlopeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return SlabEdgeSkipPredicate.testAgainstVerticalHalfSlope(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstVerticalHalfSlope(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
        }
        return SlabEdgeSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDoubleHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalDoubleHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabEdgeSkipPredicate.testAgainstVerticalHalfSlope(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabEdgeSkipPredicate.testAgainstVerticalHalfSlope(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlopedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(SlopedStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalSlopedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (SlabEdgeSkipPredicate.getHalfDir(dir, top, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    public static HalfDir getHalfDir(Direction dir, boolean top, Direction side) {
        if (side == dir) {
            return HalfDir.fromDirections(dir, top ? Direction.UP : Direction.DOWN);
        }
        if (!top && side == Direction.DOWN || top && side == Direction.UP) {
            return HalfDir.fromDirections(side, dir);
        }
        return HalfDir.NULL;
    }

    public static CornerDir getCornerDir(Direction dir, boolean top, Direction side) {
        if (side == dir.m_122428_() || side == dir.m_122427_()) {
            return CornerDir.fromDirections(side, dir, top ? Direction.UP : Direction.DOWN);
        }
        return CornerDir.NULL;
    }
}

