/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopeslab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.HalfTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatElevatedInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.SlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;

public final class ElevatedSlopeSlabSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        if (side == dir || top && side == Direction.UP || !top && side == Direction.DOWN) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstDoubleSlopeSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstElevatedDoubleSlopeSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_STACKED_SLOPE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstStackedSlopeSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_INNER_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatElevatedInnerSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatDoubleSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatInverseDoubleSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatElevatedDoubleSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_INNER_DOUBLE_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatElevatedInnerDoubleSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatStackedSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatStackedInnerSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstDoubleSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> ElevatedSlopeSlabSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstDividedSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL -> ElevatedSlopeSlabSkipPredicate.testAgainstDividedPanelHor(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_STAIRS -> ElevatedSlopeSlabSkipPredicate.testAgainstStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> ElevatedSlopeSlabSkipPredicate.testAgainstDoubleStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS, BlockType.FRAMED_VERTICAL_HALF_SLOPE -> ElevatedSlopeSlabSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DIVIDED_STAIRS -> ElevatedSlopeSlabSkipPredicate.testAgainstVerticalDividedStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> ElevatedSlopeSlabSkipPredicate.testAgainstDividedSlope(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_HALF_SLOPE -> ElevatedSlopeSlabSkipPredicate.testAgainstVerticalDoubleHalfSlope(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> ElevatedSlopeSlabSkipPredicate.testAgainstSlopedStairs(level, pos, state, dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstElevatedSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (ElevatedSlopeSlabSkipPredicate.getTriDir(dir, top, side).isEqualTo(ElevatedSlopeSlabSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(ElevatedSlopeSlabSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(SlopeSlabSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ElevatedSlopeSlabSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || ElevatedSlopeSlabSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ElevatedSlopeSlabSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || ElevatedSlopeSlabSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstElevatedDoubleSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ElevatedSlopeSlabSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || ElevatedSlopeSlabSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstStackedSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ElevatedSlopeSlabSkipPredicate.testAgainstSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || ElevatedSlopeSlabSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(FlatElevatedSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (ElevatedSlopeSlabSkipPredicate.getTriDir(dir, top, side).isEqualTo(FlatElevatedSlopeSlabCornerSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (ElevatedSlopeSlabSkipPredicate.getTriDir(dir, top, side).isEqualTo(FlatElevatedInnerSlopeSlabCornerSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ElevatedSlopeSlabSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatInverseDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ElevatedSlopeSlabSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatElevatedDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ElevatedSlopeSlabSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || ElevatedSlopeSlabSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatElevatedInnerDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ElevatedSlopeSlabSkipPredicate.testAgainstFlatElevatedInnerSlopeSlabCorner(level, pos, state, dir, top, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatStackedSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ElevatedSlopeSlabSkipPredicate.testAgainstSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatStackedInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ElevatedSlopeSlabSkipPredicate.testAgainstSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || ElevatedSlopeSlabSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(SlabSkipPredicate.getHalfDir(adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ElevatedSlopeSlabSkipPredicate.testAgainstSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || ElevatedSlopeSlabSkipPredicate.testAgainstSlab(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ElevatedSlopeSlabSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || ElevatedSlopeSlabSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDividedPanelHor(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ElevatedSlopeSlabSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || ElevatedSlopeSlabSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        Half adjHalf = (Half)adjState.m_61143_((Property)BlockStateProperties.f_61402_);
        if (ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ElevatedSlopeSlabSkipPredicate.testAgainstStairs(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || ElevatedSlopeSlabSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(VerticalHalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalDividedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ElevatedSlopeSlabSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || ElevatedSlopeSlabSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDividedSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) != SlopeType.HORIZONTAL) {
            return false;
        }
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ElevatedSlopeSlabSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || ElevatedSlopeSlabSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalDoubleHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ElevatedSlopeSlabSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || ElevatedSlopeSlabSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlopedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(SlopedStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    public static HalfTriangleDir getTriDir(Direction dir, boolean top, Direction side) {
        if (side.m_122434_() == dir.m_122427_().m_122434_()) {
            Direction longEdge = top ? Direction.UP : Direction.DOWN;
            return HalfTriangleDir.fromDirections(longEdge, dir, false);
        }
        return HalfTriangleDir.NULL;
    }

    public static HalfDir getHalfDir(Direction dir, boolean top, Direction side) {
        if (side == dir.m_122424_()) {
            return HalfDir.fromDirections(side, top ? Direction.UP : Direction.DOWN);
        }
        return HalfDir.NULL;
    }
}

