/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.stairs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.TriangleDir;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.CornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.HalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.InnerCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.InnerThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.SlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.ThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.ExtendedSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;
import xfacthd.framedblocks.common.util.FramedUtils;

public final class VerticalSlopedStairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        Direction rotDir = rot.withFacing(dir);
        if (side == dir || side == rotDir.m_122424_() || side == rot.rotate(Rotation.CLOCKWISE_90).withFacing(dir)) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            return switch (blockType) {
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> VerticalSlopedStairsSkipPredicate.testAgainstVerticalSlopedStairs(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_HALF_SLOPE -> VerticalSlopedStairsSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_HALF_SLOPE -> VerticalSlopedStairsSkipPredicate.testAgainstDoubleHalfSlope(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> VerticalSlopedStairsSkipPredicate.testAgainstDividedSlope(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_SLOPE, BlockType.FRAMED_RAIL_SLOPE, BlockType.FRAMED_POWERED_RAIL_SLOPE, BlockType.FRAMED_DETECTOR_RAIL_SLOPE, BlockType.FRAMED_ACTIVATOR_RAIL_SLOPE, BlockType.FRAMED_FANCY_RAIL_SLOPE, BlockType.FRAMED_FANCY_POWERED_RAIL_SLOPE, BlockType.FRAMED_FANCY_DETECTOR_RAIL_SLOPE, BlockType.FRAMED_FANCY_ACTIVATOR_RAIL_SLOPE -> VerticalSlopedStairsSkipPredicate.testAgainstSlope(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE -> VerticalSlopedStairsSkipPredicate.testAgainstDoubleSlope(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_CORNER_SLOPE -> VerticalSlopedStairsSkipPredicate.testAgainstCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_INNER_CORNER_SLOPE -> VerticalSlopedStairsSkipPredicate.testAgainstInnerCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstDoubleCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_PRISM_CORNER, BlockType.FRAMED_THREEWAY_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstThreewayCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_INNER_PRISM_CORNER, BlockType.FRAMED_INNER_THREEWAY_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstInnerThreewayCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_PRISM_CORNER, BlockType.FRAMED_DOUBLE_THREEWAY_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstDoubleThreewayCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> VerticalSlopedStairsSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLAB -> VerticalSlopedStairsSkipPredicate.testAgainstDividedSlab(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL -> VerticalSlopedStairsSkipPredicate.testAgainstDividedPanelHor(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_PANEL -> VerticalSlopedStairsSkipPredicate.testAgainstPanel(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> VerticalSlopedStairsSkipPredicate.testAgainstDoublePanel(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> VerticalSlopedStairsSkipPredicate.testAgainstCornerPillar(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_VERTICAL -> VerticalSlopedStairsSkipPredicate.testAgainstDividedPanelVert(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_STAIRS -> VerticalSlopedStairsSkipPredicate.testAgainstStairs(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> VerticalSlopedStairsSkipPredicate.testAgainstDoubleStairs(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> VerticalSlopedStairsSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> VerticalSlopedStairsSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> VerticalSlopedStairsSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_STAIRS -> VerticalSlopedStairsSkipPredicate.testAgainstDividedStairs(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> VerticalSlopedStairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> VerticalSlopedStairsSkipPredicate.testAgainstExtendedSlopePanel(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> VerticalSlopedStairsSkipPredicate.testAgainstDoubleSlopePanel(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> VerticalSlopedStairsSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> VerticalSlopedStairsSkipPredicate.testAgainstExtendedDoubleSlopePanel(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_STACKED_SLOPE_PANEL -> VerticalSlopedStairsSkipPredicate.testAgainstStackedSlopePanel(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_SLOPE_PANEL_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstFlatStackedSlopePanelCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_PANEL_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstFlatStackedInnerSlopePanelCorner(level, pos, state, dir, rot, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstVerticalSlopedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (VerticalSlopedStairsSkipPredicate.getTriDir(dir, rot, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(HalfSlopeSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (VerticalSlopedStairsSkipPredicate.getTriDir(dir, rot, side).isEqualTo(HalfSlopeSkipPredicate.getTriDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDividedSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return false;
        }
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = FramedUtils.getSlopeBlockFacing(adjState);
        SlopeType adjType = FramedUtils.getSlopeType(adjState);
        if (VerticalSlopedStairsSkipPredicate.getTriDir(dir, rot, side).isEqualTo(SlopeSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstSlope(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstSlope(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (VerticalSlopedStairsSkipPredicate.getTriDir(dir, rot, side).isEqualTo(CornerSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstInnerCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (VerticalSlopedStairsSkipPredicate.getTriDir(dir, rot, side).isEqualTo(InnerCornerSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstInnerCorner(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstCorner(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstThreewayCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (VerticalSlopedStairsSkipPredicate.getTriDir(dir, rot, side).isEqualTo(ThreewayCornerSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstInnerThreewayCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (VerticalSlopedStairsSkipPredicate.getTriDir(dir, rot, side).isEqualTo(InnerThreewayCornerSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleThreewayCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstInnerThreewayCorner(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstThreewayCorner(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDividedPanelHor(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(PanelSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstPanel(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstPanel(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstCornerPillar(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(CornerPillarSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedPanelVert(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstCornerPillar(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstCornerPillar(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        Half adjHalf = (Half)adjState.m_61143_((Property)StairBlock.f_56842_);
        if (VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstStairs(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(VerticalStairsSkipPredicate.getHalfDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstCornerPillar(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(HalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(SlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstExtendedDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstExtendedSlopePanel(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstStackedSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstPanel(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatStackedSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstPanel(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatStackedInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstPanel(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    public static TriangleDir getTriDir(Direction dir, HorizontalRotation rot, Direction side) {
        if (side == dir.m_122424_()) {
            return TriangleDir.fromDirections(rot.getOpposite().withFacing(dir), rot.rotate(Rotation.CLOCKWISE_90).withFacing(dir));
        }
        return TriangleDir.NULL;
    }

    public static HalfDir getHalfDir(Direction dir, HorizontalRotation rot, Direction side) {
        if (side == rot.withFacing(dir) || side == rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir)) {
            return HalfDir.fromDirections(side, dir);
        }
        return HalfDir.NULL;
    }
}

