/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xfacthd.framedblocks.common.datagen.providers.FramedBlockStateProvider;
import xfacthd.framedblocks.common.datagen.providers.FramedBlockTagProvider;
import xfacthd.framedblocks.common.datagen.providers.FramedItemModelProvider;
import xfacthd.framedblocks.common.datagen.providers.FramedItemTagProvider;
import xfacthd.framedblocks.common.datagen.providers.FramedLanguageProvider;
import xfacthd.framedblocks.common.datagen.providers.FramedLootTableProvider;
import xfacthd.framedblocks.common.datagen.providers.FramedRecipeProvider;
import xfacthd.framedblocks.common.datagen.providers.FramingSawRecipeProvider;

@Mod.EventBusSubscriber(modid="framedblocks", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class GeneratorHandler {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeClient(), (DataProvider)new FramedBlockStateProvider(output, fileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new FramedItemModelProvider(output, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new FramedLootTableProvider(output));
        gen.addProvider(event.includeServer(), (DataProvider)new FramedRecipeProvider(output));
        gen.addProvider(event.includeServer(), (DataProvider)new FramingSawRecipeProvider(output));
        FramedBlockTagProvider tagProvider = new FramedBlockTagProvider(output, lookupProvider, fileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)tagProvider);
        gen.addProvider(event.includeServer(), (DataProvider)new FramedItemTagProvider(output, lookupProvider, tagProvider, fileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new FramedLanguageProvider(output));
    }

    private GeneratorHandler() {
    }
}

