/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.builders;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.AbstractBuilder;
import com.tterrag.registrate.builders.BlockEntityBuilder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.providers.loot.RegistrateLootTableProvider;
import com.tterrag.registrate.util.OneTimeEventReceiver;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BlockBuilder<T extends Block, P>
extends AbstractBuilder<Block, T, P, BlockBuilder<T, P>> {
    private final NonNullFunction<BlockBehaviour.Properties, T> factory;
    private NonNullSupplier<BlockBehaviour.Properties> initialProperties;
    private NonNullFunction<BlockBehaviour.Properties, BlockBehaviour.Properties> propertiesCallback = NonNullUnaryOperator.identity();
    private List<Supplier<Supplier<RenderType>>> renderLayers = new ArrayList<Supplier<Supplier<RenderType>>>(1);
    @Nullable
    private NonNullSupplier<Supplier<BlockColor>> colorHandler;

    public static <T extends Block, P> BlockBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<BlockBehaviour.Properties, T> factory, Material material) {
        return new BlockBuilder<T, P>(owner, parent, name, callback, factory, () -> BlockBehaviour.Properties.m_60939_((Material)material)).defaultBlockstate().defaultLoot().defaultLang();
    }

    protected BlockBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<BlockBehaviour.Properties, T> factory, NonNullSupplier<BlockBehaviour.Properties> initialProperties) {
        super(owner, parent, name, callback, ForgeRegistries.Keys.BLOCKS);
        this.factory = factory;
        this.initialProperties = initialProperties;
    }

    public BlockBuilder<T, P> properties(NonNullUnaryOperator<BlockBehaviour.Properties> func) {
        this.propertiesCallback = this.propertiesCallback.andThen(func);
        return this;
    }

    public BlockBuilder<T, P> initialProperties(Material material) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60939_((Material)material);
        return this;
    }

    public BlockBuilder<T, P> initialProperties(Material material, DyeColor color) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60941_((Material)material, (DyeColor)color);
        return this;
    }

    public BlockBuilder<T, P> initialProperties(Material material, MaterialColor color) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)color);
        return this;
    }

    public BlockBuilder<T, P> initialProperties(NonNullSupplier<? extends Block> block) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)block.get()));
        return this;
    }

    @Deprecated(forRemoval=true)
    public BlockBuilder<T, P> addLayer(Supplier<Supplier<RenderType>> layer) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> BlockBuilder.lambda$addLayer$5((Supplier)layer));
        if (this.renderLayers.isEmpty()) {
            this.onRegister(this::registerLayers);
        }
        this.renderLayers.add(layer);
        return this;
    }

    protected void registerLayers(T entry) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> OneTimeEventReceiver.addModListener(FMLClientSetupEvent.class, $ -> {
            if (this.renderLayers.size() == 1) {
                RenderType layer = this.renderLayers.get(0).get().get();
                ItemBlockRenderTypes.setRenderLayer((Block)entry, (RenderType)layer);
            } else if (this.renderLayers.size() > 1) {
                Set layers = this.renderLayers.stream().map(s -> (RenderType)((Supplier)s.get()).get()).collect(Collectors.toSet());
                ItemBlockRenderTypes.setRenderLayer((Block)entry, layers::contains);
            }
        }));
    }

    public BlockBuilder<T, P> simpleItem() {
        return (BlockBuilder)this.item().build();
    }

    public ItemBuilder<BlockItem, BlockBuilder<T, P>> item() {
        return this.item(BlockItem::new);
    }

    public <I extends Item> ItemBuilder<I, BlockBuilder<T, P>> item(NonNullBiFunction<? super T, Item.Properties, ? extends I> factory) {
        return ((ItemBuilder)this.getOwner().item(this, this.getName(), p -> (Item)factory.apply((T)this.getEntry(), (Item.Properties)p)).setData(ProviderType.LANG, NonNullBiConsumer.noop())).model((ctx, prov) -> {
            Optional<String> model = this.getOwner().getDataProvider(ProviderType.BLOCKSTATE).flatMap(p -> p.getExistingVariantBuilder((Block)this.getEntry())).map(b -> (BlockStateProvider.ConfiguredModelList)b.getModels().get(b.partialState())).map(BlockStateProvider.ConfiguredModelList::toJSON).filter(JsonElement::isJsonObject).map(j -> j.getAsJsonObject().get("model")).map(JsonElement::getAsString);
            if (model.isPresent()) {
                prov.withExistingParent(ctx.getName(), model.get());
            } else {
                prov.blockItem(this.asSupplier());
            }
        });
    }

    public <BE extends BlockEntity> BlockBuilder<T, P> simpleBlockEntity(BlockEntityBuilder.BlockEntityFactory<BE> factory) {
        return (BlockBuilder)this.blockEntity(factory).build();
    }

    public <BE extends BlockEntity> BlockEntityBuilder<BE, BlockBuilder<T, P>> blockEntity(BlockEntityBuilder.BlockEntityFactory<BE> factory) {
        return this.getOwner().blockEntity(this, this.getName(), factory).validBlock(this.asSupplier());
    }

    public BlockBuilder<T, P> color(NonNullSupplier<Supplier<BlockColor>> colorHandler) {
        if (this.colorHandler == null) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::registerBlockColor);
        }
        this.colorHandler = colorHandler;
        return this;
    }

    protected void registerBlockColor() {
        OneTimeEventReceiver.addModListener(RegisterColorHandlersEvent.Block.class, e -> {
            NonNullSupplier<Supplier<BlockColor>> colorHandler = this.colorHandler;
            if (colorHandler != null) {
                e.register(colorHandler.get().get(), new Block[]{(Block)this.getEntry()});
            }
        });
    }

    public BlockBuilder<T, P> defaultBlockstate() {
        return this.blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry()));
    }

    public BlockBuilder<T, P> blockstate(NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> cons) {
        return (BlockBuilder)this.setData(ProviderType.BLOCKSTATE, cons);
    }

    public BlockBuilder<T, P> defaultLang() {
        return (BlockBuilder)this.lang(Block::m_7705_);
    }

    public BlockBuilder<T, P> lang(String name) {
        return (BlockBuilder)this.lang(Block::m_7705_, name);
    }

    public BlockBuilder<T, P> defaultLoot() {
        return this.loot(RegistrateBlockLootTables::m_245724_);
    }

    public BlockBuilder<T, P> loot(NonNullBiConsumer<RegistrateBlockLootTables, T> cons) {
        return (BlockBuilder)this.setData(ProviderType.LOOT, (ctx, prov) -> prov.addLootAction(RegistrateLootTableProvider.LootType.BLOCK, tb -> {
            if (!((Block)ctx.getEntry()).m_60589_().equals((Object)BuiltInLootTables.f_78712_)) {
                cons.accept((RegistrateBlockLootTables)tb, (Object)((Block)ctx.getEntry()));
            }
        }));
    }

    public BlockBuilder<T, P> recipe(NonNullBiConsumer<DataGenContext<Block, T>, RegistrateRecipeProvider> cons) {
        return (BlockBuilder)this.setData(ProviderType.RECIPE, cons);
    }

    @SafeVarargs
    public final BlockBuilder<T, P> tag(TagKey<Block> ... tags) {
        return (BlockBuilder)this.tag(ProviderType.BLOCK_TAGS, tags);
    }

    @Override
    protected T createEntry() {
        BlockBehaviour.Properties properties = this.initialProperties.get();
        properties = this.propertiesCallback.apply(properties);
        return (T)((Block)this.factory.apply(properties));
    }

    @Override
    protected RegistryEntry<T> createEntryWrapper(RegistryObject<T> delegate) {
        return new BlockEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public BlockEntry<T> register() {
        return (BlockEntry)super.register();
    }

    private static /* synthetic */ void lambda$addLayer$5(Supplier layer) {
        Preconditions.checkArgument((boolean)RenderType.m_110506_().contains(((Supplier)layer.get()).get()), (Object)("Invalid block layer: " + layer));
    }
}

