/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.builders;

import com.google.common.collect.Maps;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.AbstractBuilder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.CreativeModeTabModifier;
import com.tterrag.registrate.util.OneTimeEventReceiver;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.ApiStatus;

public class ItemBuilder<T extends Item, P>
extends AbstractBuilder<Item, T, P, ItemBuilder<T, P>> {
    private final NonNullFunction<Item.Properties, T> factory;
    private NonNullSupplier<Item.Properties> initialProperties = Item.Properties::new;
    private NonNullFunction<Item.Properties, Item.Properties> propertiesCallback = NonNullUnaryOperator.identity();
    @Nullable
    private NonNullSupplier<Supplier<ItemColor>> colorHandler;
    private Map<NonNullSupplier<? extends CreativeModeTab>, Consumer<CreativeModeTabModifier>> creativeModeTabs = Maps.newLinkedHashMap();

    public static <T extends Item, P> ItemBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Item.Properties, T> factory) {
        return ItemBuilder.create(owner, parent, name, callback, factory, null);
    }

    @Deprecated(forRemoval=true, since="1.19.3")
    @ApiStatus.ScheduledForRemoval(inVersion="1.20")
    public static <T extends Item, P> ItemBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Item.Properties, T> factory, @Nullable NonNullSupplier<? extends CreativeModeTab> tab) {
        return new ItemBuilder<T, P>(owner, parent, name, callback, factory).defaultModel().defaultLang().transform(ib -> tab == null ? ib : ib.tab(tab));
    }

    protected ItemBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Item.Properties, T> factory) {
        super(owner, parent, name, callback, ForgeRegistries.Keys.ITEMS);
        this.factory = factory;
        this.onRegister(item -> {
            this.creativeModeTabs.forEach(owner::modifyCreativeModeTab);
            this.creativeModeTabs.clear();
        });
    }

    public ItemBuilder<T, P> properties(NonNullUnaryOperator<Item.Properties> func) {
        this.propertiesCallback = this.propertiesCallback.andThen(func);
        return this;
    }

    public ItemBuilder<T, P> initialProperties(NonNullSupplier<Item.Properties> properties) {
        this.initialProperties = properties;
        return this;
    }

    public ItemBuilder<T, P> tab(NonNullSupplier<? extends CreativeModeTab> tab, Consumer<CreativeModeTabModifier> modifier) {
        this.creativeModeTabs.put(tab, modifier);
        return this;
    }

    public ItemBuilder<T, P> tab(NonNullSupplier<? extends CreativeModeTab> tab) {
        return this.tab(tab, modifier -> modifier.accept((Supplier<? extends ItemLike>)this.get()));
    }

    public ItemBuilder<T, P> removeTab(NonNullSupplier<? extends CreativeModeTab> tab) {
        this.creativeModeTabs.remove(tab);
        return this;
    }

    public ItemBuilder<T, P> color(NonNullSupplier<Supplier<ItemColor>> colorHandler) {
        if (this.colorHandler == null) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::registerItemColor);
        }
        this.colorHandler = colorHandler;
        return this;
    }

    protected void registerItemColor() {
        OneTimeEventReceiver.addModListener(RegisterColorHandlersEvent.Item.class, e -> {
            NonNullSupplier<Supplier<ItemColor>> colorHandler = this.colorHandler;
            if (colorHandler != null) {
                e.register(colorHandler.get().get(), new ItemLike[]{(ItemLike)this.getEntry()});
            }
        });
    }

    public ItemBuilder<T, P> defaultModel() {
        return this.model((ctx, prov) -> prov.generated(ctx::getEntry));
    }

    public ItemBuilder<T, P> model(NonNullBiConsumer<DataGenContext<Item, T>, RegistrateItemModelProvider> cons) {
        return (ItemBuilder)this.setData(ProviderType.ITEM_MODEL, cons);
    }

    public ItemBuilder<T, P> defaultLang() {
        return (ItemBuilder)this.lang(Item::m_5524_);
    }

    public ItemBuilder<T, P> lang(String name) {
        return (ItemBuilder)this.lang(Item::m_5524_, name);
    }

    public ItemBuilder<T, P> recipe(NonNullBiConsumer<DataGenContext<Item, T>, RegistrateRecipeProvider> cons) {
        return (ItemBuilder)this.setData(ProviderType.RECIPE, cons);
    }

    @SafeVarargs
    public final ItemBuilder<T, P> tag(TagKey<Item> ... tags) {
        return (ItemBuilder)this.tag(ProviderType.ITEM_TAGS, tags);
    }

    @Override
    protected T createEntry() {
        Item.Properties properties = this.initialProperties.get();
        properties = this.propertiesCallback.apply(properties);
        return (T)((Item)this.factory.apply(properties));
    }

    @Override
    protected RegistryEntry<T> createEntryWrapper(RegistryObject<T> delegate) {
        return new ItemEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public ItemEntry<T> register() {
        return (ItemEntry)super.register();
    }
}

