/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.providers;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.util.DebugMarkers;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.fml.LogicalSide;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistrateDataProvider
implements DataProvider {
    private static final Logger log = LogManager.getLogger(RegistrateDataProvider.class);
    static final BiMap<String, ProviderType<?>> TYPES = HashBiMap.create();
    private final String mod;
    private final Map<ProviderType<?>, RegistrateProvider> subProviders = new LinkedHashMap();
    private final CompletableFuture<HolderLookup.Provider> registriesLookup;

    @Nullable
    public static String getTypeName(ProviderType<?> type) {
        return (String)TYPES.inverse().get(type);
    }

    public RegistrateDataProvider(AbstractRegistrate<?> parent, String modid, GatherDataEvent event) {
        this.mod = modid;
        this.registriesLookup = event.getLookupProvider();
        EnumSet<LogicalSide> sides = EnumSet.noneOf(LogicalSide.class);
        if (event.includeServer()) {
            sides.add(LogicalSide.SERVER);
        }
        if (event.includeClient()) {
            sides.add(LogicalSide.CLIENT);
        }
        log.debug(DebugMarkers.DATA, "Gathering providers for sides: {}", sides);
        HashMap known = new HashMap();
        for (String id : TYPES.keySet()) {
            ProviderType type = (ProviderType)TYPES.get((Object)id);
            Object prov = type.create(parent, event, known);
            known.put(type, (RegistrateProvider)prov);
            if (!sides.contains(prov.getSide())) continue;
            log.debug(DebugMarkers.DATA, "Adding provider for type: {}", (Object)id);
            this.subProviders.put(type, (RegistrateProvider)prov);
        }
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        return this.registriesLookup.thenCompose(provider -> {
            ArrayList list = Lists.newArrayList();
            for (Map.Entry<ProviderType<?>, RegistrateProvider> e : this.subProviders.entrySet()) {
                log.debug(DebugMarkers.DATA, "Generating data for type: {}", (Object)RegistrateDataProvider.getTypeName(e.getKey()));
                list.add(e.getValue().m_213708_(cache));
            }
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        });
    }

    public String m_6055_() {
        return "Registrate Provider for " + this.mod + " [" + this.subProviders.values().stream().map(DataProvider::m_6055_).collect(Collectors.joining(", ")) + "]";
    }

    public <P extends RegistrateProvider> Optional<P> getSubProvider(ProviderType<P> type) {
        return Optional.ofNullable(this.subProviders.get(type));
    }
}

