/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.providers;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;

public class RegistrateRecipeProvider
extends RecipeProvider
implements RegistrateProvider,
Consumer<FinishedRecipe> {
    private final AbstractRegistrate<?> owner;
    @Nullable
    private Consumer<FinishedRecipe> callback;
    public static final int DEFAULT_SMELT_TIME = 200;
    public static final int DEFAULT_BLAST_TIME = 100;
    public static final int DEFAULT_SMOKE_TIME = 100;
    public static final int DEFAULT_CAMPFIRE_TIME = 600;
    private static final String SMELTING_NAME = "smelting";
    private static final ImmutableMap<RecipeSerializer<? extends AbstractCookingRecipe>, String> COOKING_TYPE_NAMES = ImmutableMap.builder().put((Object)RecipeSerializer.f_44091_, (Object)"smelting").put((Object)RecipeSerializer.f_44092_, (Object)"blasting").put((Object)RecipeSerializer.f_44093_, (Object)"smoking").put((Object)RecipeSerializer.f_44094_, (Object)"campfire").build();

    public RegistrateRecipeProvider(AbstractRegistrate<?> owner, PackOutput output) {
        super(output);
        this.owner = owner;
    }

    @Override
    public LogicalSide getSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void accept(@Nullable FinishedRecipe t) {
        if (this.callback == null) {
            throw new IllegalStateException("Cannot accept recipes outside of a call to registerRecipes");
        }
        this.callback.accept(t);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        this.callback = consumer;
        this.owner.genData(ProviderType.RECIPE, this);
        this.callback = null;
    }

    public ResourceLocation safeId(ResourceLocation id) {
        return new ResourceLocation(this.owner.getModid(), this.safeName(id));
    }

    public ResourceLocation safeId(DataIngredient source) {
        return this.safeId(source.getId());
    }

    public ResourceLocation safeId(ItemLike registryEntry) {
        return this.safeId(ForgeRegistries.ITEMS.getKey((Object)registryEntry.m_5456_()));
    }

    public String safeName(ResourceLocation id) {
        return id.m_135815_().replace('/', '_');
    }

    public String safeName(DataIngredient source) {
        return this.safeName(source.getId());
    }

    public String safeName(ItemLike registryEntry) {
        return this.safeName(ForgeRegistries.ITEMS.getKey((Object)registryEntry.m_5456_()));
    }

    public <T extends ItemLike> void cooking(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, float experience, int cookingTime, RecipeSerializer<? extends AbstractCookingRecipe> serializer) {
        this.cooking(source, category, result, experience, cookingTime, (String)COOKING_TYPE_NAMES.get(serializer), serializer);
    }

    public <T extends ItemLike> void cooking(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, float experience, int cookingTime, String typeName, RecipeSerializer<? extends AbstractCookingRecipe> serializer) {
        SimpleCookingRecipeBuilder.m_247607_((Ingredient)source, (RecipeCategory)category, (ItemLike)((ItemLike)result.get()), (float)experience, (int)cookingTime, serializer).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_176500_((Consumer)this, this.safeId((ItemLike)result.get()) + "_from_" + this.safeName(source) + "_" + typeName);
    }

    public <T extends ItemLike> void smelting(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, float experience) {
        this.smelting(source, category, result, experience, 200);
    }

    public <T extends ItemLike> void smelting(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, category, result, experience, cookingTime, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44091_);
    }

    public <T extends ItemLike> void blasting(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, float experience) {
        this.blasting(source, category, result, experience, 100);
    }

    public <T extends ItemLike> void blasting(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, category, result, experience, cookingTime, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44092_);
    }

    public <T extends ItemLike> void smoking(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, float experience) {
        this.smoking(source, category, result, experience, 100);
    }

    public <T extends ItemLike> void smoking(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, category, result, experience, cookingTime, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44093_);
    }

    public <T extends ItemLike> void campfire(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, float experience) {
        this.campfire(source, category, result, experience, 600);
    }

    public <T extends ItemLike> void campfire(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, category, result, experience, cookingTime, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44094_);
    }

    public <T extends ItemLike> void stonecutting(DataIngredient source, RecipeCategory category, Supplier<? extends T> result) {
        this.stonecutting(source, category, result, 1);
    }

    public <T extends ItemLike> void stonecutting(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, int resultAmount) {
        SingleItemRecipeBuilder.m_246944_((Ingredient)source, (RecipeCategory)category, (ItemLike)((ItemLike)result.get()), (int)resultAmount).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_176500_((Consumer)this, this.safeId((ItemLike)result.get()) + "_from_" + this.safeName(source) + "_stonecutting");
    }

    public <T extends ItemLike> void smeltingAndBlasting(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, float xp) {
        this.smelting(source, category, result, xp);
        this.blasting(source, category, result, xp);
    }

    public <T extends ItemLike> void food(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, float xp) {
        this.smelting(source, category, result, xp);
        this.smoking(source, category, result, xp);
        this.campfire(source, category, result, xp);
    }

    public <T extends ItemLike> void square(DataIngredient source, RecipeCategory category, Supplier<? extends T> output, boolean small) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_245327_((RecipeCategory)category, (ItemLike)((ItemLike)output.get())).m_126124_(Character.valueOf('X'), (Ingredient)source);
        if (small) {
            builder.m_126130_("XX").m_126130_("XX");
        } else {
            builder.m_126130_("XXX").m_126130_("XXX").m_126130_("XXX");
        }
        builder.m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_126140_((Consumer)this, this.safeId((ItemLike)output.get()));
    }

    @Deprecated
    public <T extends ItemLike> void storage(DataIngredient source, RecipeCategory category, NonNullSupplier<? extends T> output) {
        this.square(source, category, output, false);
        this.singleItemUnfinished(source, category, output, 1, 9).m_176500_((Consumer)this, this.safeId(source) + "_from_" + this.safeName((ItemLike)output.get()));
    }

    public <T extends ItemLike> void storage(NonNullSupplier<? extends T> source, RecipeCategory category, NonNullSupplier<? extends T> output) {
        this.storage(DataIngredient.items(source, new NonNullSupplier[0]), category, source, DataIngredient.items(output, new NonNullSupplier[0]), output);
    }

    public <T extends ItemLike> void storage(DataIngredient sourceIngredient, RecipeCategory category, NonNullSupplier<? extends T> source, DataIngredient outputIngredient, NonNullSupplier<? extends T> output) {
        this.square(sourceIngredient, category, output, false);
        this.singleItemUnfinished(outputIngredient, category, source, 1, 9).m_176500_((Consumer)this, this.safeId(sourceIngredient) + "_from_" + this.safeName((ItemLike)output.get()));
    }

    @CheckReturnValue
    public <T extends ItemLike> ShapelessRecipeBuilder singleItemUnfinished(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, int required, int amount) {
        return ShapelessRecipeBuilder.m_246517_((RecipeCategory)category, (ItemLike)((ItemLike)result.get()), (int)amount).m_126186_((Ingredient)source, required).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this));
    }

    public <T extends ItemLike> void singleItem(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, int required, int amount) {
        this.singleItemUnfinished(source, category, result, required, amount).m_126140_((Consumer)this, this.safeId((ItemLike)result.get()));
    }

    public <T extends ItemLike> void planks(DataIngredient source, RecipeCategory category, Supplier<? extends T> result) {
        this.singleItemUnfinished(source, category, result, 1, 4).m_126145_("planks").m_126140_((Consumer)this, this.safeId((ItemLike)result.get()));
    }

    public <T extends ItemLike> void stairs(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, @Nullable String group, boolean stone) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)((ItemLike)result.get()), (int)4).m_126130_("X  ").m_126130_("XX ").m_126130_("XXX").m_126124_(Character.valueOf('X'), (Ingredient)source).m_126145_(group).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_126140_((Consumer)this, this.safeId((ItemLike)result.get()));
        if (stone) {
            this.stonecutting(source, category, result);
        }
    }

    public <T extends ItemLike> void slab(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, @Nullable String group, boolean stone) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)((ItemLike)result.get()), (int)6).m_126130_("XXX").m_126124_(Character.valueOf('X'), (Ingredient)source).m_126145_(group).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_126140_((Consumer)this, this.safeId((ItemLike)result.get()));
        if (stone) {
            this.stonecutting(source, category, result, 2);
        }
    }

    public <T extends ItemLike> void fence(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, @Nullable String group) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)((ItemLike)result.get()), (int)3).m_126130_("W#W").m_126130_("W#W").m_126124_(Character.valueOf('W'), (Ingredient)source).m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_126145_(group).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_126140_((Consumer)this, this.safeId((ItemLike)result.get()));
    }

    public <T extends ItemLike> void fenceGate(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, @Nullable String group) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)category, (ItemLike)((ItemLike)result.get())).m_126130_("#W#").m_126130_("#W#").m_126124_(Character.valueOf('W'), (Ingredient)source).m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_126145_(group).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_126140_((Consumer)this, this.safeId((ItemLike)result.get()));
    }

    public <T extends ItemLike> void wall(DataIngredient source, RecipeCategory category, Supplier<? extends T> result) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)((ItemLike)result.get()), (int)6).m_126130_("XXX").m_126130_("XXX").m_126124_(Character.valueOf('X'), (Ingredient)source).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_126140_((Consumer)this, this.safeId((ItemLike)result.get()));
        this.stonecutting(source, category, result);
    }

    public <T extends ItemLike> void door(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, @Nullable String group) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)((ItemLike)result.get()), (int)3).m_126130_("XX").m_126130_("XX").m_126130_("XX").m_126124_(Character.valueOf('X'), (Ingredient)source).m_126145_(group).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_126140_((Consumer)this, this.safeId((ItemLike)result.get()));
    }

    public <T extends ItemLike> void trapDoor(DataIngredient source, RecipeCategory category, Supplier<? extends T> result, @Nullable String group) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)((ItemLike)result.get()), (int)2).m_126130_("XXX").m_126130_("XXX").m_126124_(Character.valueOf('X'), (Ingredient)source).m_126145_(group).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_126140_((Consumer)this, this.safeId((ItemLike)result.get()));
    }

    public CompletableFuture<?> saveAdvancement(CachedOutput output, FinishedRecipe finishedRecipe, JsonObject advancementJson) {
        return super.saveAdvancement(output, finishedRecipe, advancementJson);
    }

    public CompletableFuture<?> m_253240_(CachedOutput p_253674_, ResourceLocation p_254102_, Advancement.Builder p_253712_) {
        return super.m_253240_(p_253674_, p_254102_, p_253712_);
    }

    public void m_247051_(Consumer<FinishedRecipe> p_249188_, FeatureFlagSet p_251836_) {
        super.m_247051_(p_249188_, p_251836_);
    }

    public static void oreSmelting(Consumer<FinishedRecipe> p_250654_, List<ItemLike> p_250172_, RecipeCategory p_250588_, ItemLike p_251868_, float p_250789_, int p_252144_, String p_251687_) {
        RecipeProvider.m_246272_(p_250654_, p_250172_, (RecipeCategory)p_250588_, (ItemLike)p_251868_, (float)p_250789_, (int)p_252144_, (String)p_251687_);
    }

    public static void oreBlasting(Consumer<FinishedRecipe> p_248775_, List<ItemLike> p_251504_, RecipeCategory p_248846_, ItemLike p_249735_, float p_248783_, int p_250303_, String p_251984_) {
        RecipeProvider.m_245412_(p_248775_, p_251504_, (RecipeCategory)p_248846_, (ItemLike)p_249735_, (float)p_248783_, (int)p_250303_, (String)p_251984_);
    }

    public static void oreCooking(Consumer<FinishedRecipe> p_250791_, RecipeSerializer<? extends AbstractCookingRecipe> p_251817_, List<ItemLike> p_249619_, RecipeCategory p_251154_, ItemLike p_250066_, float p_251871_, int p_251316_, String p_251450_, String p_249236_) {
        RecipeProvider.m_245809_(p_250791_, p_251817_, p_249619_, (RecipeCategory)p_251154_, (ItemLike)p_250066_, (float)p_251871_, (int)p_251316_, (String)p_251450_, (String)p_249236_);
    }

    public static void netheriteSmithing(Consumer<FinishedRecipe> p_251614_, Item p_250046_, RecipeCategory p_248986_, Item p_250389_) {
        RecipeProvider.m_246630_(p_251614_, (Item)p_250046_, (RecipeCategory)p_248986_, (Item)p_250389_);
    }

    public static void twoByTwoPacker(Consumer<FinishedRecipe> p_248860_, RecipeCategory p_250881_, ItemLike p_252184_, ItemLike p_249710_) {
        RecipeProvider.m_247540_(p_248860_, (RecipeCategory)p_250881_, (ItemLike)p_252184_, (ItemLike)p_249710_);
    }

    public static void threeByThreePacker(Consumer<FinishedRecipe> p_259036_, RecipeCategory p_259247_, ItemLike p_259376_, ItemLike p_259717_, String p_260308_) {
        RecipeProvider.m_257994_(p_259036_, (RecipeCategory)p_259247_, (ItemLike)p_259376_, (ItemLike)p_259717_, (String)p_260308_);
    }

    public static void threeByThreePacker(Consumer<FinishedRecipe> p_260012_, RecipeCategory p_259186_, ItemLike p_259360_, ItemLike p_259263_) {
        RecipeProvider.m_258049_(p_260012_, (RecipeCategory)p_259186_, (ItemLike)p_259360_, (ItemLike)p_259263_);
    }

    public static void planksFromLog(Consumer<FinishedRecipe> p_259712_, ItemLike p_259052_, TagKey<Item> p_259045_, int p_259471_) {
        RecipeProvider.m_257929_(p_259712_, (ItemLike)p_259052_, p_259045_, (int)p_259471_);
    }

    public static void planksFromLogs(Consumer<FinishedRecipe> p_259910_, ItemLike p_259193_, TagKey<Item> p_259818_, int p_259807_) {
        RecipeProvider.m_257424_(p_259910_, (ItemLike)p_259193_, p_259818_, (int)p_259807_);
    }

    public static void woodFromLogs(Consumer<FinishedRecipe> p_126003_, ItemLike p_126004_, ItemLike p_126005_) {
        RecipeProvider.m_126002_(p_126003_, (ItemLike)p_126004_, (ItemLike)p_126005_);
    }

    public static void woodenBoat(Consumer<FinishedRecipe> p_126022_, ItemLike p_126023_, ItemLike p_126024_) {
        RecipeProvider.m_126021_(p_126022_, (ItemLike)p_126023_, (ItemLike)p_126024_);
    }

    public static void chestBoat(Consumer<FinishedRecipe> p_236372_, ItemLike p_236373_, ItemLike p_236374_) {
        RecipeProvider.m_236371_(p_236372_, (ItemLike)p_236373_, (ItemLike)p_236374_);
    }

    public static RecipeBuilder buttonBuilder(ItemLike p_176659_, Ingredient p_176660_) {
        return RecipeProvider.m_176658_((ItemLike)p_176659_, (Ingredient)p_176660_);
    }

    public static RecipeBuilder doorBuilder(ItemLike p_176671_, Ingredient p_176672_) {
        return RecipeProvider.m_176670_((ItemLike)p_176671_, (Ingredient)p_176672_);
    }

    public static RecipeBuilder fenceBuilder(ItemLike p_176679_, Ingredient p_176680_) {
        return RecipeProvider.m_176678_((ItemLike)p_176679_, (Ingredient)p_176680_);
    }

    public static RecipeBuilder fenceGateBuilder(ItemLike p_176685_, Ingredient p_176686_) {
        return RecipeProvider.m_176684_((ItemLike)p_176685_, (Ingredient)p_176686_);
    }

    public static void pressurePlate(Consumer<FinishedRecipe> p_176691_, ItemLike p_176692_, ItemLike p_176693_) {
        RecipeProvider.m_176690_(p_176691_, (ItemLike)p_176692_, (ItemLike)p_176693_);
    }

    public static RecipeBuilder pressurePlateBuilder(RecipeCategory p_251447_, ItemLike p_251989_, Ingredient p_249211_) {
        return RecipeProvider.m_247347_((RecipeCategory)p_251447_, (ItemLike)p_251989_, (Ingredient)p_249211_);
    }

    public static void slab(Consumer<FinishedRecipe> p_248880_, RecipeCategory p_251848_, ItemLike p_249368_, ItemLike p_252133_) {
        RecipeProvider.m_246658_(p_248880_, (RecipeCategory)p_251848_, (ItemLike)p_249368_, (ItemLike)p_252133_);
    }

    public static RecipeBuilder slabBuilder(RecipeCategory p_251707_, ItemLike p_251284_, Ingredient p_248824_) {
        return RecipeProvider.m_247552_((RecipeCategory)p_251707_, (ItemLike)p_251284_, (Ingredient)p_248824_);
    }

    public static RecipeBuilder stairBuilder(ItemLike p_176711_, Ingredient p_176712_) {
        return RecipeProvider.m_176710_((ItemLike)p_176711_, (Ingredient)p_176712_);
    }

    public static RecipeBuilder trapdoorBuilder(ItemLike p_176721_, Ingredient p_176722_) {
        return RecipeProvider.m_176720_((ItemLike)p_176721_, (Ingredient)p_176722_);
    }

    public static RecipeBuilder signBuilder(ItemLike p_176727_, Ingredient p_176728_) {
        return RecipeProvider.m_176726_((ItemLike)p_176727_, (Ingredient)p_176728_);
    }

    public static void hangingSign(Consumer<FinishedRecipe> p_250663_, ItemLike p_252355_, ItemLike p_250437_) {
        RecipeProvider.m_246977_(p_250663_, (ItemLike)p_252355_, (ItemLike)p_250437_);
    }

    public static void coloredWoolFromWhiteWoolAndDye(Consumer<FinishedRecipe> p_126062_, ItemLike p_126063_, ItemLike p_126064_) {
        RecipeProvider.m_126061_(p_126062_, (ItemLike)p_126063_, (ItemLike)p_126064_);
    }

    public static void carpet(Consumer<FinishedRecipe> p_176717_, ItemLike p_176718_, ItemLike p_176719_) {
        RecipeProvider.m_176716_(p_176717_, (ItemLike)p_176718_, (ItemLike)p_176719_);
    }

    public static void coloredCarpetFromWhiteCarpetAndDye(Consumer<FinishedRecipe> p_126070_, ItemLike p_126071_, ItemLike p_126072_) {
        RecipeProvider.m_126069_(p_126070_, (ItemLike)p_126071_, (ItemLike)p_126072_);
    }

    public static void bedFromPlanksAndWool(Consumer<FinishedRecipe> p_126074_, ItemLike p_126075_, ItemLike p_126076_) {
        RecipeProvider.m_126073_(p_126074_, (ItemLike)p_126075_, (ItemLike)p_126076_);
    }

    public static void bedFromWhiteBedAndDye(Consumer<FinishedRecipe> p_126078_, ItemLike p_126079_, ItemLike p_126080_) {
        RecipeProvider.m_126077_(p_126078_, (ItemLike)p_126079_, (ItemLike)p_126080_);
    }

    public static void banner(Consumer<FinishedRecipe> p_126082_, ItemLike p_126083_, ItemLike p_126084_) {
        RecipeProvider.m_126081_(p_126082_, (ItemLike)p_126083_, (ItemLike)p_126084_);
    }

    public static void stainedGlassFromGlassAndDye(Consumer<FinishedRecipe> p_126086_, ItemLike p_126087_, ItemLike p_126088_) {
        RecipeProvider.m_126085_(p_126086_, (ItemLike)p_126087_, (ItemLike)p_126088_);
    }

    public static void stainedGlassPaneFromStainedGlass(Consumer<FinishedRecipe> p_126090_, ItemLike p_126091_, ItemLike p_126092_) {
        RecipeProvider.m_126089_(p_126090_, (ItemLike)p_126091_, (ItemLike)p_126092_);
    }

    public static void stainedGlassPaneFromGlassPaneAndDye(Consumer<FinishedRecipe> p_126094_, ItemLike p_126095_, ItemLike p_126096_) {
        RecipeProvider.m_126093_(p_126094_, (ItemLike)p_126095_, (ItemLike)p_126096_);
    }

    public static void coloredTerracottaFromTerracottaAndDye(Consumer<FinishedRecipe> p_126098_, ItemLike p_126099_, ItemLike p_126100_) {
        RecipeProvider.m_126097_(p_126098_, (ItemLike)p_126099_, (ItemLike)p_126100_);
    }

    public static void concretePowder(Consumer<FinishedRecipe> p_126102_, ItemLike p_126103_, ItemLike p_126104_) {
        RecipeProvider.m_126101_(p_126102_, (ItemLike)p_126103_, (ItemLike)p_126104_);
    }

    public static void candle(Consumer<FinishedRecipe> p_176543_, ItemLike p_176544_, ItemLike p_176545_) {
        RecipeProvider.m_176542_(p_176543_, (ItemLike)p_176544_, (ItemLike)p_176545_);
    }

    public static void wall(Consumer<FinishedRecipe> p_251034_, RecipeCategory p_251148_, ItemLike p_250499_, ItemLike p_249970_) {
        RecipeProvider.m_246382_(p_251034_, (RecipeCategory)p_251148_, (ItemLike)p_250499_, (ItemLike)p_249970_);
    }

    public static RecipeBuilder wallBuilder(RecipeCategory p_249083_, ItemLike p_250754_, Ingredient p_250311_) {
        return RecipeProvider.m_245864_((RecipeCategory)p_249083_, (ItemLike)p_250754_, (Ingredient)p_250311_);
    }

    public static void polished(Consumer<FinishedRecipe> p_251348_, RecipeCategory p_248719_, ItemLike p_250032_, ItemLike p_250021_) {
        RecipeProvider.m_245931_(p_251348_, (RecipeCategory)p_248719_, (ItemLike)p_250032_, (ItemLike)p_250021_);
    }

    public static RecipeBuilder polishedBuilder(RecipeCategory p_249131_, ItemLike p_251242_, Ingredient p_251412_) {
        return RecipeProvider.m_247174_((RecipeCategory)p_249131_, (ItemLike)p_251242_, (Ingredient)p_251412_);
    }

    public static void cut(Consumer<FinishedRecipe> p_248712_, RecipeCategory p_252306_, ItemLike p_249686_, ItemLike p_251100_) {
        RecipeProvider.m_247059_(p_248712_, (RecipeCategory)p_252306_, (ItemLike)p_249686_, (ItemLike)p_251100_);
    }

    public static ShapedRecipeBuilder cutBuilder(RecipeCategory p_250895_, ItemLike p_251147_, Ingredient p_251563_) {
        return RecipeProvider.m_245792_((RecipeCategory)p_250895_, (ItemLike)p_251147_, (Ingredient)p_251563_);
    }

    public static void chiseled(Consumer<FinishedRecipe> p_250120_, RecipeCategory p_251604_, ItemLike p_251049_, ItemLike p_252267_) {
        RecipeProvider.m_246222_(p_250120_, (RecipeCategory)p_251604_, (ItemLike)p_251049_, (ItemLike)p_252267_);
    }

    public static void mosaicBuilder(Consumer<FinishedRecipe> p_249200_, RecipeCategory p_248788_, ItemLike p_251925_, ItemLike p_252242_) {
        RecipeProvider.m_247239_(p_249200_, (RecipeCategory)p_248788_, (ItemLike)p_251925_, (ItemLike)p_252242_);
    }

    public static ShapedRecipeBuilder chiseledBuilder(RecipeCategory p_251755_, ItemLike p_249782_, Ingredient p_250087_) {
        return RecipeProvider.m_246451_((RecipeCategory)p_251755_, (ItemLike)p_249782_, (Ingredient)p_250087_);
    }

    public static void stonecutterResultFromBase(Consumer<FinishedRecipe> p_251589_, RecipeCategory p_248911_, ItemLike p_251265_, ItemLike p_250033_) {
        RecipeProvider.m_247600_(p_251589_, (RecipeCategory)p_248911_, (ItemLike)p_251265_, (ItemLike)p_250033_);
    }

    public static void stonecutterResultFromBase(Consumer<FinishedRecipe> p_249145_, RecipeCategory p_250609_, ItemLike p_251254_, ItemLike p_249666_, int p_251462_) {
        RecipeProvider.m_247298_(p_249145_, (RecipeCategory)p_250609_, (ItemLike)p_251254_, (ItemLike)p_249666_, (int)p_251462_);
    }

    public static void smeltingResultFromBase(Consumer<FinishedRecipe> p_176740_, ItemLike p_176741_, ItemLike p_176742_) {
        RecipeProvider.m_176739_(p_176740_, (ItemLike)p_176741_, (ItemLike)p_176742_);
    }

    public static void nineBlockStorageRecipes(Consumer<FinishedRecipe> p_249580_, RecipeCategory p_251203_, ItemLike p_251689_, RecipeCategory p_251376_, ItemLike p_248771_) {
        RecipeProvider.m_247655_(p_249580_, (RecipeCategory)p_251203_, (ItemLike)p_251689_, (RecipeCategory)p_251376_, (ItemLike)p_248771_);
    }

    public static void nineBlockStorageRecipesWithCustomPacking(Consumer<FinishedRecipe> p_250488_, RecipeCategory p_250885_, ItemLike p_251651_, RecipeCategory p_250874_, ItemLike p_248576_, String p_250171_, String p_249386_) {
        RecipeProvider.m_246075_(p_250488_, (RecipeCategory)p_250885_, (ItemLike)p_251651_, (RecipeCategory)p_250874_, (ItemLike)p_248576_, (String)p_250171_, (String)p_249386_);
    }

    public static void nineBlockStorageRecipesRecipesWithCustomUnpacking(Consumer<FinishedRecipe> p_250320_, RecipeCategory p_248979_, ItemLike p_249101_, RecipeCategory p_252036_, ItemLike p_250886_, String p_248768_, String p_250847_) {
        RecipeProvider.m_245261_(p_250320_, (RecipeCategory)p_248979_, (ItemLike)p_249101_, (RecipeCategory)p_252036_, (ItemLike)p_250886_, (String)p_248768_, (String)p_250847_);
    }

    public static void cookRecipes(Consumer<FinishedRecipe> p_126007_, String p_126008_, RecipeSerializer<? extends AbstractCookingRecipe> p_250529_, int p_126010_) {
        RecipeProvider.m_126006_(p_126007_, (String)p_126008_, p_250529_, (int)p_126010_);
    }

    public static void simpleCookingRecipe(Consumer<FinishedRecipe> p_249398_, String p_249709_, RecipeSerializer<? extends AbstractCookingRecipe> p_251876_, int p_249258_, ItemLike p_250669_, ItemLike p_250224_, float p_252138_) {
        RecipeProvider.m_247434_(p_249398_, (String)p_249709_, p_251876_, (int)p_249258_, (ItemLike)p_250669_, (ItemLike)p_250224_, (float)p_252138_);
    }

    public static void waxRecipes(Consumer<FinishedRecipe> p_176611_) {
        RecipeProvider.m_176610_(p_176611_);
    }

    public static void generateRecipes(Consumer<FinishedRecipe> p_176581_, BlockFamily p_176582_) {
        RecipeProvider.m_176580_(p_176581_, (BlockFamily)p_176582_);
    }

    public static Block getBaseBlock(BlockFamily p_176524_, BlockFamily.Variant p_176525_) {
        return RecipeProvider.m_176523_((BlockFamily)p_176524_, (BlockFamily.Variant)p_176525_);
    }

    public static EnterBlockTrigger.TriggerInstance insideOf(Block p_125980_) {
        return RecipeProvider.m_125979_((Block)p_125980_);
    }

    public static InventoryChangeTrigger.TriggerInstance has(MinMaxBounds.Ints p_176521_, ItemLike p_176522_) {
        return RecipeProvider.m_176520_((MinMaxBounds.Ints)p_176521_, (ItemLike)p_176522_);
    }

    public static InventoryChangeTrigger.TriggerInstance has(ItemLike p_125978_) {
        return RecipeProvider.m_125977_((ItemLike)p_125978_);
    }

    public static InventoryChangeTrigger.TriggerInstance has(TagKey<Item> p_206407_) {
        return RecipeProvider.m_206406_(p_206407_);
    }

    public static InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... p_126012_) {
        return RecipeProvider.m_126011_((ItemPredicate[])p_126012_);
    }

    public static String getHasName(ItemLike p_176603_) {
        return RecipeProvider.m_176602_((ItemLike)p_176603_);
    }

    public static String getItemName(ItemLike p_176633_) {
        return RecipeProvider.m_176632_((ItemLike)p_176633_);
    }

    public static String getSimpleRecipeName(ItemLike p_176645_) {
        return RecipeProvider.m_176644_((ItemLike)p_176645_);
    }

    public static String getConversionRecipeName(ItemLike p_176518_, ItemLike p_176519_) {
        return RecipeProvider.m_176517_((ItemLike)p_176518_, (ItemLike)p_176519_);
    }

    public static String getSmeltingRecipeName(ItemLike p_176657_) {
        return RecipeProvider.m_176656_((ItemLike)p_176657_);
    }

    public static String getBlastingRecipeName(ItemLike p_176669_) {
        return RecipeProvider.m_176668_((ItemLike)p_176669_);
    }
}

