/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.AllSections;
import com.simibubi.create.content.contraptions.components.actors.SeatBlock;
import com.simibubi.create.content.contraptions.components.crank.ValveHandleBlock;
import com.simibubi.create.content.contraptions.relays.gearbox.GearboxBlock;
import com.simibubi.create.content.contraptions.relays.gearbox.VerticalGearboxItem;
import com.simibubi.create.content.curiosities.armor.BackTankUtil;
import com.simibubi.create.content.curiosities.armor.CopperArmorItem;
import com.simibubi.create.content.curiosities.toolbox.ToolboxBlock;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationBlock;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleItem;
import com.simibubi.create.content.palettes.AllPaletteBlocks;
import com.simibubi.create.foundation.item.TagDependentIngredientItem;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AllCreativeModeTabs {
    public static final ResourceLocation BASE_TAB_ID = Create.asResource("base");
    public static final ResourceLocation PALETTES_TAB_ID = Create.asResource("palettes");
    private static CreativeModeTab baseTab;
    private static CreativeModeTab palettesTab;

    @SubscribeEvent
    public static void onCreativeModeTabRegister(CreativeModeTabEvent.Register event) {
        baseTab = event.registerCreativeModeTab(BASE_TAB_ID, List.of(PALETTES_TAB_ID), List.of(CreativeModeTabs.f_256731_), builder -> builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.create.base")).m_257737_(() -> AllBlocks.COGWHEEL.asStack()).m_257501_((CreativeModeTab.DisplayItemsGenerator)new RegistrateDisplayItemsGenerator(EnumSet.complementOf(EnumSet.of(AllSections.PALETTES)), true)));
        palettesTab = event.registerCreativeModeTab(PALETTES_TAB_ID, List.of(), List.of(CreativeModeTabs.f_256731_, BASE_TAB_ID), builder -> builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.create.palettes")).m_257737_(() -> AllPaletteBlocks.ORNATE_IRON_WINDOW.asStack()).m_257501_((CreativeModeTab.DisplayItemsGenerator)new RegistrateDisplayItemsGenerator(EnumSet.of(AllSections.PALETTES), false)));
    }

    public static CreativeModeTab getBaseTab() {
        return baseTab;
    }

    public static CreativeModeTab getPalettesTab() {
        return palettesTab;
    }

    private static class RegistrateDisplayItemsGenerator
    implements CreativeModeTab.DisplayItemsGenerator {
        private final EnumSet<AllSections> sections;
        private final boolean addItems;

        public RegistrateDisplayItemsGenerator(EnumSet<AllSections> sections, boolean addItems) {
            this.sections = sections;
            this.addItems = addItems;
        }

        private static Predicate<Item> makeExclusionPredicate() {
            ReferenceOpenHashSet exclusions = new ReferenceOpenHashSet();
            List<ItemProviderEntry> simpleExclusions = List.of(AllItems.INCOMPLETE_PRECISION_MECHANISM, AllItems.INCOMPLETE_REINFORCED_SHEET, AllItems.INCOMPLETE_TRACK, AllItems.CHROMATIC_COMPOUND, AllItems.SHADOW_STEEL, AllItems.REFINED_RADIANCE, AllItems.COPPER_BACKTANK_PLACEABLE, AllItems.MINECART_CONTRAPTION, AllItems.FURNACE_MINECART_CONTRAPTION, AllItems.CHEST_MINECART_CONTRAPTION, AllItems.SCHEMATIC, AllBlocks.ANDESITE_ENCASED_SHAFT, AllBlocks.BRASS_ENCASED_SHAFT, AllBlocks.ANDESITE_ENCASED_COGWHEEL, AllBlocks.BRASS_ENCASED_COGWHEEL, AllBlocks.ANDESITE_ENCASED_LARGE_COGWHEEL, AllBlocks.BRASS_ENCASED_LARGE_COGWHEEL, AllBlocks.MYSTERIOUS_CUCKOO_CLOCK, AllBlocks.SHADOW_STEEL_CASING, AllBlocks.REFINED_RADIANCE_CASING);
            List<ItemEntry<TagDependentIngredientItem>> tagDependentExclusions = List.of(AllItems.CRUSHED_OSMIUM, AllItems.CRUSHED_PLATINUM, AllItems.CRUSHED_SILVER, AllItems.CRUSHED_TIN, AllItems.CRUSHED_LEAD, AllItems.CRUSHED_QUICKSILVER, AllItems.CRUSHED_BAUXITE, AllItems.CRUSHED_URANIUM, AllItems.CRUSHED_NICKEL);
            for (ItemProviderEntry itemProviderEntry : simpleExclusions) {
                exclusions.add(itemProviderEntry.m_5456_());
            }
            for (ItemEntry itemEntry : tagDependentExclusions) {
                TagDependentIngredientItem item = (TagDependentIngredientItem)((Object)itemEntry.get());
                if (!item.shouldHide()) continue;
                exclusions.add(itemEntry.m_5456_());
            }
            return ((Set)exclusions)::contains;
        }

        private static List<ItemOrdering> makeOrderings() {
            ReferenceArrayList orderings = new ReferenceArrayList();
            Map<ItemEntry<ScheduleItem>, BlockEntry<StationBlock>> simpleBeforeOrderings = Map.of(AllItems.EMPTY_BLAZE_BURNER, AllBlocks.BLAZE_BURNER, AllItems.SCHEDULE, AllBlocks.TRACK_STATION);
            Map<ItemEntry<VerticalGearboxItem>, BlockEntry<GearboxBlock>> simpleAfterOrderings = Map.of(AllItems.VERTICAL_GEARBOX, AllBlocks.GEARBOX);
            simpleBeforeOrderings.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeOrderings$0((List)orderings, arg_0, arg_1));
            simpleAfterOrderings.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeOrderings$1((List)orderings, arg_0, arg_1));
            return orderings;
        }

        private static Function<Item, ItemStack> makeStackFunc() {
            Reference2ReferenceOpenHashMap factories = new Reference2ReferenceOpenHashMap();
            Map<ItemEntry<? extends CopperArmorItem>, Function<Item, ItemStack>> simpleFactories = Map.of(AllItems.COPPER_BACKTANK, item -> {
                ItemStack stack = new ItemStack((ItemLike)item);
                stack.m_41784_().m_128405_("Air", BackTankUtil.maxAirWithoutEnchants());
                return stack;
            });
            simpleFactories.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeStackFunc$3((Map)factories, arg_0, arg_1));
            return arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeStackFunc$4((Map)factories, arg_0);
        }

        private static Function<Item, CreativeModeTab.TabVisibility> makeVisibilityFunc() {
            Object block;
            Reference2ObjectOpenHashMap visibilities = new Reference2ObjectOpenHashMap();
            Map<ItemEntry<Item>, CreativeModeTab.TabVisibility> simpleVisibilities = Map.of(AllItems.BLAZE_CAKE_BASE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
            simpleVisibilities.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeVisibilityFunc$5((Map)visibilities, arg_0, arg_1));
            for (BlockEntry<ValveHandleBlock> blockEntry : AllBlocks.DYED_VALVE_HANDLES) {
                visibilities.put(blockEntry.m_5456_(), CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
            }
            for (BlockEntry blockEntry : AllBlocks.SEATS) {
                block = (SeatBlock)blockEntry.get();
                if (((SeatBlock)block).getColor() == DyeColor.RED) continue;
                visibilities.put(blockEntry.m_5456_(), CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
            }
            for (BlockEntry blockEntry : AllBlocks.TOOLBOXES) {
                block = (ToolboxBlock)blockEntry.get();
                if (((ToolboxBlock)block).getColor() == DyeColor.BROWN) continue;
                visibilities.put(blockEntry.m_5456_(), CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
            }
            return arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeVisibilityFunc$6((Map)visibilities, arg_0);
        }

        public void m_257865_(FeatureFlagSet features, CreativeModeTab.Output output, boolean isOperator) {
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            Predicate<Item> exclusionPredicate = RegistrateDisplayItemsGenerator.makeExclusionPredicate();
            List<ItemOrdering> orderings = RegistrateDisplayItemsGenerator.makeOrderings();
            Function<Item, ItemStack> stackFunc = RegistrateDisplayItemsGenerator.makeStackFunc();
            Function<Item, CreativeModeTab.TabVisibility> visibilityFunc = RegistrateDisplayItemsGenerator.makeVisibilityFunc();
            LinkedList<Item> items = new LinkedList<Item>();
            if (this.addItems) {
                items.addAll(this.collectItems(itemRenderer, true, exclusionPredicate));
            }
            items.addAll(this.collectBlocks(exclusionPredicate));
            if (this.addItems) {
                items.addAll(this.collectItems(itemRenderer, false, exclusionPredicate));
            }
            RegistrateDisplayItemsGenerator.applyOrderings(items, orderings);
            RegistrateDisplayItemsGenerator.outputAll(output, items, stackFunc, visibilityFunc);
        }

        private List<Item> collectBlocks(Predicate<Item> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (AllSections section : this.sections) {
                for (RegistryEntry entry : Create.REGISTRATE.getAll(section, Registries.f_256747_)) {
                    Item item = ((Block)entry.get()).m_5456_();
                    if (item == Items.f_41852_ || exclusionPredicate.test(item)) continue;
                    items.add(item);
                }
            }
            items = new ReferenceArrayList((ReferenceCollection)new ReferenceLinkedOpenHashSet((Collection)items));
            return items;
        }

        private List<Item> collectItems(ItemRenderer itemRenderer, boolean special, Predicate<Item> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (AllSections section : this.sections) {
                for (RegistryEntry entry : Create.REGISTRATE.getAll(section, Registries.f_256913_)) {
                    BakedModel model;
                    Item item = (Item)entry.get();
                    if (item instanceof BlockItem || (model = itemRenderer.m_174264_(new ItemStack((ItemLike)item), null, null, 0)).m_7539_() != special || exclusionPredicate.test(item)) continue;
                    items.add(item);
                }
            }
            return items;
        }

        private static void applyOrderings(List<Item> items, List<ItemOrdering> orderings) {
            for (ItemOrdering ordering : orderings) {
                int anchorIndex = items.indexOf(ordering.anchor());
                if (anchorIndex == -1) continue;
                Item item = ordering.item();
                int itemIndex = items.indexOf(item);
                if (itemIndex != -1) {
                    items.remove(itemIndex);
                    if (itemIndex < anchorIndex) {
                        --anchorIndex;
                    }
                }
                if (ordering.type() == ItemOrdering.Type.AFTER) {
                    items.add(anchorIndex + 1, item);
                    continue;
                }
                items.add(anchorIndex, item);
            }
        }

        private static void outputAll(CreativeModeTab.Output output, List<Item> items, Function<Item, ItemStack> stackFunc, Function<Item, CreativeModeTab.TabVisibility> visibilityFunc) {
            for (Item item : items) {
                output.m_246267_(stackFunc.apply(item), visibilityFunc.apply(item));
            }
        }

        private static /* synthetic */ CreativeModeTab.TabVisibility lambda$makeVisibilityFunc$6(Map visibilities, Item item) {
            CreativeModeTab.TabVisibility visibility = (CreativeModeTab.TabVisibility)visibilities.get(item);
            if (visibility != null) {
                return visibility;
            }
            return CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS;
        }

        private static /* synthetic */ void lambda$makeVisibilityFunc$5(Map visibilities, ItemProviderEntry entry, CreativeModeTab.TabVisibility factory) {
            visibilities.put(entry.m_5456_(), factory);
        }

        private static /* synthetic */ ItemStack lambda$makeStackFunc$4(Map factories, Item item) {
            Function factory = (Function)factories.get(item);
            if (factory != null) {
                return (ItemStack)factory.apply(item);
            }
            return new ItemStack((ItemLike)item);
        }

        private static /* synthetic */ void lambda$makeStackFunc$3(Map factories, ItemProviderEntry entry, Function factory) {
            factories.put(entry.m_5456_(), factory);
        }

        private static /* synthetic */ void lambda$makeOrderings$1(List orderings, ItemProviderEntry entry, ItemProviderEntry otherEntry) {
            orderings.add(ItemOrdering.after(entry.m_5456_(), otherEntry.m_5456_()));
        }

        private static /* synthetic */ void lambda$makeOrderings$0(List orderings, ItemProviderEntry entry, ItemProviderEntry otherEntry) {
            orderings.add(ItemOrdering.before(entry.m_5456_(), otherEntry.m_5456_()));
        }

        private record ItemOrdering(Item item, Item anchor, Type type) {
            public static ItemOrdering before(Item item, Item anchor) {
                return new ItemOrdering(item, anchor, Type.BEFORE);
            }

            public static ItemOrdering after(Item item, Item anchor) {
                return new ItemOrdering(item, anchor, Type.AFTER);
            }

            public static enum Type {
                BEFORE,
                AFTER;

            }
        }
    }
}

