/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.particle.RotationIndicatorParticleData;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class KineticEffectHandler {
    int overStressedTime;
    float overStressedEffect;
    int particleSpawnCountdown;
    KineticTileEntity kte;

    public KineticEffectHandler(KineticTileEntity kte) {
        this.kte = kte;
    }

    public void tick() {
        Level world = this.kte.m_58904_();
        if (world.f_46443_) {
            if (this.overStressedTime > 0 && --this.overStressedTime == 0) {
                if (this.kte.isOverStressed()) {
                    this.overStressedEffect = 1.0f;
                    this.spawnEffect((ParticleOptions)ParticleTypes.f_123762_, 0.2f, 5);
                } else {
                    this.overStressedEffect = -1.0f;
                    this.spawnEffect((ParticleOptions)ParticleTypes.f_123796_, 0.075f, 2);
                }
            }
            if (this.overStressedEffect != 0.0f) {
                this.overStressedEffect -= this.overStressedEffect * 0.1f;
                if (Math.abs(this.overStressedEffect) < 0.0078125f) {
                    this.overStressedEffect = 0.0f;
                }
            }
        } else if (this.particleSpawnCountdown > 0 && --this.particleSpawnCountdown == 0) {
            this.spawnRotationIndicators();
        }
    }

    public void queueRotationIndicators() {
        this.particleSpawnCountdown = 2;
    }

    public void spawnEffect(ParticleOptions particle, float maxMotion, int amount) {
        Level world = this.kte.m_58904_();
        if (world == null) {
            return;
        }
        if (!world.f_46443_) {
            return;
        }
        RandomSource r = world.f_46441_;
        for (int i = 0; i < amount; ++i) {
            Vec3 motion = VecHelper.offsetRandomly(Vec3.f_82478_, r, maxMotion);
            Vec3 position = VecHelper.getCenterOf((Vec3i)this.kte.m_58899_());
            world.m_7106_(particle, position.f_82479_, position.f_82480_, position.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }
    }

    public void spawnRotationIndicators() {
        float speed = this.kte.getSpeed();
        if (speed == 0.0f) {
            return;
        }
        BlockState state = this.kte.m_58900_();
        Block block = state.m_60734_();
        if (!(block instanceof KineticBlock)) {
            return;
        }
        KineticBlock kb = (KineticBlock)block;
        float radius1 = kb.getParticleInitialRadius();
        float radius2 = kb.getParticleTargetRadius();
        Direction.Axis axis = kb.getRotationAxis(state);
        BlockPos pos = this.kte.m_58899_();
        Level world = this.kte.m_58904_();
        if (axis == null) {
            return;
        }
        if (world == null) {
            return;
        }
        char axisChar = axis.name().charAt(0);
        Vec3 vec = VecHelper.getCenterOf((Vec3i)pos);
        IRotate.SpeedLevel speedLevel = IRotate.SpeedLevel.of(speed);
        int color = speedLevel.getColor();
        int particleSpeed = speedLevel.getParticleSpeed();
        particleSpeed = (int)((float)particleSpeed * Math.signum(speed));
        if (world instanceof ServerLevel) {
            RotationIndicatorParticleData particleData = new RotationIndicatorParticleData(color, particleSpeed, radius1, radius2, 10, axisChar);
            ((ServerLevel)world).m_8767_((ParticleOptions)particleData, vec.f_82479_, vec.f_82480_, vec.f_82481_, 20, 0.0, 0.0, 0.0, 1.0);
        }
    }

    public void triggerOverStressedEffect() {
        this.overStressedTime = this.overStressedTime == 0 ? 2 : 0;
    }
}

