/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.flwdata.RotatingData;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.content.contraptions.relays.elementary.ShaftBlock;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class KineticTileInstance<T extends KineticTileEntity>
extends BlockEntityInstance<T> {
    protected final Direction.Axis axis;

    public KineticTileInstance(MaterialManager modelManager, T tile) {
        super(modelManager, tile);
        Direction.Axis axis;
        Block block = this.blockState.m_60734_();
        if (block instanceof IRotate) {
            IRotate irotate = (IRotate)block;
            axis = irotate.getRotationAxis(this.blockState);
        } else {
            axis = Direction.Axis.Y;
        }
        this.axis = axis;
    }

    protected final void updateRotation(RotatingData instance) {
        this.updateRotation(instance, this.getRotationAxis(), this.getTileSpeed());
    }

    protected final void updateRotation(RotatingData instance, Direction.Axis axis) {
        this.updateRotation(instance, axis, this.getTileSpeed());
    }

    protected final void updateRotation(RotatingData instance, float speed) {
        this.updateRotation(instance, this.getRotationAxis(), speed);
    }

    protected final void updateRotation(RotatingData instance, Direction.Axis axis, float speed) {
        instance.setRotationAxis(axis).setRotationOffset(this.getRotationOffset(axis)).setRotationalSpeed(speed).setColor((KineticTileEntity)this.blockEntity);
    }

    protected final RotatingData setup(RotatingData key) {
        return this.setup(key, this.getRotationAxis(), this.getTileSpeed());
    }

    protected final RotatingData setup(RotatingData key, Direction.Axis axis) {
        return this.setup(key, axis, this.getTileSpeed());
    }

    protected final RotatingData setup(RotatingData key, float speed) {
        return this.setup(key, this.getRotationAxis(), speed);
    }

    protected final RotatingData setup(RotatingData key, Direction.Axis axis, float speed) {
        key.setRotationAxis(axis).setRotationalSpeed(speed).setRotationOffset(this.getRotationOffset(axis)).setColor((KineticTileEntity)this.blockEntity).setPosition(this.getInstancePosition());
        return key;
    }

    protected float getRotationOffset(Direction.Axis axis) {
        float offset = ICogWheel.isLargeCog(this.blockState) ? 11.25f : 0.0f;
        double d = ((axis == Direction.Axis.X ? 0 : this.pos.m_123341_()) + (axis == Direction.Axis.Y ? 0 : this.pos.m_123342_()) + (axis == Direction.Axis.Z ? 0 : this.pos.m_123343_())) % 2;
        if (d == 0.0) {
            offset = 22.5f;
        }
        return offset;
    }

    protected Direction.Axis getRotationAxis() {
        return this.axis;
    }

    protected float getTileSpeed() {
        return ((KineticTileEntity)this.blockEntity).getSpeed();
    }

    protected BlockState shaft() {
        return KineticTileInstance.shaft(this.getRotationAxis());
    }

    protected Material<RotatingData> getRotatingMaterial() {
        return this.materialManager.defaultSolid().material(AllMaterialSpecs.ROTATING);
    }

    public static BlockState shaft(Direction.Axis axis) {
        return (BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)ShaftBlock.AXIS, (Comparable)axis);
    }
}

