/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.components.actors.DrillBlock;
import com.simibubi.create.content.contraptions.components.actors.flwdata.ActorData;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ActorInstance;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class DrillActorInstance
extends ActorInstance {
    ActorData drillHead;
    private final Direction facing;

    public DrillActorInstance(MaterialManager materialManager, VirtualRenderWorld contraption, MovementContext context) {
        super(materialManager, contraption, context);
        Material material = materialManager.defaultSolid().material(AllMaterialSpecs.ACTORS);
        BlockState state = context.state;
        this.facing = (Direction)state.m_61143_((Property)DrillBlock.FACING);
        Direction.Axis axis = this.facing.m_122434_();
        float eulerX = AngleHelper.verticalAngle(this.facing);
        float eulerY = axis == Direction.Axis.Y ? 0.0f : this.facing.m_122435_() + (float)(axis == Direction.Axis.X ? 180 : 0);
        this.drillHead = (ActorData)material.getModel(AllBlockPartials.DRILL_HEAD, state).createInstance();
        this.drillHead.setPosition(context.localPos).setBlockLight(this.localBlockLight()).setRotationOffset(0.0f).setRotationAxis(0.0f, 0.0f, 1.0f).setLocalRotation(new Quaternionf().rotationXYZ(eulerX * ((float)Math.PI / 180), eulerY * ((float)Math.PI / 180), 0.0f)).setSpeed(this.getSpeed(this.facing));
    }

    @Override
    public void beginFrame() {
        this.drillHead.setSpeed(this.getSpeed(this.facing));
    }

    protected float getSpeed(Direction facing) {
        if (this.context.contraption.stalled || !VecHelper.isVecPointingTowards(this.context.relativeMotion, facing.m_122424_())) {
            return this.context.getAnimationSpeed();
        }
        return 0.0f;
    }
}

