/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.fan;

import com.simibubi.create.content.contraptions.components.fan.AirCurrent;
import com.simibubi.create.content.contraptions.components.fan.IAirCurrentSource;
import com.simibubi.create.content.contraptions.components.fan.NozzleBlock;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class NozzleTileEntity
extends SmartTileEntity {
    private List<Entity> pushingEntities = new ArrayList<Entity>();
    private float range;
    private boolean pushing;
    private BlockPos fanPos;

    public NozzleTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(5);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        compound.m_128350_("Range", this.range);
        compound.m_128379_("Pushing", this.pushing);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        this.range = compound.m_128457_("Range");
        this.pushing = compound.m_128471_("Pushing");
    }

    @Override
    public void initialize() {
        this.fanPos = this.f_58858_.m_121945_(((Direction)this.m_58900_().m_61143_((Property)NozzleBlock.f_52588_)).m_122424_());
        super.initialize();
    }

    @Override
    public void tick() {
        super.tick();
        float range = this.calcRange();
        if (this.range != range) {
            this.setRange(range);
        }
        Vec3 center = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        if (this.f_58857_.f_46443_ && range != 0.0f && this.f_58857_.f_46441_.m_188503_(Mth.m_14045_((int)((Integer)AllConfigs.SERVER.kinetics.fanPushDistance.get() - (int)range), (int)1, (int)10)) == 0) {
            Vec3 start = VecHelper.offsetRandomly(center, this.f_58857_.f_46441_, this.pushing ? 1.0f : range / 2.0f);
            Vec3 motion = center.m_82546_(start).m_82541_().m_82490_((double)(Mth.m_14036_((float)(range * (this.pushing ? 0.025f : 1.0f)), (float)0.0f, (float)0.5f) * (float)(this.pushing ? -1 : 1)));
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, start.f_82479_, start.f_82480_, start.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }
        Iterator<Entity> iterator = this.pushingEntities.iterator();
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            Vec3 diff = entity.m_20182_().m_82546_(center);
            if (!(entity instanceof Player) && this.f_58857_.f_46443_) continue;
            double distance = diff.m_82553_();
            if (distance > (double)range || entity.m_6144_() || AirCurrent.isPlayerCreativeFlying(entity)) {
                iterator.remove();
                continue;
            }
            if (!this.pushing && distance < 1.5) continue;
            float factor = entity instanceof ItemEntity ? 0.0078125f : 0.03125f;
            Vec3 pushVec = diff.m_82541_().m_82490_(((double)range - distance) * (double)(this.pushing ? 1 : -1));
            entity.m_20256_(entity.m_20184_().m_82549_(pushVec.m_82490_((double)factor)));
            entity.f_19789_ = 0.0f;
            entity.f_19864_ = true;
        }
    }

    public void setRange(float range) {
        this.range = range;
        if (range == 0.0f) {
            this.pushingEntities.clear();
        }
        this.sendData();
    }

    private float calcRange() {
        BlockEntity te = this.f_58857_.m_7702_(this.fanPos);
        if (!(te instanceof IAirCurrentSource)) {
            return 0.0f;
        }
        IAirCurrentSource source = (IAirCurrentSource)te;
        if (source.getAirCurrent() == null) {
            return 0.0f;
        }
        if (source.getSpeed() == 0.0f) {
            return 0.0f;
        }
        this.pushing = source.getAirFlowDirection() == source.getAirflowOriginSide();
        return source.getMaxDistance();
    }

    @Override
    public void lazyTick() {
        Entity entity2;
        super.lazyTick();
        if (this.range == 0.0f) {
            return;
        }
        Vec3 center = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        AABB bb = new AABB(center, center).m_82400_((double)(this.range / 2.0f));
        for (Entity entity2 : this.f_58857_.m_45976_(Entity.class, bb)) {
            Vec3 diff = entity2.m_20182_().m_82546_(center);
            double distance = diff.m_82553_();
            if (distance > (double)this.range || entity2.m_6144_() || AirCurrent.isPlayerCreativeFlying(entity2)) continue;
            boolean canSee = this.canSee(entity2);
            if (!canSee) {
                this.pushingEntities.remove(entity2);
                continue;
            }
            if (this.pushingEntities.contains(entity2)) continue;
            this.pushingEntities.add(entity2);
        }
        Iterator<Entity> iterator = this.pushingEntities.iterator();
        while (iterator.hasNext()) {
            entity2 = iterator.next();
            if (entity2.m_6084_()) continue;
            iterator.remove();
        }
        if (!this.pushing && this.pushingEntities.size() > 256 && !this.f_58857_.f_46443_) {
            this.f_58857_.m_254849_(null, center.f_82479_, center.f_82480_, center.f_82481_, 2.0f, Level.ExplosionInteraction.NONE);
            iterator = this.pushingEntities.iterator();
            while (iterator.hasNext()) {
                entity2 = iterator.next();
                entity2.m_146870_();
                iterator.remove();
            }
        }
    }

    private boolean canSee(Entity entity) {
        ClipContext context = new ClipContext(entity.m_20182_(), VecHelper.getCenterOf((Vec3i)this.f_58858_), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity);
        return this.f_58858_.equals((Object)this.f_58857_.m_45547_(context).m_82425_());
    }
}

