/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.steam;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.components.steam.PoweredShaftBlock;
import com.simibubi.create.content.contraptions.components.steam.SteamEngineTileEntity;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.contraptions.relays.elementary.ShaftBlock;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SteamEngineBlock
extends FaceAttachedHorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
IWrenchable,
ITE<SteamEngineTileEntity> {
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public SteamEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_53179_, (Comparable)AttachFace.FLOOR)).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{f_53179_, f_54117_, BlockStateProperties.f_61362_}));
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return SteamEngineBlock.canAttach(pLevel, pPos, SteamEngineBlock.m_53200_((BlockState)pState).m_122424_());
    }

    public static boolean canAttach(LevelReader pReader, BlockPos pPos, Direction pDirection) {
        BlockPos blockpos = pPos.m_121945_(pDirection);
        return pReader.m_8055_(blockpos).m_60734_() instanceof FluidTankBlock;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ItemStack heldItem = player.m_21120_(hand);
        IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
        if (placementHelper.matchesItem(heldItem)) {
            return placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
        }
        return InteractionResult.PASS;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return state;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        FluidTankBlock.updateBoilerState(pState, pLevel, pPos.m_121945_(SteamEngineBlock.getFacing(pState).m_122424_()));
        BlockPos shaftPos = SteamEngineBlock.getShaftPos(pState, pPos);
        BlockState shaftState = pLevel.m_8055_(shaftPos);
        if (SteamEngineBlock.isShaftValid(pState, shaftState)) {
            pLevel.m_7731_(shaftPos, PoweredShaftBlock.getEquivalent(shaftState), 3);
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!(!pState.m_155947_() || pState.m_60713_(pNewState.m_60734_()) && pNewState.m_155947_())) {
            pLevel.m_46747_(pPos);
        }
        FluidTankBlock.updateBoilerState(pState, pLevel, pPos.m_121945_(SteamEngineBlock.getFacing(pState).m_122424_()));
        BlockPos shaftPos = SteamEngineBlock.getShaftPos(pState, pPos);
        BlockState shaftState = pLevel.m_8055_(shaftPos);
        if (AllBlocks.POWERED_SHAFT.has(shaftState)) {
            pLevel.m_186460_(shaftPos, shaftState.m_60734_(), 1);
        }
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        AttachFace face = (AttachFace)pState.m_61143_((Property)f_53179_);
        Direction direction = (Direction)pState.m_61143_((Property)f_54117_);
        return face == AttachFace.CEILING ? AllShapes.STEAM_ENGINE_CEILING.get(direction.m_122434_()) : (face == AttachFace.FLOOR ? AllShapes.STEAM_ENGINE.get(direction.m_122434_()) : AllShapes.STEAM_ENGINE_WALL.get(direction));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        FluidState ifluidstate = level.m_6425_(pos);
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static Direction getFacing(BlockState sideState) {
        return SteamEngineBlock.m_53200_((BlockState)sideState);
    }

    public static BlockPos getShaftPos(BlockState sideState, BlockPos pos) {
        return pos.m_5484_(SteamEngineBlock.m_53200_((BlockState)sideState), 2);
    }

    public static boolean isShaftValid(BlockState state, BlockState shaft) {
        return (AllBlocks.SHAFT.has(shaft) || AllBlocks.POWERED_SHAFT.has(shaft)) && shaft.m_61143_((Property)ShaftBlock.AXIS) != SteamEngineBlock.getFacing(state).m_122434_();
    }

    @Override
    public Class<SteamEngineTileEntity> getTileEntityClass() {
        return SteamEngineTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends SteamEngineTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.STEAM_ENGINE.get();
    }

    public static Couple<Integer> getSpeedRange() {
        return Couple.create(16, 64);
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> AllBlocks.SHAFT.isIn(arg_0);
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return s -> s.m_60734_() instanceof SteamEngineBlock;
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction direction;
            BlockPos shaftPos = SteamEngineBlock.getShaftPos(state, pos);
            BlockState shaft = AllBlocks.SHAFT.getDefaultState();
            Direction[] directionArray = Direction.m_122382_((Entity)player);
            int n = directionArray.length;
            for (int i = 0; i < n && !SteamEngineBlock.isShaftValid(state, shaft = (BlockState)shaft.m_61124_((Property)ShaftBlock.AXIS, (Comparable)(direction = directionArray[i]).m_122434_())); ++i) {
            }
            BlockState newState = world.m_8055_(shaftPos);
            if (!newState.m_60767_().m_76336_()) {
                return PlacementOffset.fail();
            }
            Direction.Axis axis = (Direction.Axis)shaft.m_61143_((Property)ShaftBlock.AXIS);
            return PlacementOffset.success((Vec3i)shaftPos, s -> (BlockState)BlockHelper.copyProperties(s, AllBlocks.POWERED_SHAFT.getDefaultState()).m_61124_((Property)PoweredShaftBlock.AXIS, (Comparable)axis));
        }
    }
}

