/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.steam;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.steam.PoweredShaftTileEntity;
import com.simibubi.create.content.contraptions.components.steam.SteamEngineBlock;
import com.simibubi.create.content.contraptions.components.steam.SteamEngineTileEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SteamEngineInstance
extends BlockEntityInstance<SteamEngineTileEntity>
implements DynamicInstance {
    protected final ModelData piston;
    protected final ModelData linkage;
    protected final ModelData connector;

    public SteamEngineInstance(MaterialManager materialManager, SteamEngineTileEntity blockEntity) {
        super(materialManager, (BlockEntity)blockEntity);
        this.piston = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(AllBlockPartials.ENGINE_PISTON, this.blockState).createInstance();
        this.linkage = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(AllBlockPartials.ENGINE_LINKAGE, this.blockState).createInstance();
        this.connector = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(AllBlockPartials.ENGINE_CONNECTOR, this.blockState).createInstance();
    }

    public void beginFrame() {
        Float angle = ((SteamEngineTileEntity)this.blockEntity).getTargetAngle();
        if (angle == null) {
            this.piston.setEmptyTransform();
            this.linkage.setEmptyTransform();
            this.connector.setEmptyTransform();
            return;
        }
        Direction facing = SteamEngineBlock.getFacing(this.blockState);
        Direction.Axis facingAxis = facing.m_122434_();
        Direction.Axis axis = Direction.Axis.Y;
        PoweredShaftTileEntity shaft = ((SteamEngineTileEntity)this.blockEntity).getShaft();
        if (shaft != null) {
            axis = KineticTileEntityRenderer.getRotationAxisOf(shaft);
        }
        boolean roll90 = facingAxis.m_122479_() && axis == Direction.Axis.Y || facingAxis.m_122478_() && axis == Direction.Axis.Z;
        float sine = Mth.m_14031_((float)angle.floatValue());
        float sine2 = Mth.m_14031_((float)(angle.floatValue() - 1.5707964f));
        float piston = (1.0f - sine) / 4.0f * 24.0f / 16.0f;
        this.transformed(this.piston, facing, roll90).translate(0.0, (double)piston, 0.0);
        ((ModelData)((ModelData)((ModelData)this.transformed(this.linkage, facing, roll90).centre()).translate(0.0, 1.0, 0.0).unCentre()).translate(0.0, (double)piston, 0.0).translate(0.0, 0.25, 0.5).rotateX((double)(sine2 * 23.0f))).translate(0.0, -0.25, -0.5);
        ((ModelData)((ModelData)this.transformed(this.connector, facing, roll90).translate(0.0, 2.0, 0.0).centre()).rotateXRadians((double)(-angle.floatValue() + 1.5707964f))).unCentre();
    }

    protected ModelData transformed(ModelData modelData, Direction facing, boolean roll90) {
        return (ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)modelData.loadIdentity().translate((Vec3i)this.getInstancePosition())).centre()).rotateY((double)AngleHelper.horizontalAngle(facing))).rotateX((double)(AngleHelper.verticalAngle(facing) + 90.0f))).rotateY(roll90 ? -90.0 : 0.0)).unCentre();
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.piston, this.linkage, this.connector});
    }

    protected void remove() {
        this.piston.delete();
        this.linkage.delete();
        this.connector.delete();
    }
}

