/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.mojang.math.Axis;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.BackHalfShaftInstance;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.IBearingTileEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BearingInstance<B extends KineticTileEntity>
extends BackHalfShaftInstance
implements DynamicInstance {
    final B bearing;
    final OrientedData topInstance;
    final Axis rotationAxis;
    final Quaternionf blockOrientation;

    public BearingInstance(MaterialManager modelManager, B tile) {
        super(modelManager, (KineticTileEntity)tile);
        this.bearing = tile;
        Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        this.rotationAxis = Axis.m_253057_((Vector3f)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.axis).m_253071_());
        this.blockOrientation = BearingInstance.getBlockStateOrientation(facing);
        PartialModel top = ((IBearingTileEntity)this.bearing).isWoodenTop() ? AllBlockPartials.BEARING_TOP_WOODEN : AllBlockPartials.BEARING_TOP;
        this.topInstance = (OrientedData)this.getOrientedMaterial().getModel(top, this.blockState).createInstance();
        this.topInstance.setPosition(this.getInstancePosition()).setRotation(this.blockOrientation);
    }

    public void beginFrame() {
        float interpolatedAngle = ((IBearingTileEntity)this.bearing).getInterpolatedAngle(AnimationTickHolder.getPartialTicks() - 1.0f);
        Quaternionf rot = this.rotationAxis.m_252977_(interpolatedAngle);
        rot.mul((Quaternionfc)this.blockOrientation);
        this.topInstance.setRotation(rot);
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.topInstance});
    }

    @Override
    public void remove() {
        super.remove();
        this.topInstance.delete();
    }

    static Quaternionf getBlockStateOrientation(Direction facing) {
        Quaternionf orientation = facing.m_122434_().m_122479_() ? Axis.f_252436_.m_252977_(AngleHelper.horizontalAngle(facing.m_122424_())) : new Quaternionf();
        orientation.mul((Quaternionfc)Axis.f_252529_.m_252977_(-90.0f - AngleHelper.verticalAngle(facing)));
        return orientation;
    }
}

