/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.mojang.math.Axis;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.BearingInstance;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.StabilizedBearingInstance;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ActorInstance;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class StabilizedBearingMovementBehaviour
implements MovementBehaviour {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        if (ContraptionRenderDispatcher.canInstance()) {
            return;
        }
        Direction facing = (Direction)context.state.m_61143_((Property)BlockStateProperties.f_61372_);
        PartialModel top = AllBlockPartials.BEARING_TOP;
        SuperByteBuffer superBuffer = CachedBufferer.partial(top, context.state);
        float renderPartialTicks = AnimationTickHolder.getPartialTicks();
        Quaternionf orientation = BearingInstance.getBlockStateOrientation(facing);
        float angle = StabilizedBearingMovementBehaviour.getCounterRotationAngle(context, facing, renderPartialTicks) * (float)facing.m_122421_().m_122540_();
        Quaternionf rotation = Axis.m_253057_((Vector3f)facing.m_253071_()).m_252977_(angle);
        rotation.mul((Quaternionfc)orientation);
        orientation = rotation;
        superBuffer.transform(matrices.getModel());
        superBuffer.rotateCentered(orientation);
        superBuffer.light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.getViewProjection(), buffer.m_6299_(RenderType.m_110451_()));
    }

    @Override
    public boolean hasSpecialInstancedRendering() {
        return true;
    }

    @Override
    @Nullable
    public ActorInstance createInstance(MaterialManager materialManager, VirtualRenderWorld simulationWorld, MovementContext context) {
        return new StabilizedBearingInstance(materialManager, simulationWorld, context);
    }

    static float getCounterRotationAngle(MovementContext context, Direction facing, float renderPartialTicks) {
        if (!context.contraption.canBeStabilized(facing, context.localPos)) {
            return 0.0f;
        }
        float offset = 0.0f;
        Direction.Axis axis = facing.m_122434_();
        AbstractContraptionEntity entity = context.contraption.entity;
        if (entity instanceof ControlledContraptionEntity) {
            ControlledContraptionEntity controlledCE = (ControlledContraptionEntity)entity;
            if (context.contraption.canBeStabilized(facing, context.localPos)) {
                offset = -controlledCE.getAngle(renderPartialTicks);
            }
        } else if (entity instanceof OrientedContraptionEntity) {
            OrientedContraptionEntity orientedCE = (OrientedContraptionEntity)entity;
            if (axis.m_122478_()) {
                offset = -orientedCE.m_5675_(renderPartialTicks);
            } else if (orientedCE.isInitialOrientationPresent() && orientedCE.getInitialOrientation().m_122434_() == axis) {
                offset = -orientedCE.m_5686_(renderPartialTicks);
            }
        }
        return offset;
    }
}

