/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.piston;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.PistonExtensionPoleBlock;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;

public class MechanicalPistonBlock
extends DirectionalAxisKineticBlock
implements ITE<MechanicalPistonTileEntity> {
    public static final EnumProperty<PistonState> STATE = EnumProperty.m_61587_((String)"state", PistonState.class);
    protected boolean isSticky;

    public static MechanicalPistonBlock normal(BlockBehaviour.Properties properties) {
        return new MechanicalPistonBlock(properties, false);
    }

    public static MechanicalPistonBlock sticky(BlockBehaviour.Properties properties) {
        return new MechanicalPistonBlock(properties, true);
    }

    protected MechanicalPistonBlock(BlockBehaviour.Properties properties, boolean sticky) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(STATE, (Comparable)((Object)PistonState.RETRACTED)));
        this.isSticky = sticky;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STATE});
        super.m_7926_(builder);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!player.m_36326_()) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (!player.m_21120_(handIn).m_204117_(Tags.Items.SLIMEBALLS)) {
            if (player.m_21120_(handIn).m_41619_()) {
                this.withTileEntityDo((BlockGetter)worldIn, pos, te -> {
                    te.assembleNextTick = true;
                });
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (state.m_61143_(STATE) != PistonState.RETRACTED) {
            return InteractionResult.PASS;
        }
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (hit.m_82434_() != direction) {
            return InteractionResult.PASS;
        }
        if (((MechanicalPistonBlock)state.m_60734_()).isSticky) {
            return InteractionResult.PASS;
        }
        if (worldIn.f_46443_) {
            Vec3 vec = hit.m_82450_();
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123753_, vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0);
            return InteractionResult.SUCCESS;
        }
        AllSoundEvents.SLIME_ADDED.playOnServer(worldIn, (Vec3i)pos, 0.5f, 1.0f);
        if (!player.m_7500_()) {
            player.m_21120_(handIn).m_41774_(1);
        }
        worldIn.m_46597_(pos, (BlockState)((BlockState)AllBlocks.STICKY_MECHANICAL_PISTON.getDefaultState().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)AXIS_ALONG_FIRST_COORDINATE, (Comparable)((Boolean)state.m_61143_((Property)AXIS_ALONG_FIRST_COORDINATE))));
        return InteractionResult.SUCCESS;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block p_220069_4_, BlockPos fromPos, boolean p_220069_6_) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (!fromPos.equals((Object)pos.m_121945_(direction.m_122424_()))) {
            return;
        }
        if (!world.f_46443_ && !world.m_183326_().m_183588_(pos, (Object)this)) {
            world.m_186460_(pos, (Block)this, 0);
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource r) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockState pole = worldIn.m_8055_(pos.m_121945_(direction.m_122424_()));
        if (!AllBlocks.PISTON_EXTENSION_POLE.has(pole)) {
            return;
        }
        if (((Direction)pole.m_61143_((Property)PistonExtensionPoleBlock.f_52588_)).m_122434_() != direction.m_122434_()) {
            return;
        }
        this.withTileEntityDo((BlockGetter)worldIn, pos, te -> {
            if (te.lastException == null) {
                return;
            }
            te.lastException = null;
            te.sendData();
        });
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (state.m_61143_(STATE) != PistonState.RETRACTED) {
            return InteractionResult.PASS;
        }
        return super.onWrenched(state, context);
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockState block;
        BlockPos currentPos;
        int offset;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos pistonHead = null;
        BlockPos pistonBase = pos;
        boolean dropBlocks = player == null || !player.m_7500_();
        Integer maxPoles = MechanicalPistonBlock.maxAllowedPistonPoles();
        for (offset = 1; offset < maxPoles; ++offset) {
            currentPos = pos.m_5484_(direction, offset);
            block = worldIn.m_8055_(currentPos);
            if (MechanicalPistonBlock.isExtensionPole(block) && direction.m_122434_() == ((Direction)block.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_()) continue;
            if (!MechanicalPistonBlock.isPistonHead(block) || block.m_61143_((Property)BlockStateProperties.f_61372_) != direction) break;
            pistonHead = currentPos;
            break;
        }
        if (pistonHead != null && pistonBase != null) {
            BlockPos.m_121990_((BlockPos)pistonBase, pistonHead).filter(p -> !p.equals((Object)pos)).forEach(p -> worldIn.m_46961_(p, dropBlocks));
        }
        for (offset = 1; offset < maxPoles && MechanicalPistonBlock.isExtensionPole(block = worldIn.m_8055_(currentPos = pos.m_5484_(direction.m_122424_(), offset))) && direction.m_122434_() == ((Direction)block.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_(); ++offset) {
            worldIn.m_46961_(currentPos, dropBlocks);
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public static int maxAllowedPistonPoles() {
        return (Integer)AllConfigs.SERVER.kinetics.maxPistonPoles.get();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(STATE) == PistonState.EXTENDED) {
            return AllShapes.MECHANICAL_PISTON_EXTENDED.get((Direction)state.m_61143_((Property)FACING));
        }
        if (state.m_61143_(STATE) == PistonState.MOVING) {
            return AllShapes.MECHANICAL_PISTON.get((Direction)state.m_61143_((Property)FACING));
        }
        return Shapes.m_83144_();
    }

    @Override
    public Class<MechanicalPistonTileEntity> getTileEntityClass() {
        return MechanicalPistonTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends MechanicalPistonTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.MECHANICAL_PISTON.get();
    }

    public static boolean isPiston(BlockState state) {
        return AllBlocks.MECHANICAL_PISTON.has(state) || MechanicalPistonBlock.isStickyPiston(state);
    }

    public static boolean isStickyPiston(BlockState state) {
        return AllBlocks.STICKY_MECHANICAL_PISTON.has(state);
    }

    public static boolean isExtensionPole(BlockState state) {
        return AllBlocks.PISTON_EXTENSION_POLE.has(state);
    }

    public static boolean isPistonHead(BlockState state) {
        return AllBlocks.MECHANICAL_PISTON_HEAD.has(state);
    }

    public static enum PistonState implements StringRepresentable
    {
        RETRACTED,
        MOVING,
        EXTENDED;


        public String m_7912_() {
            return Lang.asId(this.name());
        }
    }
}

