/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.fluids.actors.FillingRecipe;
import com.simibubi.create.content.contraptions.fluids.actors.GenericItemFilling;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class FillingBySpout {
    static RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));

    public static boolean canItemBeFilled(Level world, ItemStack stack) {
        wrapper.m_6836_(0, stack);
        Optional<FillingRecipe> assemblyRecipe = SequencedAssemblyRecipe.getRecipe(world, wrapper, AllRecipeTypes.FILLING.getType(), FillingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return true;
        }
        if (AllRecipeTypes.FILLING.find(wrapper, world).isPresent()) {
            return true;
        }
        return GenericItemFilling.canItemBeFilled(world, stack);
    }

    public static int getRequiredAmountForItem(Level world, ItemStack stack, FluidStack availableFluid) {
        FluidIngredient requiredFluid;
        wrapper.m_6836_(0, stack);
        Optional<FillingRecipe> assemblyRecipe = SequencedAssemblyRecipe.getRecipe(world, wrapper, AllRecipeTypes.FILLING.getType(), FillingRecipe.class);
        if (assemblyRecipe.isPresent() && (requiredFluid = assemblyRecipe.get().getRequiredFluid()).test(availableFluid)) {
            return requiredFluid.getRequiredAmount();
        }
        for (Recipe recipe : world.m_7465_().m_44056_(AllRecipeTypes.FILLING.getType(), (Container)wrapper, world)) {
            FillingRecipe fillingRecipe = (FillingRecipe)recipe;
            FluidIngredient requiredFluid2 = fillingRecipe.getRequiredFluid();
            if (!requiredFluid2.test(availableFluid)) continue;
            return requiredFluid2.getRequiredAmount();
        }
        return GenericItemFilling.getRequiredAmountForItem(world, stack, availableFluid);
    }

    public static ItemStack fillItem(Level world, int requiredAmount, ItemStack stack, FluidStack availableFluid) {
        FluidStack toFill = availableFluid.copy();
        toFill.setAmount(requiredAmount);
        wrapper.m_6836_(0, stack);
        FillingRecipe fillingRecipe = SequencedAssemblyRecipe.getRecipe(world, wrapper, AllRecipeTypes.FILLING.getType(), FillingRecipe.class).filter(fr -> fr.getRequiredFluid().test(toFill)).orElseGet(() -> {
            for (Recipe recipe : world.m_7465_().m_44056_(AllRecipeTypes.FILLING.getType(), (Container)wrapper, world)) {
                FillingRecipe fr = (FillingRecipe)recipe;
                FluidIngredient requiredFluid = fr.getRequiredFluid();
                if (!requiredFluid.test(toFill)) continue;
                return fr;
            }
            return null;
        });
        if (fillingRecipe != null) {
            List<ItemStack> results = fillingRecipe.rollResults();
            availableFluid.shrink(requiredAmount);
            stack.m_41774_(1);
            return results.isEmpty() ? ItemStack.f_41583_ : results.get(0);
        }
        return GenericItemFilling.fillItem(world, requiredAmount, stack, availableFluid);
    }
}

