/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.particle;

import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.content.contraptions.fluids.particle.BasinFluidParticle;
import com.simibubi.create.content.contraptions.fluids.particle.FluidParticleData;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluid;
import com.simibubi.create.foundation.utility.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class FluidStackParticle
extends TextureSheetParticle {
    private final float uo;
    private final float vo;
    private FluidStack fluid;
    private IClientFluidTypeExtensions clientFluid;

    public static FluidStackParticle create(ParticleType<FluidParticleData> type, ClientLevel world, FluidStack fluid, double x, double y, double z, double vx, double vy, double vz) {
        if (type == AllParticleTypes.BASIN_FLUID.get()) {
            return new BasinFluidParticle(world, fluid, x, y, z, vx, vy, vz);
        }
        return new FluidStackParticle(world, fluid, x, y, z, vx, vy, vz);
    }

    public FluidStackParticle(ClientLevel world, FluidStack fluid, double x, double y, double z, double vx, double vy, double vz) {
        super(world, x, y, z, vx, vy, vz);
        this.clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        this.fluid = fluid;
        this.m_108337_((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(this.clientFluid.getStillTexture(fluid)));
        this.f_107226_ = 1.0f;
        this.f_107227_ = 0.8f;
        this.f_107228_ = 0.8f;
        this.f_107229_ = 0.8f;
        this.multiplyColor(this.clientFluid.getTintColor(fluid));
        this.f_107215_ = vx;
        this.f_107216_ = vy;
        this.f_107217_ = vz;
        this.f_107663_ /= 2.0f;
        this.uo = this.f_107223_.m_188501_() * 3.0f;
        this.vo = this.f_107223_.m_188501_() * 3.0f;
    }

    protected int m_6355_(float p_189214_1_) {
        int brightnessForRender = super.m_6355_(p_189214_1_);
        int skyLight = brightnessForRender >> 20;
        int blockLight = brightnessForRender >> 4 & 0xF;
        blockLight = Math.max(blockLight, this.fluid.getFluid().getFluidType().getLightLevel(this.fluid));
        return skyLight << 20 | blockLight << 4;
    }

    protected void multiplyColor(int color) {
        this.f_107227_ *= (float)(color >> 16 & 0xFF) / 255.0f;
        this.f_107228_ *= (float)(color >> 8 & 0xFF) / 255.0f;
        this.f_107229_ *= (float)(color & 0xFF) / 255.0f;
    }

    protected float m_5970_() {
        return this.f_108321_.m_118367_((double)((this.uo + 1.0f) / 4.0f * 16.0f));
    }

    protected float m_5952_() {
        return this.f_108321_.m_118367_((double)(this.uo / 4.0f * 16.0f));
    }

    protected float m_5951_() {
        return this.f_108321_.m_118393_((double)(this.vo / 4.0f * 16.0f));
    }

    protected float m_5950_() {
        return this.f_108321_.m_118393_((double)((this.vo + 1.0f) / 4.0f * 16.0f));
    }

    public void m_5989_() {
        super.m_5989_();
        if (!this.canEvaporate()) {
            return;
        }
        if (this.f_107218_) {
            this.m_107274_();
        }
        if (!this.f_107220_) {
            return;
        }
        if (!this.f_107218_ && this.f_107208_.f_46441_.m_188501_() < 0.125f) {
            return;
        }
        Color color = new Color(this.clientFluid.getTintColor(this.fluid));
        this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.f_107212_, this.f_107213_, this.f_107214_, (double)color.getRedAsFloat(), (double)color.getGreenAsFloat(), (double)color.getBlueAsFloat());
    }

    protected boolean canEvaporate() {
        return this.fluid.getFluid() instanceof PotionFluid;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107429_;
    }
}

