/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.pipes;

import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.relays.elementary.AbstractSimpleShaftBlock;
import com.simibubi.create.content.contraptions.relays.elementary.CogWheelBlock;
import com.simibubi.create.foundation.block.WrenchableDirectionalBlock;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BracketBlock
extends WrenchableDirectionalBlock {
    public static final BooleanProperty AXIS_ALONG_FIRST_COORDINATE = DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE;
    public static final EnumProperty<BracketType> TYPE = EnumProperty.m_61587_((String)"type", BracketType.class);

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{AXIS_ALONG_FIRST_COORDINATE}).m_61104_(new Property[]{TYPE}));
    }

    public BracketBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Optional<BlockState> getSuitableBracket(BlockState blockState, Direction direction) {
        if (blockState.m_60734_() instanceof AbstractSimpleShaftBlock) {
            return this.getSuitableBracket((Direction.Axis)blockState.m_61143_(RotatedPillarKineticBlock.AXIS), direction, blockState.m_60734_() instanceof CogWheelBlock ? BracketType.COG : BracketType.SHAFT);
        }
        return this.getSuitableBracket(FluidPropagator.getStraightPipeAxis(blockState), direction, BracketType.PIPE);
    }

    private Optional<BlockState> getSuitableBracket(Direction.Axis targetBlockAxis, Direction direction, BracketType type) {
        Direction.Axis axis = direction.m_122434_();
        if (targetBlockAxis == null || targetBlockAxis == axis) {
            return Optional.empty();
        }
        boolean alongFirst = axis != Direction.Axis.Z ? targetBlockAxis == Direction.Axis.Z : targetBlockAxis == Direction.Axis.Y;
        return Optional.of((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)type))).m_61124_((Property)f_52588_, (Comparable)direction)).m_61124_((Property)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(!alongFirst)));
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rot) {
        if (rot.ordinal() % 2 == 1) {
            state = (BlockState)state.m_61122_((Property)AXIS_ALONG_FIRST_COORDINATE);
        }
        return super.m_6843_(state, rot);
    }

    public static enum BracketType implements StringRepresentable
    {
        PIPE,
        COG,
        SHAFT;


        public String m_7912_() {
            return Lang.asId(this.name());
        }
    }
}

