/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.contraptions.processing.BasinBlock;
import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.tileEntity.renderer.SmartTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class BasinRenderer
extends SmartTileEntityRenderer<BasinTileEntity> {
    public BasinRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(BasinTileEntity basin, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe(basin, partialTicks, ms, buffer, light, overlay);
        float fluidLevel = this.renderFluids(basin, partialTicks, ms, buffer, light, overlay);
        float level = Mth.m_14036_((float)(fluidLevel - 0.3f), (float)0.125f, (float)0.6f);
        ms.m_85836_();
        BlockPos pos = basin.m_58899_();
        ms.m_85837_(0.5, (double)0.2f, 0.5);
        TransformStack.cast((PoseStack)ms).rotateY((double)basin.ingredientRotation.getValue(partialTicks));
        RandomSource r = RandomSource.m_216335_((long)pos.hashCode());
        Vec3 baseVector = new Vec3(0.125, (double)level, 0.0);
        IItemHandlerModifiable inv = (IItemHandlerModifiable)basin.itemCapability.orElse((Object)new ItemStackHandler());
        int itemCount = 0;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            if (inv.getStackInSlot(slot).m_41619_()) continue;
            ++itemCount;
        }
        if (itemCount == 1) {
            baseVector = new Vec3(0.0, (double)level, 0.0);
        }
        float anglePartition = 360.0f / (float)itemCount;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            ms.m_85836_();
            if (fluidLevel > 0.0f) {
                ms.m_252880_(0.0f, (Mth.m_14031_((float)(AnimationTickHolder.getRenderTime((LevelAccessor)basin.m_58904_()) / 12.0f + anglePartition * (float)itemCount)) + 1.5f) * 1.0f / 32.0f, 0.0f);
            }
            Vec3 itemPosition = VecHelper.rotate(baseVector, anglePartition * (float)itemCount, Direction.Axis.Y);
            ms.m_85837_(itemPosition.f_82479_, itemPosition.f_82480_, itemPosition.f_82481_);
            ((TransformStack)TransformStack.cast((PoseStack)ms).rotateY((double)(anglePartition * (float)itemCount + 35.0f))).rotateX(65.0);
            for (int i = 0; i <= stack.m_41613_() / 8; ++i) {
                ms.m_85836_();
                Vec3 vec = VecHelper.offsetRandomly(Vec3.f_82478_, r, 0.0625f);
                ms.m_85837_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
                this.renderItem(ms, buffer, light, overlay, stack);
                ms.m_85849_();
            }
            ms.m_85849_();
            --itemCount;
        }
        ms.m_85849_();
        BlockState blockState = basin.m_58900_();
        if (!(blockState.m_60734_() instanceof BasinBlock)) {
            return;
        }
        Direction direction = (Direction)blockState.m_61143_((Property)BasinBlock.FACING);
        if (direction == Direction.DOWN) {
            return;
        }
        Vec3 directionVec = Vec3.m_82528_((Vec3i)direction.m_122436_());
        Vec3 outVec = VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_).m_82549_(directionVec.m_82490_(0.55).m_82492_(0.0, 0.5, 0.0));
        boolean outToBasin = basin.m_58904_().m_8055_(basin.m_58899_().m_121945_(direction)).m_60734_() instanceof BasinBlock;
        for (IntAttached<ItemStack> intAttached : basin.visualizedOutputItems) {
            float progress = 1.0f - ((float)((Integer)intAttached.getFirst()).intValue() - partialTicks) / 10.0f;
            if (!outToBasin && progress > 0.35f) continue;
            ms.m_85836_();
            ((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).translate(outVec)).translate(new Vec3(0.0, (double)Math.max(-0.55f, -(progress * progress * 2.0f)), 0.0))).translate(directionVec.m_82490_((double)(progress * 0.5f)))).rotateY((double)AngleHelper.horizontalAngle(direction))).rotateX((double)(progress * 180.0f));
            this.renderItem(ms, buffer, light, overlay, intAttached.getValue());
            ms.m_85849_();
        }
    }

    protected void renderItem(PoseStack ms, MultiBufferSource buffer, int light, int overlay, ItemStack stack) {
        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.GROUND, light, overlay, ms, buffer, 0);
    }

    protected float renderFluids(BasinTileEntity basin, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        SmartFluidTankBehaviour inputFluids = basin.getBehaviour(SmartFluidTankBehaviour.INPUT);
        SmartFluidTankBehaviour outputFluids = basin.getBehaviour(SmartFluidTankBehaviour.OUTPUT);
        SmartFluidTankBehaviour[] tanks = new SmartFluidTankBehaviour[]{inputFluids, outputFluids};
        float totalUnits = basin.getTotalFluidUnits(partialTicks);
        if (totalUnits < 1.0f) {
            return 0.0f;
        }
        float fluidLevel = Mth.m_14036_((float)(totalUnits / 2000.0f), (float)0.0f, (float)1.0f);
        fluidLevel = 1.0f - (1.0f - fluidLevel) * (1.0f - fluidLevel);
        float xMin = 0.125f;
        float xMax = 0.125f;
        float yMin = 0.125f;
        float yMax = 0.125f + 0.75f * fluidLevel;
        float zMin = 0.125f;
        float zMax = 0.875f;
        for (SmartFluidTankBehaviour behaviour : tanks) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                float units;
                FluidStack renderedFluid = tankSegment.getRenderedFluid();
                if (renderedFluid.isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
                float partial = Mth.m_14036_((float)(units / totalUnits), (float)0.0f, (float)1.0f);
                FluidRenderer.renderFluidBox(renderedFluid, xMin, 0.125f, 0.125f, xMax += partial * 12.0f / 16.0f, yMax, 0.875f, buffer, ms, light, false);
                xMin = xMax;
            }
        }
        return yMax;
    }

    public int m_142163_() {
        return 16;
    }
}

