/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileInstance;
import com.simibubi.create.content.contraptions.base.flwdata.BeltData;
import com.simibubi.create.content.contraptions.base.flwdata.RotatingData;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltPart;
import com.simibubi.create.content.contraptions.relays.belt.BeltRenderer;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LightLayer;
import org.joml.Quaternionf;

public class BeltInstance
extends KineticTileInstance<BeltTileEntity> {
    boolean upward;
    boolean diagonal;
    boolean sideways;
    boolean vertical;
    boolean alongX;
    boolean alongZ;
    BeltSlope beltSlope;
    Direction facing;
    protected ArrayList<BeltData> keys;
    protected RotatingData pulleyKey;

    public BeltInstance(MaterialManager materialManager, BeltTileEntity tile) {
        super(materialManager, tile);
        if (!AllBlocks.BELT.has(this.blockState)) {
            return;
        }
        this.keys = new ArrayList(2);
        this.beltSlope = (BeltSlope)((Object)this.blockState.m_61143_(BeltBlock.SLOPE));
        this.facing = (Direction)this.blockState.m_61143_(BeltBlock.HORIZONTAL_FACING);
        this.upward = this.beltSlope == BeltSlope.UPWARD;
        this.diagonal = this.beltSlope.isDiagonal();
        this.sideways = this.beltSlope == BeltSlope.SIDEWAYS;
        this.vertical = this.beltSlope == BeltSlope.VERTICAL;
        this.alongX = this.facing.m_122434_() == Direction.Axis.X;
        this.alongZ = this.facing.m_122434_() == Direction.Axis.Z;
        BeltPart part = (BeltPart)((Object)this.blockState.m_61143_(BeltBlock.PART));
        boolean start = part == BeltPart.START;
        boolean end = part == BeltPart.END;
        DyeColor color = tile.color.orElse(null);
        for (boolean bottom : Iterate.trueAndFalse) {
            PartialModel beltPartial = BeltRenderer.getBeltPartial(this.diagonal, start, end, bottom);
            SpriteShiftEntry spriteShift = BeltRenderer.getSpriteShiftEntry(color, this.diagonal, bottom);
            Instancer beltModel = materialManager.defaultSolid().material(AllMaterialSpecs.BELTS).getModel(beltPartial, this.blockState);
            this.keys.add(this.setup((BeltData)beltModel.createInstance(), bottom, spriteShift));
            if (this.diagonal) break;
        }
        if (tile.hasPulley()) {
            Instancer<RotatingData> pulleyModel = this.getPulleyModel();
            this.pulleyKey = this.setup((RotatingData)pulleyModel.createInstance());
        }
    }

    public void update() {
        DyeColor color = ((BeltTileEntity)this.blockEntity).color.orElse(null);
        boolean bottom = true;
        for (BeltData key : this.keys) {
            SpriteShiftEntry spriteShiftEntry = BeltRenderer.getSpriteShiftEntry(color, this.diagonal, bottom);
            key.setScrollTexture(spriteShiftEntry).setColor((KineticTileEntity)this.blockEntity).setRotationalSpeed(this.getScrollSpeed());
            bottom = false;
        }
        if (this.pulleyKey != null) {
            this.updateRotation(this.pulleyKey);
        }
    }

    public void updateLight() {
        this.relight(this.pos, this.keys.stream());
        if (this.pulleyKey != null) {
            this.relight(this.pos, new FlatLit[]{this.pulleyKey});
        }
    }

    public void remove() {
        this.keys.forEach(InstanceData::delete);
        this.keys.clear();
        if (this.pulleyKey != null) {
            this.pulleyKey.delete();
        }
        this.pulleyKey = null;
    }

    private float getScrollSpeed() {
        float speed = ((BeltTileEntity)this.blockEntity).getSpeed();
        if (this.facing.m_122421_() == Direction.AxisDirection.NEGATIVE ^ this.upward ^ (this.alongX && !this.diagonal || this.alongZ && this.diagonal)) {
            speed = -speed;
        }
        if (this.sideways && (this.facing == Direction.SOUTH || this.facing == Direction.WEST) || this.vertical && this.facing == Direction.EAST) {
            speed = -speed;
        }
        return speed;
    }

    private Instancer<RotatingData> getPulleyModel() {
        Direction dir = this.getOrientation();
        Direction.Axis axis = dir.m_122434_();
        Supplier<PoseStack> ms = () -> {
            PoseStack modelTransform = new PoseStack();
            TransformStack msr = TransformStack.cast((PoseStack)modelTransform);
            msr.centre();
            if (axis == Direction.Axis.X) {
                msr.rotateY(90.0);
            }
            if (axis == Direction.Axis.Y) {
                msr.rotateX(90.0);
            }
            msr.rotateX(90.0);
            msr.unCentre();
            return modelTransform;
        };
        return this.getRotatingMaterial().getModel(AllBlockPartials.BELT_PULLEY, this.blockState, dir, ms);
    }

    private Direction getOrientation() {
        Direction dir = ((Direction)this.blockState.m_61143_(BeltBlock.HORIZONTAL_FACING)).m_122427_();
        if (this.beltSlope == BeltSlope.SIDEWAYS) {
            dir = Direction.UP;
        }
        return dir;
    }

    private BeltData setup(BeltData key, boolean bottom, SpriteShiftEntry spriteShift) {
        boolean downward = this.beltSlope == BeltSlope.DOWNWARD;
        float rotX = (!this.diagonal && this.beltSlope != BeltSlope.HORIZONTAL ? 90 : 0) + (downward ? 180 : 0) + (this.sideways ? 90 : 0) + (this.vertical && this.alongZ ? 180 : 0);
        float rotY = this.facing.m_122435_() + (float)(this.diagonal ^ this.alongX && !downward ? 180 : 0) + (float)(this.sideways && this.alongZ ? 180 : 0) + (float)(this.vertical && this.alongX ? 90 : 0);
        float rotZ = (this.sideways ? 90 : 0) + (this.vertical && this.alongX ? 90 : 0);
        Quaternionf q = new Quaternionf().rotationXYZ(rotX * ((float)Math.PI / 180), rotY * ((float)Math.PI / 180), rotZ * ((float)Math.PI / 180));
        key.setScrollTexture(spriteShift).setScrollMult(this.diagonal ? 0.375f : 0.5f).setRotation(q).setRotationalSpeed(this.getScrollSpeed()).setRotationOffset(bottom ? 0.5f : 0.0f).setColor((KineticTileEntity)this.blockEntity).setPosition(this.getInstancePosition()).setBlockLight(this.world.m_45517_(LightLayer.BLOCK, this.pos)).setSkyLight(this.world.m_45517_(LightLayer.SKY, this.pos));
        return key;
    }
}

