/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.elementary;

import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.function.Predicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BracketedTileEntityBehaviour
extends TileEntityBehaviour {
    public static final BehaviourType<BracketedTileEntityBehaviour> TYPE = new BehaviourType();
    private BlockState bracket;
    private boolean reRender;
    private Predicate<BlockState> pred;

    public BracketedTileEntityBehaviour(SmartTileEntity te) {
        this(te, state -> true);
    }

    public BracketedTileEntityBehaviour(SmartTileEntity te, Predicate<BlockState> pred) {
        super(te);
        this.pred = pred;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void applyBracket(BlockState state) {
        this.bracket = state;
        this.reRender = true;
        this.tileEntity.notifyUpdate();
        Level world = this.getWorld();
        if (world.f_46443_) {
            return;
        }
        this.tileEntity.m_58900_().m_60701_((LevelAccessor)world, this.getPos(), 3);
    }

    public void transformBracket(StructureTransform transform) {
        if (this.isBracketPresent()) {
            BlockState transformedBracket = transform.apply(this.bracket);
            this.applyBracket(transformedBracket);
        }
    }

    @Nullable
    public BlockState removeBracket(boolean inOnReplacedContext) {
        if (this.bracket == null) {
            return null;
        }
        BlockState removed = this.bracket;
        Level world = this.getWorld();
        if (!world.f_46443_) {
            world.m_46796_(2001, this.getPos(), Block.m_49956_((BlockState)this.bracket));
        }
        this.bracket = null;
        this.reRender = true;
        if (inOnReplacedContext) {
            this.tileEntity.sendData();
            return removed;
        }
        this.tileEntity.notifyUpdate();
        if (world.f_46443_) {
            return removed;
        }
        this.tileEntity.m_58900_().m_60701_((LevelAccessor)world, this.getPos(), 3);
        return removed;
    }

    public boolean isBracketPresent() {
        return this.bracket != null;
    }

    @Nullable
    public BlockState getBracket() {
        return this.bracket;
    }

    public boolean canHaveBracket() {
        return this.pred.test(this.tileEntity.m_58900_());
    }

    @Override
    public ItemRequirement getRequiredItems() {
        if (!this.isBracketPresent()) {
            return ItemRequirement.NONE;
        }
        return ItemRequirement.of(this.bracket, null);
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(CompoundTag nbt, boolean clientPacket) {
        if (this.isBracketPresent()) {
            nbt.m_128365_("Bracket", (Tag)NbtUtils.m_129202_((BlockState)this.bracket));
        }
        if (clientPacket && this.reRender) {
            NBTHelper.putMarker(nbt, "Redraw");
            this.reRender = false;
        }
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        if (nbt.m_128441_("Bracket")) {
            this.bracket = NbtUtils.m_247651_((HolderGetter)this.getWorld().m_246945_(Registries.f_256747_), (CompoundTag)nbt.m_128469_("Bracket"));
        }
        if (clientPacket && nbt.m_128441_("Redraw")) {
            this.getWorld().m_7260_(this.getPos(), this.tileEntity.m_58900_(), this.tileEntity.m_58900_(), 16);
        }
        super.read(nbt, clientPacket);
    }
}

