/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.elementary;

import com.google.common.base.Predicates;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.contraptions.components.steam.PoweredShaftBlock;
import com.simibubi.create.content.contraptions.relays.elementary.AbstractSimpleShaftBlock;
import com.simibubi.create.content.contraptions.relays.elementary.EncasableBlock;
import com.simibubi.create.content.curiosities.girder.GirderEncasedShaftBlock;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import com.simibubi.create.foundation.utility.placement.util.PoleHelper;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShaftBlock
extends AbstractSimpleShaftBlock
implements EncasableBlock {
    public static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public ShaftBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static boolean isShaft(BlockState state) {
        return AllBlocks.SHAFT.has(state);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        return ShaftBlock.pickCorrectShaftType(stateForPlacement, context.m_43725_(), context.m_8083_());
    }

    public static BlockState pickCorrectShaftType(BlockState stateForPlacement, Level level, BlockPos pos) {
        if (PoweredShaftBlock.stillValid(stateForPlacement, (LevelReader)level, pos)) {
            return PoweredShaftBlock.getEquivalent(stateForPlacement);
        }
        return stateForPlacement;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.SIX_VOXEL_POLE.get((Direction.Axis)state.m_61143_((Property)AXIS));
    }

    @Override
    public float getParticleTargetRadius() {
        return 0.35f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 0.125f;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (player.m_6144_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        InteractionResult result = this.tryEncase(state, world, pos, heldItem, player, hand, ray);
        if (result.m_19077_()) {
            return result;
        }
        if (AllBlocks.METAL_GIRDER.isIn(heldItem) && state.m_61143_((Property)AXIS) != Direction.Axis.Y) {
            KineticTileEntity.switchToBlockState(world, pos, (BlockState)((BlockState)AllBlocks.METAL_GIRDER_ENCASED_SHAFT.getDefaultState().m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)))).m_61124_(GirderEncasedShaftBlock.HORIZONTAL_AXIS, (Comparable)(state.m_61143_((Property)AXIS) == Direction.Axis.Z ? Direction.Axis.Z : Direction.Axis.X)));
            if (!world.f_46443_ && !player.m_7500_()) {
                heldItem.m_41774_(1);
                if (heldItem.m_41619_()) {
                    player.m_21008_(hand, ItemStack.f_41583_);
                }
            }
            return InteractionResult.SUCCESS;
        }
        IPlacementHelper helper = PlacementHelpers.get(placementHelperId);
        if (helper.matchesItem(heldItem)) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
        }
        return InteractionResult.PASS;
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    extends PoleHelper<Direction.Axis> {
        private PlacementHelper() {
            super(state -> state.m_60734_() instanceof AbstractSimpleShaftBlock || state.m_60734_() instanceof PoweredShaftBlock, state -> (Direction.Axis)state.m_61143_(RotatedPillarKineticBlock.AXIS), RotatedPillarKineticBlock.AXIS);
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.m_41720_() instanceof BlockItem && ((BlockItem)i.m_41720_()).m_40614_() instanceof AbstractSimpleShaftBlock;
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return Predicates.or(arg_0 -> AllBlocks.SHAFT.has(arg_0), arg_0 -> AllBlocks.POWERED_SHAFT.has(arg_0));
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            PlacementOffset offset = super.getOffset(player, world, state, pos, ray);
            if (offset.isSuccessful()) {
                offset.withTransform(offset.getTransform().andThen(s -> ShaftBlock.pickCorrectShaftType(s, world, offset.getBlockPos())));
            }
            return offset;
        }
    }
}

