/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.encased;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.ITransformableBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.contraptions.relays.elementary.CogWheelBlock;
import com.simibubi.create.content.contraptions.relays.elementary.EncasedBlock;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.content.contraptions.relays.elementary.SimpleKineticTileEntity;
import com.simibubi.create.content.schematics.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VoxelShaper;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class EncasedCogwheelBlock
extends RotatedPillarKineticBlock
implements ICogWheel,
ITE<SimpleKineticTileEntity>,
ISpecialBlockItemRequirement,
ITransformableBlock,
EncasedBlock {
    public static final BooleanProperty TOP_SHAFT = BooleanProperty.m_61465_((String)"top_shaft");
    public static final BooleanProperty BOTTOM_SHAFT = BooleanProperty.m_61465_((String)"bottom_shaft");
    protected final boolean isLarge;
    private final Supplier<Block> casing;

    public EncasedCogwheelBlock(BlockBehaviour.Properties properties, boolean large, Supplier<Block> casing) {
        super(properties);
        this.isLarge = large;
        this.casing = casing;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TOP_SHAFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOTTOM_SHAFT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{TOP_SHAFT, BOTTOM_SHAFT}));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        if (target instanceof BlockHitResult) {
            return ((BlockHitResult)target).m_82434_().m_122434_() != this.getRotationAxis(state) ? (this.isLarge ? AllBlocks.LARGE_COGWHEEL.asStack() : AllBlocks.COGWHEEL.asStack()) : this.getCasing().m_5456_().m_7968_();
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState placedOn = context.m_43725_().m_8055_(context.m_8083_().m_121945_(context.m_43719_().m_122424_()));
        BlockState stateForPlacement = super.m_5573_(context);
        if (ICogWheel.isSmallCog(placedOn)) {
            stateForPlacement = (BlockState)stateForPlacement.m_61124_((Property)AXIS, (Comparable)((IRotate)placedOn.m_60734_()).getRotationAxis(placedOn));
        }
        return stateForPlacement;
    }

    public boolean m_6104_(BlockState pState, BlockState pAdjacentBlockState, Direction pDirection) {
        return pState.m_60734_() == pAdjacentBlockState.m_60734_() && pState.m_61143_((Property)AXIS) == pAdjacentBlockState.m_61143_((Property)AXIS);
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.m_43719_().m_122434_() != state.m_61143_((Property)AXIS)) {
            return super.onWrenched(state, context);
        }
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        KineticTileEntity.switchToBlockState(level, pos, (BlockState)state.m_61122_((Property)(context.m_43719_().m_122421_() == Direction.AxisDirection.POSITIVE ? TOP_SHAFT : BOTTOM_SHAFT)));
        this.playRotateSound(level, pos);
        return InteractionResult.SUCCESS;
    }

    @Override
    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        originalState = this.swapShaftsForRotation(originalState, Rotation.CLOCKWISE_90, targetedFace.m_122434_());
        return (BlockState)originalState.m_61124_(RotatedPillarKineticBlock.AXIS, (Comparable)VoxelShaper.axisAsFace((Direction.Axis)originalState.m_61143_(RotatedPillarKineticBlock.AXIS)).m_175362_(targetedFace.m_122434_()).m_122434_());
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        context.m_43725_().m_46796_(2001, context.m_8083_(), Block.m_49956_((BlockState)state));
        KineticTileEntity.switchToBlockState(context.m_43725_(), context.m_8083_(), (BlockState)(this.isLarge ? AllBlocks.LARGE_COGWHEEL : AllBlocks.COGWHEEL).getDefaultState().m_61124_((Property)AXIS, (Comparable)((Direction.Axis)state.m_61143_((Property)AXIS))));
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == state.m_61143_((Property)AXIS) && (Boolean)state.m_61143_((Property)(face.m_122421_() == Direction.AxisDirection.POSITIVE ? TOP_SHAFT : BOTTOM_SHAFT)) != false;
    }

    @Override
    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        if (newState.m_60734_() instanceof EncasedCogwheelBlock && oldState.m_60734_() instanceof EncasedCogwheelBlock) {
            if (newState.m_61143_((Property)TOP_SHAFT) != oldState.m_61143_((Property)TOP_SHAFT)) {
                return false;
            }
            if (newState.m_61143_((Property)BOTTOM_SHAFT) != oldState.m_61143_((Property)BOTTOM_SHAFT)) {
                return false;
            }
        }
        return super.areStatesKineticallyEquivalent(oldState, newState);
    }

    @Override
    public boolean isSmallCog() {
        return !this.isLarge;
    }

    @Override
    public boolean isLargeCog() {
        return this.isLarge;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return CogWheelBlock.isValidCogwheelPosition(ICogWheel.isLargeCog(state), worldIn, pos, (Direction.Axis)state.m_61143_((Property)AXIS));
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.m_61143_((Property)AXIS);
    }

    public BlockState swapShafts(BlockState state) {
        boolean bottom = (Boolean)state.m_61143_((Property)BOTTOM_SHAFT);
        boolean top = (Boolean)state.m_61143_((Property)TOP_SHAFT);
        state = (BlockState)state.m_61124_((Property)BOTTOM_SHAFT, (Comparable)Boolean.valueOf(top));
        state = (BlockState)state.m_61124_((Property)TOP_SHAFT, (Comparable)Boolean.valueOf(bottom));
        return state;
    }

    public BlockState swapShaftsForRotation(BlockState state, Rotation rotation, Direction.Axis rotationAxis) {
        boolean clockwise;
        if (rotation == Rotation.NONE) {
            return state;
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)AXIS);
        if (axis == rotationAxis) {
            return state;
        }
        if (rotation == Rotation.CLOCKWISE_180) {
            return this.swapShafts(state);
        }
        boolean bl = clockwise = rotation == Rotation.CLOCKWISE_90;
        if (rotationAxis == Direction.Axis.X ? axis == Direction.Axis.Z && !clockwise || axis == Direction.Axis.Y && clockwise : (rotationAxis == Direction.Axis.Y ? axis == Direction.Axis.X && !clockwise || axis == Direction.Axis.Z && clockwise : rotationAxis == Direction.Axis.Z && (axis == Direction.Axis.Y && !clockwise || axis == Direction.Axis.X && clockwise))) {
            return this.swapShafts(state);
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)AXIS);
        if (axis == Direction.Axis.X && mirror == Mirror.FRONT_BACK || axis == Direction.Axis.Z && mirror == Mirror.LEFT_RIGHT) {
            return this.swapShafts(state);
        }
        return state;
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        state = this.swapShaftsForRotation(state, rotation, Direction.Axis.Y);
        return super.m_6843_(state, rotation);
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        if (transform.mirror != null) {
            state = this.m_6943_(state, transform.mirror);
        }
        if (transform.rotationAxis == Direction.Axis.Y) {
            return this.m_6843_(state, transform.rotation);
        }
        state = this.swapShaftsForRotation(state, transform.rotation, transform.rotationAxis);
        state = (BlockState)state.m_61124_((Property)AXIS, (Comparable)transform.rotateAxis((Direction.Axis)state.m_61143_((Property)AXIS)));
        return state;
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity te) {
        return ItemRequirement.of(this.isLarge ? AllBlocks.LARGE_COGWHEEL.getDefaultState() : AllBlocks.COGWHEEL.getDefaultState(), te);
    }

    @Override
    public Class<SimpleKineticTileEntity> getTileEntityClass() {
        return SimpleKineticTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends SimpleKineticTileEntity> getTileEntityType() {
        return this.isLarge ? (BlockEntityType)AllTileEntities.ENCASED_LARGE_COGWHEEL.get() : (BlockEntityType)AllTileEntities.ENCASED_COGWHEEL.get();
    }

    @Override
    public Block getCasing() {
        return this.casing.get();
    }

    @Override
    public void handleEncasing(BlockState state, Level level, BlockPos pos, ItemStack heldItem, Player player, InteractionHand hand, BlockHitResult ray) {
        BlockState encasedState = (BlockState)this.m_49966_().m_61124_((Property)AXIS, (Comparable)((Direction.Axis)state.m_61143_((Property)AXIS)));
        for (Direction d : Iterate.directionsInAxis((Direction.Axis)state.m_61143_((Property)AXIS))) {
            IRotate def;
            BlockState adjacentState = level.m_8055_(pos.m_121945_(d));
            if (!(adjacentState.m_60734_() instanceof IRotate) || !(def = (IRotate)adjacentState.m_60734_()).hasShaftTowards((LevelReader)level, pos.m_121945_(d), adjacentState, d.m_122424_())) continue;
            encasedState = (BlockState)encasedState.m_61122_((Property)(d.m_122421_() == Direction.AxisDirection.POSITIVE ? TOP_SHAFT : BOTTOM_SHAFT));
        }
        KineticTileEntity.switchToBlockState(level, pos, encasedState);
    }
}

