/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CRecipes;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ChromaticCompoundItem
extends Item {
    public ChromaticCompoundItem(Item.Properties properties) {
        super(properties);
    }

    public int getLight(ItemStack stack) {
        return stack.m_41784_().m_128451_("CollectingLight");
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getLight(stack) > 0;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (float)this.getLight(stack) / (float)((Integer)AllConfigs.SERVER.recipes.lightSourceCountForRefinedRadiance.get()).intValue());
    }

    public int m_142159_(ItemStack stack) {
        return Color.mixColors(4275305, 0xFFFFFF, (float)this.getLight(stack) / (float)((Integer)AllConfigs.SERVER.recipes.lightSourceCountForRefinedRadiance.get()).intValue());
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.m_142522_(stack) ? 1 : 16;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        ItemStack newStack;
        Level world = entity.f_19853_;
        CompoundTag itemData = entity.m_32055_().m_41784_();
        Vec3 positionVec = entity.m_20182_();
        CRecipes config = AllConfigs.SERVER.recipes;
        if (world.f_46443_) {
            int light = itemData.m_128451_("CollectingLight");
            if (world.f_46441_.m_188503_((Integer)config.lightSourceCountForRefinedRadiance.get() + 20) < light) {
                Vec3 start = VecHelper.offsetRandomly(positionVec, world.f_46441_, 3.0f);
                Vec3 motion = positionVec.m_82546_(start).m_82541_().m_82490_((double)0.2f);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123810_, start.f_82479_, start.f_82480_, start.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
            }
            return false;
        }
        double y = entity.m_20186_();
        double yMotion = entity.m_20184_().f_82480_;
        int minHeight = world.m_141937_();
        CompoundTag data = entity.getPersistentData();
        if (y < (double)minHeight && y - yMotion < (double)(-10 + minHeight) && ((Boolean)config.enableShadowSteelRecipe.get()).booleanValue()) {
            newStack = AllItems.SHADOW_STEEL.asStack();
            newStack.m_41764_(stack.m_41613_());
            data.m_128379_("JustCreated", true);
            entity.m_32045_(newStack);
        }
        if (!((Boolean)config.enableRefinedRadianceRecipe.get()).booleanValue()) {
            return false;
        }
        if (itemData.m_128451_("CollectingLight") >= (Integer)config.lightSourceCountForRefinedRadiance.get()) {
            newStack = AllItems.REFINED_RADIANCE.asStack();
            ItemEntity newEntity = new ItemEntity(world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), newStack);
            newEntity.m_20256_(entity.m_20184_());
            newEntity.getPersistentData().m_128379_("JustCreated", true);
            itemData.m_128473_("CollectingLight");
            world.m_7967_((Entity)newEntity);
            stack.m_41620_(1);
            entity.m_32045_(stack);
            if (stack.m_41619_()) {
                entity.m_146870_();
            }
            return false;
        }
        boolean isOverBeacon = false;
        int entityX = Mth.m_14107_((double)entity.m_20185_());
        int entityZ = Mth.m_14107_((double)entity.m_20189_());
        int localWorldHeight = world.m_6924_(Heightmap.Types.WORLD_SURFACE, entityX, entityZ);
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos(entityX, Math.min(Mth.m_14107_((double)entity.m_20186_()), localWorldHeight), entityZ);
        while (testPos.m_123342_() > 0) {
            testPos.m_122173_(Direction.DOWN);
            BlockState state = world.m_8055_((BlockPos)testPos);
            if (state.m_60739_((BlockGetter)world, (BlockPos)testPos) >= 15 && state.m_60734_() != Blocks.f_50752_) break;
            if (state.m_60734_() != Blocks.f_50273_) continue;
            BlockEntity te = world.m_7702_((BlockPos)testPos);
            if (!(te instanceof BeaconBlockEntity)) break;
            BeaconBlockEntity bte = (BeaconBlockEntity)te;
            if (bte.f_58648_.isEmpty()) break;
            isOverBeacon = true;
            break;
        }
        if (isOverBeacon) {
            ItemStack newStack2 = AllItems.REFINED_RADIANCE.asStack();
            newStack2.m_41764_(stack.m_41613_());
            data.m_128379_("JustCreated", true);
            entity.m_32045_(newStack2);
            return false;
        }
        RandomSource r = world.f_46441_;
        int range = 3;
        float rate = 0.5f;
        if (r.m_188501_() > rate) {
            return false;
        }
        BlockPos randomOffset = new BlockPos(VecHelper.offsetRandomly(positionVec, r, range));
        BlockState state = world.m_8055_(randomOffset);
        TransportedItemStackHandlerBehaviour behaviour = TileEntityBehaviour.get((BlockGetter)world, randomOffset, TransportedItemStackHandlerBehaviour.TYPE);
        if (behaviour == null) {
            if (this.checkLight(stack, entity, world, itemData, positionVec, randomOffset, state)) {
                world.m_46961_(randomOffset, false);
            }
            return false;
        }
        MutableBoolean success = new MutableBoolean(false);
        behaviour.handleProcessingOnAllItems(ts -> {
            ItemStack heldStack = ts.stack;
            if (!(heldStack.m_41720_() instanceof BlockItem)) {
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            }
            BlockItem blockItem = (BlockItem)heldStack.m_41720_();
            if (blockItem.m_40614_() == null) {
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            }
            BlockState stateToCheck = blockItem.m_40614_().m_49966_();
            if (!success.getValue().booleanValue() && this.checkLight(stack, entity, world, itemData, positionVec, randomOffset, stateToCheck)) {
                success.setTrue();
                if (ts.stack.m_41613_() == 1) {
                    return TransportedItemStackHandlerBehaviour.TransportedResult.removeItem();
                }
                TransportedItemStack left = ts.copy();
                left.stack.m_41774_(1);
                return TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(left);
            }
            return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        });
        return false;
    }

    public boolean checkLight(ItemStack stack, ItemEntity entity, Level world, CompoundTag itemData, Vec3 positionVec, BlockPos randomOffset, BlockState state) {
        if (state.getLightEmission((BlockGetter)world, randomOffset) == 0) {
            return false;
        }
        if (state.m_60800_((BlockGetter)world, randomOffset) == -1.0f) {
            return false;
        }
        if (state.m_60734_() == Blocks.f_50273_) {
            return false;
        }
        ClipContext context = new ClipContext(positionVec.m_82549_(new Vec3(0.0, 0.5, 0.0)), VecHelper.getCenterOf((Vec3i)randomOffset), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        if (!randomOffset.equals((Object)world.m_45547_(context).m_82425_())) {
            return false;
        }
        ItemStack newStack = stack.m_41620_(1);
        newStack.m_41784_().m_128405_("CollectingLight", itemData.m_128451_("CollectingLight") + 1);
        ItemEntity newEntity = new ItemEntity(world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), newStack);
        newEntity.m_20256_(entity.m_20184_());
        newEntity.m_32060_();
        world.m_7967_((Entity)newEntity);
        entity.lifespan = 6000;
        if (stack.m_41619_()) {
            entity.m_146870_();
        }
        return true;
    }
}

