/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.curiosities.armor.CopperArmorItem;
import com.simibubi.create.content.curiosities.armor.CopperBacktankBlock;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Components;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class CopperBacktankArmorLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public static final IGuiOverlay REMAINING_AIR_OVERLAY = CopperBacktankArmorLayer::renderRemainingAirOverlay;

    public CopperBacktankArmorLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack ms, MultiBufferSource buffer, int light, LivingEntity entity, float yaw, float pitch, float pt, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        if (entity.m_20089_() == Pose.SLEEPING) {
            return;
        }
        if (!((CopperArmorItem)((Object)AllItems.COPPER_BACKTANK.get())).isWornBy((Entity)entity)) {
            return;
        }
        EntityModel entityModel = this.m_117386_();
        if (!(entityModel instanceof HumanoidModel)) {
            return;
        }
        HumanoidModel model = (HumanoidModel)entityModel;
        RenderType renderType = Sheets.m_110790_();
        BlockState renderedState = (BlockState)AllBlocks.COPPER_BACKTANK.getDefaultState().m_61124_(CopperBacktankBlock.HORIZONTAL_FACING, (Comparable)Direction.SOUTH);
        SuperByteBuffer backtank = CachedBufferer.block(renderedState);
        SuperByteBuffer cogs = CachedBufferer.partial(AllBlockPartials.COPPER_BACKTANK_COGS, renderedState);
        ms.m_85836_();
        model.f_102810_.m_104299_(ms);
        ms.m_252880_(-0.5f, 0.625f, 1.0f);
        ms.m_85841_(1.0f, -1.0f, -1.0f);
        backtank.forEntityRender().light(light).renderInto(ms, buffer.m_6299_(renderType));
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)cogs.centre()).rotateY(180.0)).unCentre()).translate(0.0, 0.40625, 0.6875).rotate(Direction.EAST, AngleHelper.rad(2.0f * AnimationTickHolder.getRenderTime((LevelAccessor)entity.f_19853_) % 360.0f))).translate(0.0, -0.40625, -0.6875);
        cogs.forEntityRender().light(light).renderInto(ms, buffer.m_6299_(renderType));
        ms.m_85849_();
    }

    public static void registerOnAll(EntityRenderDispatcher renderManager) {
        for (EntityRenderer renderer : renderManager.getSkinMap().values()) {
            CopperBacktankArmorLayer.registerOn(renderer);
        }
        for (EntityRenderer renderer : renderManager.f_114362_.values()) {
            CopperBacktankArmorLayer.registerOn(renderer);
        }
    }

    public static void registerOn(EntityRenderer<?> entityRenderer) {
        if (!(entityRenderer instanceof LivingEntityRenderer)) {
            return;
        }
        LivingEntityRenderer livingRenderer = (LivingEntityRenderer)entityRenderer;
        if (!(livingRenderer.m_7200_() instanceof HumanoidModel)) {
            return;
        }
        CopperBacktankArmorLayer layer = new CopperBacktankArmorLayer(livingRenderer);
        livingRenderer.m_115326_(layer);
    }

    public static void renderRemainingAirOverlay(ForgeGui gui, PoseStack poseStack, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_7500_()) {
            return;
        }
        if (!player.getPersistentData().m_128441_("VisualBacktankAir")) {
            return;
        }
        if (!player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get())) {
            return;
        }
        int timeLeft = player.getPersistentData().m_128451_("VisualBacktankAir");
        poseStack.m_85836_();
        poseStack.m_252880_((float)(width / 2 + 90), (float)(height - 53), 0.0f);
        MutableComponent text = Components.literal(StringUtil.m_14404_((int)(timeLeft * 20)));
        ((RenderElement)GuiGameElement.of(AllItems.COPPER_BACKTANK.asStack()).at(0.0f, 0.0f)).render(poseStack);
        int color = -1;
        if (timeLeft < 60 && timeLeft % 2 == 0) {
            color = Color.mixColors(-65536, color, Math.max((float)timeLeft / 60.0f, 0.25f));
        }
        Minecraft.m_91087_().f_91062_.m_92763_(poseStack, (Component)text, 16.0f, 5.0f, color);
        poseStack.m_85849_();
    }
}

