/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.bell;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.content.curiosities.bell.BasicParticleData;
import com.simibubi.create.content.curiosities.bell.CustomRotationParticle;
import com.simibubi.create.content.curiosities.bell.SoulPulseEffect;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;

public class SoulParticle
extends CustomRotationParticle {
    private final SpriteSet animatedSprite;
    protected int startTicks;
    protected int endTicks;
    protected int numLoops;
    protected int firstStartFrame = 0;
    protected int startFrames = 17;
    protected int firstLoopFrame = 17;
    protected int loopFrames = 16;
    protected int firstEndFrame = 33;
    protected int endFrames = 20;
    protected AnimationStage animationStage;
    protected int totalFrames = 53;
    protected int ticksPerFrame = 2;
    protected boolean isPerimeter = false;
    protected boolean isExpandingPerimeter = false;
    protected boolean isVisible = true;
    protected int perimeterFrames = 8;

    public SoulParticle(ClientLevel worldIn, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet, ParticleOptions data) {
        super(worldIn, x, y, z, spriteSet, 0.0f);
        this.animatedSprite = spriteSet;
        this.f_107663_ = 0.5f;
        this.m_107250_(this.f_107663_, this.f_107663_);
        this.loopLength = this.loopFrames + (int)(this.f_107223_.m_188501_() * 5.0f - 4.0f);
        this.startTicks = this.startFrames + (int)(this.f_107223_.m_188501_() * 5.0f - 4.0f);
        this.endTicks = this.endFrames + (int)(this.f_107223_.m_188501_() * 5.0f - 4.0f);
        this.numLoops = (int)(1.0f + this.f_107223_.m_188501_() * 2.0f);
        this.setFrame(0);
        this.f_107205_ = true;
        this.mirror = this.f_107223_.m_188499_();
        this.isPerimeter = data instanceof PerimeterData;
        this.isExpandingPerimeter = data instanceof ExpandingPerimeterData;
        AnimationStage animationStage = this.animationStage = !this.isPerimeter ? new StartAnimation(this) : new PerimeterAnimation(this);
        if (this.isPerimeter) {
            this.f_107210_ = y -= 0.4921875;
            this.totalFrames = this.perimeterFrames;
            this.isVisible = false;
        }
    }

    public void m_5989_() {
        this.animationStage.tick();
        this.animationStage = this.animationStage.getNext();
        BlockPos pos = new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_);
        if (this.animationStage == null) {
            this.m_107274_();
        }
        if (!SoulPulseEffect.isDark((Level)this.f_107208_, pos)) {
            this.isVisible = true;
            if (!this.isPerimeter) {
                this.m_107274_();
            }
        } else if (this.isPerimeter) {
            this.isVisible = false;
        }
    }

    @Override
    public void m_5744_(VertexConsumer builder, Camera camera, float partialTicks) {
        if (!this.isVisible) {
            return;
        }
        super.m_5744_(builder, camera, partialTicks);
    }

    public void setFrame(int frame) {
        if (frame >= 0 && frame < this.totalFrames) {
            this.m_108337_(this.animatedSprite.m_5819_(frame, this.totalFrames));
        }
    }

    @Override
    public Quaternionf getCustomRotation(Camera camera, float partialTicks) {
        if (this.isPerimeter) {
            return Axis.f_252529_.m_252977_(90.0f);
        }
        return new Quaternionf().rotationXYZ(0.0f, -camera.m_90590_() * ((float)Math.PI / 180), 0.0f);
    }

    public static class PerimeterData
    extends BasicParticleData<SoulParticle> {
        @Override
        public BasicParticleData.IBasicParticleFactory<SoulParticle> getBasicFactory() {
            return (worldIn, x, y, z, vx, vy, vz, spriteSet) -> new SoulParticle(worldIn, x, y, z, vx, vy, vz, spriteSet, this);
        }

        public ParticleType<?> m_6012_() {
            return AllParticleTypes.SOUL_PERIMETER.get();
        }
    }

    public static class ExpandingPerimeterData
    extends PerimeterData {
        @Override
        public ParticleType<?> m_6012_() {
            return AllParticleTypes.SOUL_EXPANDING_PERIMETER.get();
        }
    }

    public static class StartAnimation
    extends AnimationStage {
        public StartAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();
            this.particle.setFrame(this.particle.firstStartFrame + (int)(this.getAnimAge() / (float)this.particle.startTicks * (float)this.particle.startFrames));
        }

        @Override
        public AnimationStage getNext() {
            if (this.animAge < this.particle.startTicks) {
                return this;
            }
            return new LoopAnimation(this.particle);
        }
    }

    public static class PerimeterAnimation
    extends AnimationStage {
        public PerimeterAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();
            this.particle.setFrame((int)this.getAnimAge() % this.particle.perimeterFrames);
        }

        @Override
        public AnimationStage getNext() {
            if (this.animAge < (this.particle.isExpandingPerimeter ? 8 : this.particle.startTicks + this.particle.endTicks + this.particle.numLoops * this.particle.loopLength)) {
                return this;
            }
            return null;
        }
    }

    public static abstract class AnimationStage {
        protected final SoulParticle particle;
        protected int ticks;
        protected int animAge;

        public AnimationStage(SoulParticle particle) {
            this.particle = particle;
        }

        public void tick() {
            ++this.ticks;
            if (this.ticks % this.particle.ticksPerFrame == 0) {
                ++this.animAge;
            }
        }

        public float getAnimAge() {
            return this.animAge;
        }

        public abstract AnimationStage getNext();
    }

    public static class EndAnimation
    extends AnimationStage {
        public EndAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();
            this.particle.setFrame(this.particle.firstEndFrame + (int)(this.getAnimAge() / (float)this.particle.endTicks * (float)this.particle.endFrames));
        }

        @Override
        public AnimationStage getNext() {
            if (this.animAge < this.particle.endTicks) {
                return this;
            }
            return null;
        }
    }

    public static class LoopAnimation
    extends AnimationStage {
        int loops;

        public LoopAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();
            int loopTick = this.getLoopTick();
            if (loopTick == 0) {
                ++this.loops;
            }
            this.particle.setFrame(this.particle.firstLoopFrame + loopTick);
        }

        private int getLoopTick() {
            return this.animAge % this.particle.loopFrames;
        }

        @Override
        public AnimationStage getNext() {
            if (this.loops <= this.particle.numLoops) {
                return this;
            }
            return new EndAnimation(this.particle);
        }
    }

    public static class Data
    extends BasicParticleData<SoulParticle> {
        @Override
        public BasicParticleData.IBasicParticleFactory<SoulParticle> getBasicFactory() {
            return (worldIn, x, y, z, vx, vy, vz, spriteSet) -> new SoulParticle(worldIn, x, y, z, vx, vy, vz, spriteSet, this);
        }

        public ParticleType<?> m_6012_() {
            return AllParticleTypes.SOUL.get();
        }
    }
}

