/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.deco;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.curiosities.deco.PlacardBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class PlacardTileEntity
extends SmartTileEntity {
    ItemStack heldItem = ItemStack.f_41583_;
    int poweredTicks = 0;

    public PlacardTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.poweredTicks == 0) {
            return;
        }
        --this.poweredTicks;
        if (this.poweredTicks > 0) {
            return;
        }
        BlockState blockState = this.m_58900_();
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)blockState.m_61124_((Property)PlacardBlock.POWERED, (Comparable)Boolean.valueOf(false)), 3);
        PlacardBlock.updateNeighbours(blockState, this.f_58857_, this.f_58858_);
    }

    public ItemStack getHeldItem() {
        return this.heldItem;
    }

    public void setHeldItem(ItemStack heldItem) {
        this.heldItem = heldItem;
        this.notifyUpdate();
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        tag.m_128405_("PoweredTicks", this.poweredTicks);
        tag.m_128365_("Item", (Tag)this.heldItem.serializeNBT());
        super.write(tag, clientPacket);
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        int prevTicks = this.poweredTicks;
        this.poweredTicks = tag.m_128451_("PoweredTicks");
        this.heldItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
        super.read(tag, clientPacket);
        if (clientPacket && prevTicks < this.poweredTicks) {
            this.spawnParticles();
        }
    }

    private void spawnParticles() {
        BlockState blockState = this.m_58900_();
        if (!AllBlocks.PLACARD.has(blockState)) {
            return;
        }
        DustParticleOptions pParticleData = new DustParticleOptions(new Vector3f(1.0f, 0.2f, 0.0f), 1.0f);
        Vec3 centerOf = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        Vec3 normal = Vec3.m_82528_((Vec3i)PlacardBlock.connectedDirection(blockState).m_122436_());
        Vec3 offset = VecHelper.axisAlingedPlaneOf(normal);
        for (int i = 0; i < 10; ++i) {
            Vec3 v = VecHelper.offsetRandomly(Vec3.f_82478_, this.f_58857_.f_46441_, 0.5f).m_82559_(offset).m_82541_().m_82490_((double)0.45f).m_82549_(normal.m_82490_((double)-0.45f)).m_82549_(centerOf);
            this.f_58857_.m_7106_((ParticleOptions)pParticleData, v.f_82479_, v.f_82480_, v.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }
}

