/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.symmetry;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.curiosities.symmetry.SymmetryWandItem;
import com.simibubi.create.content.curiosities.symmetry.mirror.EmptyMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.SymmetryMirror;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SymmetryHandler {
    private static int tickCounter = 0;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        Inventory inv = player.m_150109_();
        for (int i = 0; i < Inventory.m_36059_(); ++i) {
            if (inv.m_8020_(i).m_41619_() || inv.m_8020_(i).m_41720_() != AllItems.WAND_OF_SYMMETRY.get()) continue;
            SymmetryWandItem.apply(player.f_19853_, inv.m_8020_(i), player, event.getPos(), event.getPlacedBlock());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockDestroyed(BlockEvent.BreakEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Player player = event.getPlayer();
        Inventory inv = player.m_150109_();
        for (int i = 0; i < Inventory.m_36059_(); ++i) {
            if (inv.m_8020_(i).m_41619_() || !AllItems.WAND_OF_SYMMETRY.isIn(inv.m_8020_(i))) continue;
            SymmetryWandItem.remove(player.f_19853_, inv.m_8020_(i), player, event.getPos());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void render(RenderLevelLastEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        RandomSource random = RandomSource.m_216327_();
        for (int i = 0; i < Inventory.m_36059_(); ++i) {
            SymmetryMirror mirror;
            ItemStack stackInSlot = player.m_150109_().m_8020_(i);
            if (!AllItems.WAND_OF_SYMMETRY.isIn(stackInSlot) || !SymmetryWandItem.isEnabled(stackInSlot) || (mirror = SymmetryWandItem.getMirror(stackInSlot)) instanceof EmptyMirror) continue;
            BlockPos pos = new BlockPos(mirror.getPosition());
            float yShift = 0.0f;
            double speed = 0.0625;
            yShift = Mth.m_14031_((float)((float)((double)AnimationTickHolder.getRenderTime() * speed))) / 5.0f;
            MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
            Camera info = mc.f_91063_.m_109153_();
            Vec3 view = info.m_90583_();
            PoseStack ms = event.getPoseStack();
            ms.m_85836_();
            ms.m_85837_(-view.m_7096_(), -view.m_7098_(), -view.m_7094_());
            ms.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            ms.m_252880_(0.0f, yShift + 0.2f, 0.0f);
            mirror.applyModelTransform(ms);
            BakedModel model = mirror.getModel().get();
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110451_());
            mc.m_91289_().m_110937_().tesselateBlock((BlockAndTintGetter)player.f_19853_, model, Blocks.f_50016_.m_49966_(), pos, ms, builder, true, random, Mth.m_14057_((Vec3i)pos), OverlayTexture.f_118083_, ModelData.EMPTY, RenderType.m_110451_());
            ms.m_85849_();
            buffer.m_109911_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (mc.f_91073_ == null) {
            return;
        }
        if (mc.m_91104_()) {
            return;
        }
        if (++tickCounter % 10 == 0) {
            for (int i = 0; i < Inventory.m_36059_(); ++i) {
                SymmetryMirror mirror;
                ItemStack stackInSlot = player.m_150109_().m_8020_(i);
                if (stackInSlot == null || !AllItems.WAND_OF_SYMMETRY.isIn(stackInSlot) || !SymmetryWandItem.isEnabled(stackInSlot) || (mirror = SymmetryWandItem.getMirror(stackInSlot)) instanceof EmptyMirror) continue;
                Random r = new Random();
                double offsetX = (r.nextDouble() - 0.5) * 0.3;
                double offsetZ = (r.nextDouble() - 0.5) * 0.3;
                Vec3 pos = mirror.getPosition().m_82520_(0.5 + offsetX, 0.25, 0.5 + offsetZ);
                Vec3 speed = new Vec3(0.0, r.nextDouble() * 1.0 / 8.0, 0.0);
                mc.f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, pos.f_82479_, pos.f_82480_, pos.f_82481_, speed.f_82479_, speed.f_82480_, speed.f_82481_);
            }
        }
    }

    public static void drawEffect(BlockPos from, BlockPos to) {
        Vec3 pos;
        double density = 0.8f;
        Vec3 start = Vec3.m_82528_((Vec3i)from).m_82520_(0.5, 0.5, 0.5);
        Vec3 end = Vec3.m_82528_((Vec3i)to).m_82520_(0.5, 0.5, 0.5);
        Vec3 diff = end.m_82546_(start);
        Vec3 step = diff.m_82541_().m_82490_(density);
        int steps = (int)(diff.m_82553_() / step.m_82553_());
        Random r = new Random();
        for (int i = 3; i < steps - 1; ++i) {
            pos = start.m_82549_(step.m_82490_((double)i));
            Vec3 speed = new Vec3(0.0, r.nextDouble() * -40.0, 0.0);
            Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f), pos.f_82479_, pos.f_82480_, pos.f_82481_, speed.f_82479_, speed.f_82480_, speed.f_82481_);
        }
        Vec3 speed = new Vec3(0.0, r.nextDouble() * 1.0 / 32.0, 0.0);
        pos = start.m_82549_(step.m_82490_(2.0));
        Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, pos.f_82479_, pos.f_82480_, pos.f_82481_, speed.f_82479_, speed.f_82480_, speed.f_82481_);
        speed = new Vec3(0.0, r.nextDouble() * 1.0 / 32.0, 0.0);
        pos = start.m_82549_(step.m_82490_((double)steps));
        Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, pos.f_82479_, pos.f_82480_, pos.f_82481_, speed.f_82479_, speed.f_82480_, speed.f_82481_);
    }
}

