/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.toolbox;

import com.simibubi.create.content.curiosities.toolbox.ItemReturnInvWrapper;
import com.simibubi.create.content.curiosities.toolbox.ToolboxHandler;
import com.simibubi.create.content.curiosities.toolbox.ToolboxInventory;
import com.simibubi.create.content.curiosities.toolbox.ToolboxTileEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkEvent;

public class ToolboxEquipPacket
extends SimplePacketBase {
    private BlockPos toolboxPos;
    private int slot;
    private int hotbarSlot;

    public ToolboxEquipPacket(BlockPos toolboxPos, int slot, int hotbarSlot) {
        this.toolboxPos = toolboxPos;
        this.slot = slot;
        this.hotbarSlot = hotbarSlot;
    }

    public ToolboxEquipPacket(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            this.toolboxPos = buffer.m_130135_();
        }
        this.slot = buffer.m_130242_();
        this.hotbarSlot = buffer.m_130242_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.toolboxPos != null);
        if (this.toolboxPos != null) {
            buffer.m_130064_(this.toolboxPos);
        }
        buffer.m_130130_(this.slot);
        buffer.m_130130_(this.hotbarSlot);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            Level world = player.f_19853_;
            if (this.toolboxPos == null) {
                ToolboxHandler.unequip((Player)player, this.hotbarSlot, false);
                ToolboxHandler.syncData((Player)player);
                return;
            }
            BlockEntity blockEntity = world.m_7702_(this.toolboxPos);
            double maxRange = ToolboxHandler.getMaxRange((Player)player);
            if (player.m_20275_((double)this.toolboxPos.m_123341_() + 0.5, (double)this.toolboxPos.m_123342_(), (double)this.toolboxPos.m_123343_() + 0.5) > maxRange * maxRange) {
                return;
            }
            if (!(blockEntity instanceof ToolboxTileEntity)) {
                return;
            }
            ToolboxHandler.unequip((Player)player, this.hotbarSlot, false);
            if (this.slot < 0 || this.slot >= 8) {
                ToolboxHandler.syncData((Player)player);
                return;
            }
            ToolboxTileEntity toolboxTileEntity = (ToolboxTileEntity)blockEntity;
            ItemStack playerStack = player.m_150109_().m_8020_(this.hotbarSlot);
            if (!playerStack.m_41619_() && !ToolboxInventory.canItemsShareCompartment(playerStack, toolboxTileEntity.inventory.filters.get(this.slot))) {
                toolboxTileEntity.inventory.inLimitedMode(inventory -> {
                    ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)playerStack, (boolean)false);
                    if (!remainder.m_41619_()) {
                        remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)new ItemReturnInvWrapper(player.m_150109_()), (ItemStack)remainder, (boolean)false);
                    }
                    if (remainder.m_41613_() != playerStack.m_41613_()) {
                        player.m_150109_().m_6836_(this.hotbarSlot, remainder);
                    }
                });
            }
            CompoundTag compound = player.getPersistentData().m_128469_("CreateToolboxData");
            String key = String.valueOf(this.hotbarSlot);
            CompoundTag data = new CompoundTag();
            data.m_128405_("Slot", this.slot);
            data.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)this.toolboxPos));
            compound.m_128365_(key, (Tag)data);
            player.getPersistentData().m_128365_("CreateToolboxData", (Tag)compound);
            toolboxTileEntity.connectPlayer(this.slot, (Player)player, this.hotbarSlot);
            ToolboxHandler.syncData((Player)player);
        });
        ctx.setPacketHandled(true);
    }
}

