/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public abstract class ShootableGadgetRenderHandler {
    protected float leftHandAnimation;
    protected float rightHandAnimation;
    protected float lastLeftHandAnimation;
    protected float lastRightHandAnimation;
    protected boolean dontReequipLeft;
    protected boolean dontReequipRight;

    public void tick() {
        this.lastLeftHandAnimation = this.leftHandAnimation;
        this.lastRightHandAnimation = this.rightHandAnimation;
        this.leftHandAnimation *= this.animationDecay();
        this.rightHandAnimation *= this.animationDecay();
    }

    public float getAnimation(boolean rightHand, float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)(rightHand ? this.lastRightHandAnimation : this.lastLeftHandAnimation), (float)(rightHand ? this.rightHandAnimation : this.leftHandAnimation));
    }

    protected float animationDecay() {
        return 0.8f;
    }

    public void shoot(InteractionHand hand, Vec3 location) {
        LocalPlayer player;
        boolean rightHand = hand == InteractionHand.MAIN_HAND ^ (player = Minecraft.m_91087_().f_91074_).m_5737_() == HumanoidArm.LEFT;
        if (rightHand) {
            this.rightHandAnimation = 0.2f;
            this.dontReequipRight = false;
        } else {
            this.leftHandAnimation = 0.2f;
            this.dontReequipLeft = false;
        }
        this.playSound(hand, location);
    }

    protected abstract void playSound(InteractionHand var1, Vec3 var2);

    protected abstract boolean appliesTo(ItemStack var1);

    protected abstract void transformTool(PoseStack var1, float var2, float var3, float var4, float var5);

    protected abstract void transformHand(PoseStack var1, float var2, float var3, float var4, float var5);

    public void registerListeners(IEventBus bus) {
        bus.addListener(this::onRenderPlayerHand);
    }

    protected void onRenderPlayerHand(RenderHandEvent event) {
        ItemStack heldItem = event.getItemStack();
        if (!this.appliesTo(heldItem)) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        PlayerRenderer playerrenderer = (PlayerRenderer)mc.m_91290_().m_114382_((Entity)player);
        ItemInHandRenderer firstPersonRenderer = mc.m_91290_().m_234586_();
        PoseStack ms = event.getPoseStack();
        MultiBufferSource buffer = event.getMultiBufferSource();
        int light = event.getPackedLight();
        float pt = event.getPartialTick();
        boolean rightHand = event.getHand() == InteractionHand.MAIN_HAND ^ mc.f_91074_.m_5737_() == HumanoidArm.LEFT;
        float recoil = rightHand ? Mth.m_14179_((float)pt, (float)this.lastRightHandAnimation, (float)this.rightHandAnimation) : Mth.m_14179_((float)pt, (float)this.lastLeftHandAnimation, (float)this.leftHandAnimation);
        float equipProgress = event.getEquipProgress();
        if (rightHand && (this.rightHandAnimation > 0.01f || this.dontReequipRight)) {
            equipProgress = 0.0f;
        }
        if (!rightHand && (this.leftHandAnimation > 0.01f || this.dontReequipLeft)) {
            equipProgress = 0.0f;
        }
        ms.m_85836_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)player.m_108560_());
        float flip = rightHand ? 1.0f : -1.0f;
        float f1 = Mth.m_14116_((float)event.getSwingProgress());
        float f2 = -0.3f * Mth.m_14031_((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * Mth.m_14031_((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * Mth.m_14031_((float)(event.getSwingProgress() * (float)Math.PI));
        float f5 = Mth.m_14031_((float)(event.getSwingProgress() * event.getSwingProgress() * (float)Math.PI));
        float f6 = Mth.m_14031_((float)(f1 * (float)Math.PI));
        ms.m_252880_(flip * (f2 + 0.64f - 0.1f), f3 + -0.4f + equipProgress * -0.6f, f4 + -0.72f + 0.3f + recoil);
        ms.m_252781_(Axis.f_252436_.m_252977_(flip * 75.0f));
        ms.m_252781_(Axis.f_252436_.m_252977_(flip * f6 * 70.0f));
        ms.m_252781_(Axis.f_252403_.m_252977_(flip * f5 * -20.0f));
        ms.m_252880_(flip * -1.0f, 3.6f, 3.5f);
        ms.m_252781_(Axis.f_252403_.m_252977_(flip * 120.0f));
        ms.m_252781_(Axis.f_252529_.m_252977_(200.0f));
        ms.m_252781_(Axis.f_252436_.m_252977_(flip * -135.0f));
        ms.m_252880_(flip * 5.6f, 0.0f, 0.0f);
        ms.m_252781_(Axis.f_252436_.m_252977_(flip * 40.0f));
        this.transformHand(ms, flip, equipProgress, recoil, pt);
        if (rightHand) {
            playerrenderer.m_117770_(ms, buffer, light, (AbstractClientPlayer)player);
        } else {
            playerrenderer.m_117813_(ms, buffer, light, (AbstractClientPlayer)player);
        }
        ms.m_85849_();
        ms.m_85836_();
        ms.m_252880_(flip * (f2 + 0.64f - 0.1f), f3 + -0.4f + equipProgress * -0.6f, f4 + -0.72f - 0.1f + recoil);
        ms.m_252781_(Axis.f_252436_.m_252977_(flip * f6 * 70.0f));
        ms.m_252781_(Axis.f_252403_.m_252977_(flip * f5 * -20.0f));
        this.transformTool(ms, flip, equipProgress, recoil, pt);
        firstPersonRenderer.m_109322_((LivingEntity)mc.f_91074_, heldItem, rightHand ? ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !rightHand, ms, buffer, light);
        ms.m_85849_();
        event.setCanceled(true);
    }

    public void dontAnimateItem(InteractionHand hand) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean rightHand = hand == InteractionHand.MAIN_HAND ^ player.m_5737_() == HumanoidArm.LEFT;
        this.dontReequipRight |= rightHand;
        this.dontReequipLeft |= !rightHand;
    }
}

