/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.depot.DepotItemHandler;
import com.simibubi.create.content.logistics.block.funnel.AbstractFunnelBlock;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.BeltProcessingBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class DepotBehaviour
extends TileEntityBehaviour {
    public static final BehaviourType<DepotBehaviour> TYPE = new BehaviourType();
    TransportedItemStack heldItem;
    List<TransportedItemStack> incoming;
    ItemStackHandler processingOutputBuffer;
    DepotItemHandler itemHandler;
    LazyOptional<DepotItemHandler> lazyItemHandler;
    TransportedItemStackHandlerBehaviour transportedHandler;
    Supplier<Integer> maxStackSize = () -> 64;
    Supplier<Boolean> canAcceptItems = () -> true;
    Predicate<Direction> canFunnelsPullFrom = $ -> true;
    Consumer<ItemStack> onHeldInserted;
    Predicate<ItemStack> acceptedItems = $ -> true;
    boolean allowMerge;

    public DepotBehaviour(final SmartTileEntity te) {
        super(te);
        this.onHeldInserted = $ -> {};
        this.incoming = new ArrayList<TransportedItemStack>();
        this.itemHandler = new DepotItemHandler(this);
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.processingOutputBuffer = new ItemStackHandler(8){

            protected void onContentsChanged(int slot) {
                te.notifyUpdate();
            }
        };
    }

    public void enableMerging() {
        this.allowMerge = true;
    }

    public DepotBehaviour withCallback(Consumer<ItemStack> changeListener) {
        this.onHeldInserted = changeListener;
        return this;
    }

    public DepotBehaviour onlyAccepts(Predicate<ItemStack> filter) {
        this.acceptedItems = filter;
        return this;
    }

    @Override
    public void tick() {
        BeltProcessingBehaviour.ProcessingResult result;
        super.tick();
        Level world = this.tileEntity.m_58904_();
        Iterator<TransportedItemStack> iterator = this.incoming.iterator();
        while (iterator.hasNext()) {
            TransportedItemStack ts = iterator.next();
            if (!this.tick(ts) || world.f_46443_ && !this.tileEntity.isVirtual()) continue;
            if (this.heldItem == null) {
                this.heldItem = ts;
            } else if (!ItemHelper.canItemStackAmountsStack(this.heldItem.stack, ts.stack)) {
                Vec3 vec = VecHelper.getCenterOf((Vec3i)this.tileEntity.m_58899_());
                Containers.m_18992_((Level)this.tileEntity.m_58904_(), (double)vec.f_82479_, (double)(vec.f_82480_ + 0.5), (double)vec.f_82481_, (ItemStack)ts.stack);
            } else {
                this.heldItem.stack.m_41769_(ts.stack.m_41613_());
            }
            iterator.remove();
            this.tileEntity.notifyUpdate();
        }
        if (this.heldItem == null) {
            return;
        }
        if (!this.tick(this.heldItem)) {
            return;
        }
        BlockPos pos = this.tileEntity.m_58899_();
        if (world.f_46443_) {
            return;
        }
        if (this.handleBeltFunnelOutput()) {
            return;
        }
        BeltProcessingBehaviour processingBehaviour = TileEntityBehaviour.get((BlockGetter)world, pos.m_6630_(2), BeltProcessingBehaviour.TYPE);
        if (processingBehaviour == null) {
            return;
        }
        if (!this.heldItem.locked && BeltProcessingBehaviour.isBlocked((BlockGetter)world, pos)) {
            return;
        }
        ItemStack previousItem = this.heldItem.stack;
        boolean wasLocked = this.heldItem.locked;
        BeltProcessingBehaviour.ProcessingResult processingResult = result = wasLocked ? processingBehaviour.handleHeldItem(this.heldItem, this.transportedHandler) : processingBehaviour.handleReceivedItem(this.heldItem, this.transportedHandler);
        if (result == BeltProcessingBehaviour.ProcessingResult.REMOVE) {
            this.heldItem = null;
            this.tileEntity.sendData();
            return;
        }
        boolean bl = this.heldItem.locked = result == BeltProcessingBehaviour.ProcessingResult.HOLD;
        if (this.heldItem.locked != wasLocked || !previousItem.equals(this.heldItem.stack, false)) {
            this.tileEntity.sendData();
        }
    }

    protected boolean tick(TransportedItemStack heldItem) {
        heldItem.prevBeltPosition = heldItem.beltPosition;
        heldItem.prevSideOffset = heldItem.sideOffset;
        float diff = 0.5f - heldItem.beltPosition;
        if (diff > 0.001953125f) {
            if (diff > 0.03125f && !BeltHelper.isItemUpright(heldItem.stack)) {
                ++heldItem.angle;
            }
            heldItem.beltPosition += diff / 4.0f;
        }
        return diff < 0.0625f;
    }

    private boolean handleBeltFunnelOutput() {
        BlockState funnel = this.getWorld().m_8055_(this.getPos().m_7494_());
        Direction funnelFacing = AbstractFunnelBlock.getFunnelFacing(funnel);
        if (funnelFacing == null || !this.canFunnelsPullFrom.test(funnelFacing.m_122424_())) {
            return false;
        }
        for (int slot = 0; slot < this.processingOutputBuffer.getSlots(); ++slot) {
            ItemStack previousItem = this.processingOutputBuffer.getStackInSlot(slot);
            if (previousItem.m_41619_()) continue;
            ItemStack afterInsert = this.tileEntity.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(previousItem, null, false);
            if (afterInsert == null) {
                return false;
            }
            if (previousItem.m_41613_() == afterInsert.m_41613_()) continue;
            this.processingOutputBuffer.setStackInSlot(slot, afterInsert);
            this.tileEntity.notifyUpdate();
            return true;
        }
        ItemStack previousItem = this.heldItem.stack;
        ItemStack afterInsert = this.tileEntity.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(previousItem, null, false);
        if (afterInsert == null) {
            return false;
        }
        if (previousItem.m_41613_() != afterInsert.m_41613_()) {
            if (afterInsert.m_41619_()) {
                this.heldItem = null;
            } else {
                this.heldItem.stack = afterInsert;
            }
            this.tileEntity.notifyUpdate();
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        super.destroy();
        Level level = this.getWorld();
        BlockPos pos = this.getPos();
        ItemHelper.dropContents(level, pos, (IItemHandler)this.processingOutputBuffer);
        for (TransportedItemStack transportedItemStack : this.incoming) {
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)transportedItemStack.stack);
        }
        if (!this.getHeldItemStack().m_41619_()) {
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)this.getHeldItemStack());
        }
    }

    @Override
    public void unload() {
        if (this.lazyItemHandler != null) {
            this.lazyItemHandler.invalidate();
        }
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        if (this.heldItem != null) {
            compound.m_128365_("HeldItem", (Tag)this.heldItem.serializeNBT());
        }
        compound.m_128365_("OutputBuffer", (Tag)this.processingOutputBuffer.serializeNBT());
        if (this.canMergeItems() && !this.incoming.isEmpty()) {
            compound.m_128365_("Incoming", (Tag)NBTHelper.writeCompoundList(this.incoming, TransportedItemStack::serializeNBT));
        }
    }

    @Override
    public void read(CompoundTag compound, boolean clientPacket) {
        this.heldItem = null;
        if (compound.m_128441_("HeldItem")) {
            this.heldItem = TransportedItemStack.read(compound.m_128469_("HeldItem"));
        }
        this.processingOutputBuffer.deserializeNBT(compound.m_128469_("OutputBuffer"));
        if (this.canMergeItems()) {
            ListTag list = compound.m_128437_("Incoming", 10);
            this.incoming = NBTHelper.readCompoundList(list, TransportedItemStack::read);
        }
    }

    public void addSubBehaviours(List<TileEntityBehaviour> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this.tileEntity).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide));
        this.transportedHandler = new TransportedItemStackHandlerBehaviour(this.tileEntity, this::applyToAllItems).withStackPlacement(this::getWorldPositionOf);
        behaviours.add(this.transportedHandler);
    }

    public ItemStack getHeldItemStack() {
        return this.heldItem == null ? ItemStack.f_41583_ : this.heldItem.stack;
    }

    public boolean canMergeItems() {
        return this.allowMerge;
    }

    public int getPresentStackSize() {
        int cumulativeStackSize = 0;
        cumulativeStackSize += this.getHeldItemStack().m_41613_();
        for (int slot = 0; slot < this.processingOutputBuffer.getSlots(); ++slot) {
            cumulativeStackSize += this.processingOutputBuffer.getStackInSlot(slot).m_41613_();
        }
        return cumulativeStackSize;
    }

    public int getRemainingSpace() {
        int cumulativeStackSize = this.getPresentStackSize();
        for (TransportedItemStack transportedItemStack : this.incoming) {
            cumulativeStackSize += transportedItemStack.stack.m_41613_();
        }
        int fromGetter = this.maxStackSize.get();
        return (fromGetter == 0 ? 64 : fromGetter) - cumulativeStackSize;
    }

    public ItemStack insert(TransportedItemStack heldItem, boolean simulate) {
        if (!this.canAcceptItems.get().booleanValue()) {
            return heldItem.stack;
        }
        if (!this.acceptedItems.test(heldItem.stack)) {
            return heldItem.stack;
        }
        if (this.canMergeItems()) {
            int remainingSpace = this.getRemainingSpace();
            ItemStack inserted = heldItem.stack;
            if (remainingSpace <= 0) {
                return inserted;
            }
            if (this.heldItem != null && !ItemHelper.canItemStackAmountsStack(this.heldItem.stack, inserted)) {
                return inserted;
            }
            ItemStack returned = ItemStack.f_41583_;
            if (remainingSpace < inserted.m_41613_()) {
                returned = ItemHandlerHelper.copyStackWithSize((ItemStack)heldItem.stack, (int)(inserted.m_41613_() - remainingSpace));
                if (!simulate) {
                    TransportedItemStack copy = heldItem.copy();
                    copy.stack.m_41764_(remainingSpace);
                    if (this.heldItem != null) {
                        this.incoming.add(copy);
                    } else {
                        this.heldItem = copy;
                    }
                }
            } else if (!simulate) {
                if (this.heldItem != null) {
                    this.incoming.add(heldItem);
                } else {
                    this.heldItem = heldItem;
                }
            }
            return returned;
        }
        if (!simulate) {
            if (this.isEmpty()) {
                if (heldItem.insertedFrom.m_122434_().m_122479_()) {
                    AllSoundEvents.DEPOT_SLIDE.playOnServer(this.getWorld(), (Vec3i)this.getPos());
                } else {
                    AllSoundEvents.DEPOT_PLOP.playOnServer(this.getWorld(), (Vec3i)this.getPos());
                }
            }
            this.heldItem = heldItem;
            this.onHeldInserted.accept(heldItem.stack);
        }
        return ItemStack.f_41583_;
    }

    public void setHeldItem(TransportedItemStack heldItem) {
        this.heldItem = heldItem;
    }

    public void removeHeldItem() {
        this.heldItem = null;
    }

    public void setCenteredHeldItem(TransportedItemStack heldItem) {
        this.heldItem = heldItem;
        this.heldItem.beltPosition = 0.5f;
        this.heldItem.prevBeltPosition = 0.5f;
    }

    public <T> LazyOptional<T> getItemCapability(Capability<T> cap, Direction side) {
        return this.lazyItemHandler.cast();
    }

    private ItemStack tryInsertingFromSide(TransportedItemStack transportedStack, Direction side, boolean simulate) {
        ItemStack inserted = transportedStack.stack;
        if (!this.getHeldItemStack().m_41619_() && !this.canMergeItems()) {
            return inserted;
        }
        if (!this.isOutputEmpty() && !this.canMergeItems()) {
            return inserted;
        }
        if (!this.canAcceptItems.get().booleanValue()) {
            return inserted;
        }
        int size = transportedStack.stack.m_41613_();
        transportedStack = transportedStack.copy();
        transportedStack.beltPosition = side.m_122434_().m_122478_() ? 0.5f : 0.0f;
        transportedStack.insertedFrom = side;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        ItemStack remainder = this.insert(transportedStack, simulate);
        if (remainder.m_41613_() != size) {
            this.tileEntity.notifyUpdate();
        }
        return remainder;
    }

    private void applyToAllItems(float maxDistanceFromCentre, Function<TransportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult> processFunction) {
        if (this.heldItem == null) {
            return;
        }
        if (0.5f - this.heldItem.beltPosition > maxDistanceFromCentre) {
            return;
        }
        boolean dirty = false;
        TransportedItemStack transportedItemStack = this.heldItem;
        ItemStack stackBefore = transportedItemStack.stack.m_41777_();
        TransportedItemStackHandlerBehaviour.TransportedResult result = processFunction.apply(transportedItemStack);
        if (result == null || result.didntChangeFrom(stackBefore)) {
            return;
        }
        dirty = true;
        this.heldItem = null;
        if (result.hasHeldOutput()) {
            this.setCenteredHeldItem(result.getHeldOutput());
        }
        for (TransportedItemStack added : result.getOutputs()) {
            if (this.getHeldItemStack().m_41619_()) {
                this.setCenteredHeldItem(added);
                continue;
            }
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)this.processingOutputBuffer, (ItemStack)added.stack, (boolean)false);
            Vec3 vec = VecHelper.getCenterOf((Vec3i)this.tileEntity.m_58899_());
            Containers.m_18992_((Level)this.tileEntity.m_58904_(), (double)vec.f_82479_, (double)(vec.f_82480_ + 0.5), (double)vec.f_82481_, (ItemStack)remainder);
        }
        if (dirty) {
            this.tileEntity.notifyUpdate();
        }
    }

    public boolean isEmpty() {
        return this.heldItem == null && this.isOutputEmpty();
    }

    public boolean isOutputEmpty() {
        for (int i = 0; i < this.processingOutputBuffer.getSlots(); ++i) {
            if (this.processingOutputBuffer.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private Vec3 getWorldPositionOf(TransportedItemStack transported) {
        return VecHelper.getCenterOf((Vec3i)this.tileEntity.m_58899_());
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public boolean isItemValid(ItemStack stack) {
        return this.acceptedItems.test(stack);
    }
}

