/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelItem;
import com.simibubi.create.foundation.data.SpecialBlockStateGen;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class FunnelGenerator
extends SpecialBlockStateGen {
    private String type;
    private ResourceLocation particleTexture;
    private boolean hasFilter;

    public FunnelGenerator(String type, boolean hasFilter) {
        this.type = type;
        this.hasFilter = hasFilter;
        this.particleTexture = Create.asResource("block/" + type + "_casing");
    }

    @Override
    protected int getXRotation(BlockState state) {
        return state.m_61143_((Property)FunnelBlock.FACING) == Direction.DOWN ? 180 : 0;
    }

    @Override
    protected int getYRotation(BlockState state) {
        return this.horizontalAngle((Direction)state.m_61143_((Property)FunnelBlock.FACING)) + 180;
    }

    @Override
    public <T extends Block> ModelFile getModel(DataGenContext<Block, T> c, RegistrateBlockstateProvider p, BlockState s) {
        String powered = (Boolean)s.m_61143_((Property)FunnelBlock.POWERED) != false ? "_powered" : "";
        String closed = (Boolean)s.m_61143_((Property)FunnelBlock.POWERED) != false ? "_closed" : "_open";
        String extracting = (Boolean)s.m_61143_((Property)FunnelBlock.EXTRACTING) != false ? "_push" : "_pull";
        Direction facing = (Direction)s.m_61143_((Property)FunnelBlock.FACING);
        boolean horizontal = facing.m_122434_().m_122479_();
        String parent = horizontal ? "horizontal" : (this.hasFilter ? "vertical" : "vertical_filterless");
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent("block/" + this.type + "_funnel_" + parent + extracting + powered, p.modLoc("block/funnel/block_" + parent))).texture("particle", this.particleTexture)).texture("7", p.modLoc("block/" + this.type + "_funnel_plating"))).texture("5", p.modLoc("block/" + this.type + "_funnel_tall" + powered))).texture("2_2", p.modLoc("block/" + this.type + "_funnel" + extracting))).texture("3", p.modLoc("block/" + this.type + "_funnel_back"));
        if (horizontal) {
            return model.texture("6", p.modLoc("block/" + this.type + "_funnel" + powered));
        }
        return ((BlockModelBuilder)((BlockModelBuilder)model.texture("8", this.particleTexture)).texture("9", p.modLoc("block/" + this.type + "_funnel_slope"))).texture("10", p.modLoc("block/funnel" + closed));
    }

    public static NonNullBiConsumer<DataGenContext<Item, FunnelItem>, RegistrateItemModelProvider> itemModel(String type) {
        ResourceLocation particleTexture = Create.asResource("block/" + type + "_casing");
        return (c, p) -> ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.withExistingParent("item/" + type + "_funnel", p.modLoc("block/funnel/item"))).texture("particle", particleTexture)).texture("7", p.modLoc("block/" + type + "_funnel_plating"))).texture("2", p.modLoc("block/" + type + "_funnel_neutral"))).texture("6", p.modLoc("block/" + type + "_funnel"))).texture("5", p.modLoc("block/" + type + "_funnel_tall"))).texture("3", p.modLoc("block/" + type + "_funnel_back"));
    }
}

