/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.mechanicalArm;

import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPointHandler;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmTileEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ArmPlacementPacket
extends SimplePacketBase {
    private Collection<ArmInteractionPoint> points;
    private ListTag receivedTag;
    private BlockPos pos;

    public ArmPlacementPacket(Collection<ArmInteractionPoint> points, BlockPos pos) {
        this.points = points;
        this.pos = pos;
    }

    public ArmPlacementPacket(FriendlyByteBuf buffer) {
        CompoundTag nbt = buffer.m_130260_();
        this.receivedTag = nbt.m_128437_("Points", 10);
        this.pos = buffer.m_130135_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        CompoundTag nbt = new CompoundTag();
        ListTag pointsNBT = new ListTag();
        this.points.stream().map(aip -> aip.serialize(this.pos)).forEach(arg_0 -> pointsNBT.add(arg_0));
        nbt.m_128365_("Points", (Tag)pointsNBT);
        buffer.m_130079_(nbt);
        buffer.m_130064_(this.pos);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            Level world = player.f_19853_;
            if (world == null || !world.m_46749_(this.pos)) {
                return;
            }
            BlockEntity tileEntity = world.m_7702_(this.pos);
            if (!(tileEntity instanceof ArmTileEntity)) {
                return;
            }
            ArmTileEntity arm = (ArmTileEntity)tileEntity;
            arm.interactionPointTag = this.receivedTag;
        });
        context.get().setPacketHandled(true);
    }

    public static class ClientBoundRequest
    extends SimplePacketBase {
        BlockPos pos;

        public ClientBoundRequest(BlockPos pos) {
            this.pos = pos;
        }

        public ClientBoundRequest(FriendlyByteBuf buffer) {
            this.pos = buffer.m_130135_();
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130064_(this.pos);
        }

        @Override
        public void handle(Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ArmInteractionPointHandler.flushSettings(this.pos)));
            context.get().setPacketHandled(true);
        }
    }
}

