/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.TrackTargetingBehaviour;
import com.simibubi.create.content.logistics.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.logistics.trains.track.TrackBlock;
import com.simibubi.create.content.logistics.trains.track.TrackShape;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface ITrackBlock {
    public Vec3 getUpNormal(BlockGetter var1, BlockPos var2, BlockState var3);

    public List<Vec3> getTrackAxes(BlockGetter var1, BlockPos var2, BlockState var3);

    public Vec3 getCurveStart(BlockGetter var1, BlockPos var2, BlockState var3, Vec3 var4);

    public BlockState getBogeyAnchor(BlockGetter var1, BlockPos var2, BlockState var3);

    public boolean trackEquals(BlockState var1, BlockState var2);

    default public BlockState overlay(BlockGetter world, BlockPos pos, BlockState existing, BlockState placed) {
        return existing;
    }

    default public double getElevationAtCenter(BlockGetter world, BlockPos pos, BlockState state) {
        return this.isSlope(world, pos, state) ? 0.5 : 0.0;
    }

    public static Collection<TrackNodeLocation.DiscoveredLocation> walkConnectedTracks(BlockGetter worldIn, TrackNodeLocation location, boolean linear) {
        BlockGetter blockGetter;
        if (location != null && worldIn instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)worldIn;
            blockGetter = sl.m_7654_().m_129880_(location.dimension);
        } else {
            blockGetter = worldIn;
        }
        BlockGetter world = blockGetter;
        ArrayList<TrackNodeLocation.DiscoveredLocation> list = new ArrayList<TrackNodeLocation.DiscoveredLocation>();
        for (BlockPos blockPos : location.allAdjacent()) {
            BlockState blockState = world.m_8055_(blockPos);
            Block block = blockState.m_60734_();
            if (!(block instanceof ITrackBlock)) continue;
            ITrackBlock track = (ITrackBlock)block;
            list.addAll(track.getConnected(world, blockPos, blockState, linear, location));
        }
        return list;
    }

    default public Collection<TrackNodeLocation.DiscoveredLocation> getConnected(BlockGetter worldIn, BlockPos pos, BlockState state, boolean linear, @Nullable TrackNodeLocation connectedTo) {
        BlockGetter blockGetter;
        if (connectedTo != null && worldIn instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)worldIn;
            blockGetter = sl.m_7654_().m_129880_(connectedTo.dimension);
        } else {
            blockGetter = worldIn;
        }
        BlockGetter world = blockGetter;
        Vec3 center = Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, this.getElevationAtCenter(world, pos, state), 0.0);
        ArrayList<TrackNodeLocation.DiscoveredLocation> list = new ArrayList<TrackNodeLocation.DiscoveredLocation>();
        TrackShape shape = (TrackShape)((Object)state.m_61143_(TrackBlock.SHAPE));
        this.getTrackAxes(world, pos, state).forEach(axis -> ITrackBlock.addToListIfConnected(connectedTo, list, (d, b) -> axis.m_82490_(b != false ? d : -d.doubleValue()).m_82549_(center), b -> shape.getNormal(), b -> {
            ResourceKey resourceKey;
            if (world instanceof Level) {
                Level l = (Level)world;
                resourceKey = l.m_46472_();
            } else {
                resourceKey = Level.f_46428_;
            }
            return resourceKey;
        }, axis, null));
        return list;
    }

    public static void addToListIfConnected(@Nullable TrackNodeLocation fromEnd, Collection<TrackNodeLocation.DiscoveredLocation> list, BiFunction<Double, Boolean, Vec3> offsetFactory, Function<Boolean, Vec3> normalFactory, Function<Boolean, ResourceKey<Level>> dimensionFactory, Vec3 axis, BezierConnection viaTurn) {
        TrackNodeLocation.DiscoveredLocation firstLocation = new TrackNodeLocation.DiscoveredLocation(dimensionFactory.apply(true), offsetFactory.apply(0.5, true)).viaTurn(viaTurn).withNormal(normalFactory.apply(true)).withDirection(axis);
        TrackNodeLocation.DiscoveredLocation secondLocation = new TrackNodeLocation.DiscoveredLocation(dimensionFactory.apply(false), offsetFactory.apply(0.5, false)).viaTurn(viaTurn).withNormal(normalFactory.apply(false)).withDirection(axis);
        if (!firstLocation.dimension.equals((Object)secondLocation.dimension)) {
            firstLocation.forceNode();
            secondLocation.forceNode();
        }
        boolean skipFirst = false;
        boolean skipSecond = false;
        if (fromEnd != null) {
            boolean equalsFirst = firstLocation.equals((Object)fromEnd);
            boolean equalsSecond = secondLocation.equals((Object)fromEnd);
            if (!equalsFirst && !equalsSecond) {
                return;
            }
            if (equalsFirst) {
                skipFirst = true;
            }
            if (equalsSecond) {
                skipSecond = true;
            }
        }
        if (!skipFirst) {
            list.add(firstLocation);
        }
        if (!skipSecond) {
            list.add(secondLocation);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public PartialModel prepareTrackOverlay(BlockGetter var1, BlockPos var2, BlockState var3, BezierTrackPointLocation var4, Direction.AxisDirection var5, PoseStack var6, TrackTargetingBehaviour.RenderedTrackOverlayType var7);

    @OnlyIn(value=Dist.CLIENT)
    public PartialModel prepareAssemblyOverlay(BlockGetter var1, BlockPos var2, BlockState var3, Direction var4, PoseStack var5);

    default public boolean isSlope(BlockGetter world, BlockPos pos, BlockState state) {
        return this.getTrackAxes((BlockGetter)world, (BlockPos)pos, (BlockState)state).get((int)0).f_82480_ != 0.0;
    }

    default public Pair<Vec3, Direction.AxisDirection> getNearestTrackAxis(BlockGetter world, BlockPos pos, BlockState state, Vec3 lookVec) {
        Vec3 best = null;
        double bestDiff = Double.MAX_VALUE;
        for (Vec3 vec3 : this.getTrackAxes(world, pos, state)) {
            for (int opposite : Iterate.positiveAndNegative) {
                double distanceTo = vec3.m_82541_().m_82554_(lookVec.m_82490_((double)opposite));
                if (distanceTo > bestDiff) continue;
                bestDiff = distanceTo;
                best = vec3;
            }
        }
        return Pair.of(best, lookVec.m_82526_(best.m_82542_(1.0, 0.0, 1.0).m_82541_()) < 0.0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE);
    }
}

