/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class TrackGraphRequestPacket
extends SimplePacketBase {
    private int netId;

    public TrackGraphRequestPacket(int netId) {
        this.netId = netId;
    }

    public TrackGraphRequestPacket(FriendlyByteBuf buffer) {
        this.netId = buffer.readInt();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.netId);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            for (TrackGraph trackGraph : Create.RAILWAYS.trackNetworks.values()) {
                if (trackGraph.netId != this.netId) continue;
                Create.RAILWAYS.sync.sendFullGraphTo(trackGraph, ((NetworkEvent.Context)context.get()).getSender());
                break;
            }
        });
        context.get().setPacketHandled(true);
    }
}

