/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.entity;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.relays.elementary.ShaftBlock;
import com.simibubi.create.content.logistics.trains.entity.CarriageBogey;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class BogeyInstance {
    public final CarriageBogey bogey;
    private final ModelData[] shafts;

    protected BogeyInstance(CarriageBogey bogey, MaterialManager materialManager) {
        this.bogey = bogey;
        this.shafts = new ModelData[2];
        materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel((BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)ShaftBlock.AXIS, (Comparable)Direction.Axis.Z)).createInstances((InstanceData[])this.shafts);
    }

    public void remove() {
        for (ModelData shaft : this.shafts) {
            shaft.delete();
        }
    }

    public void hiddenFrame() {
        this.beginFrame(0.0f, null);
    }

    public void beginFrame(float wheelAngle, PoseStack ms) {
        if (ms == null) {
            for (int i : Iterate.zeroAndOne) {
                this.shafts[i].setEmptyTransform();
            }
            return;
        }
        for (int i : Iterate.zeroAndOne) {
            ((ModelData)((ModelData)this.shafts[i].setTransform(ms).translate(-0.5, 0.25, (double)(i * -1)).centre()).rotateZ((double)wheelAngle)).unCentre();
        }
    }

    public void updateLight(BlockAndTintGetter world, CarriageContraptionEntity entity) {
        BlockPos lightPos = new BlockPos(this.getLightPos(entity));
        this.updateLight(world.m_45517_(LightLayer.BLOCK, lightPos), world.m_45517_(LightLayer.SKY, lightPos));
    }

    private Vec3 getLightPos(CarriageContraptionEntity entity) {
        if (this.bogey.getAnchorPosition() != null) {
            return this.bogey.getAnchorPosition();
        }
        return entity.m_7371_(AnimationTickHolder.getPartialTicks());
    }

    public void updateLight(int blockLight, int skyLight) {
        for (ModelData shaft : this.shafts) {
            shaft.setBlockLight(blockLight).setSkyLight(skyLight);
        }
    }

    public static final class Drive
    extends BogeyInstance {
        private final ModelData[] secondShaft;
        private final ModelData drive;
        private final ModelData piston;
        private final ModelData wheels;
        private final ModelData pin;

        public Drive(CarriageBogey bogey, MaterialManager materialManager) {
            super(bogey, materialManager);
            Material mat = materialManager.defaultSolid().material(Materials.TRANSFORMED);
            this.secondShaft = new ModelData[2];
            mat.getModel((BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)ShaftBlock.AXIS, (Comparable)Direction.Axis.X)).createInstances((InstanceData[])this.secondShaft);
            this.drive = (ModelData)mat.getModel(AllBlockPartials.BOGEY_DRIVE).createInstance();
            this.piston = (ModelData)mat.getModel(AllBlockPartials.BOGEY_PISTON).createInstance();
            this.wheels = (ModelData)mat.getModel(AllBlockPartials.LARGE_BOGEY_WHEELS).createInstance();
            this.pin = (ModelData)mat.getModel(AllBlockPartials.BOGEY_PIN).createInstance();
        }

        @Override
        public void beginFrame(float wheelAngle, PoseStack ms) {
            super.beginFrame(wheelAngle, ms);
            if (ms == null) {
                for (int i : Iterate.zeroAndOne) {
                    this.secondShaft[i].setEmptyTransform();
                }
                this.drive.setEmptyTransform();
                this.piston.setEmptyTransform();
                this.wheels.setEmptyTransform();
                this.pin.setEmptyTransform();
                return;
            }
            for (int i : Iterate.zeroAndOne) {
                ((ModelData)((ModelData)this.secondShaft[i].setTransform(ms).translate(-0.5, 0.25, (double)(0.5f + (float)(i * -2))).centre()).rotateX((double)wheelAngle)).unCentre();
            }
            this.drive.setTransform(ms);
            this.piston.setTransform(ms).translate(0.0, 0.0, 0.25 * Math.sin(AngleHelper.rad(wheelAngle)));
            this.wheels.setTransform(ms).translate(0.0, 1.0, 0.0).rotateX((double)wheelAngle);
            ((ModelData)this.pin.setTransform(ms).translate(0.0, 1.0, 0.0).rotateX((double)wheelAngle)).translate(0.0, 0.25, 0.0).rotateX((double)(-wheelAngle));
        }

        @Override
        public void updateLight(int blockLight, int skyLight) {
            super.updateLight(blockLight, skyLight);
            for (ModelData shaft : this.secondShaft) {
                shaft.setBlockLight(blockLight).setSkyLight(skyLight);
            }
            this.drive.setBlockLight(blockLight).setSkyLight(skyLight);
            this.piston.setBlockLight(blockLight).setSkyLight(skyLight);
            this.wheels.setBlockLight(blockLight).setSkyLight(skyLight);
            this.pin.setBlockLight(blockLight).setSkyLight(skyLight);
        }

        @Override
        public void remove() {
            super.remove();
            for (ModelData shaft : this.secondShaft) {
                shaft.delete();
            }
            this.drive.delete();
            this.piston.delete();
            this.wheels.delete();
            this.pin.delete();
        }
    }

    public static final class Frame
    extends BogeyInstance {
        private final ModelData frame;
        private final ModelData[] wheels;

        public Frame(CarriageBogey bogey, MaterialManager materialManager) {
            super(bogey, materialManager);
            this.frame = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(AllBlockPartials.BOGEY_FRAME).createInstance();
            this.wheels = new ModelData[2];
            materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(AllBlockPartials.SMALL_BOGEY_WHEELS).createInstances((InstanceData[])this.wheels);
        }

        @Override
        public void beginFrame(float wheelAngle, PoseStack ms) {
            super.beginFrame(wheelAngle, ms);
            if (ms == null) {
                this.frame.setEmptyTransform();
                for (int side : Iterate.positiveAndNegative) {
                    this.wheels[(side + 1) / 2].setEmptyTransform();
                }
                return;
            }
            this.frame.setTransform(ms);
            for (int side : Iterate.positiveAndNegative) {
                this.wheels[(side + 1) / 2].setTransform(ms).translate(0.0, 0.75, (double)side).rotateX((double)wheelAngle);
            }
        }

        @Override
        public void updateLight(int blockLight, int skyLight) {
            super.updateLight(blockLight, skyLight);
            this.frame.setBlockLight(blockLight).setSkyLight(skyLight);
            for (ModelData wheel : this.wheels) {
                wheel.setBlockLight(blockLight).setSkyLight(skyLight);
            }
        }

        @Override
        public void remove() {
            super.remove();
            this.frame.delete();
            for (ModelData wheel : this.wheels) {
                wheel.delete();
            }
        }
    }
}

