/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.entity;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionType;
import com.simibubi.create.content.contraptions.components.structureMovement.MountedStorageManager;
import com.simibubi.create.content.contraptions.components.structureMovement.NonStationaryLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.interaction.controls.ControlsBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.train.TrainCargoManager;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.logistics.trains.IBogeyBlock;
import com.simibubi.create.content.logistics.trains.entity.ArrivalSoundQueue;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class CarriageContraption
extends Contraption {
    private Direction assemblyDirection;
    private boolean forwardControls;
    private boolean backwardControls;
    public Couple<Boolean> blazeBurnerConductors;
    public Map<BlockPos, Couple<Boolean>> conductorSeats;
    public ArrivalSoundQueue soundQueue;
    protected MountedStorageManager storageProxy;
    private int bogeys;
    private boolean sidewaysControls;
    private BlockPos secondBogeyPos;
    private List<BlockPos> assembledBlazeBurners;
    public int portalCutoffMin;
    public int portalCutoffMax;
    static final IItemHandlerModifiable fallbackItems = new ItemStackHandler();
    static final IFluidHandler fallbackFluids = new FluidTank(0);
    private Collection<BlockEntity> specialRenderedTEsOutsidePortal = new ArrayList<BlockEntity>();

    public CarriageContraption() {
        this.conductorSeats = new HashMap<BlockPos, Couple<Boolean>>();
        this.assembledBlazeBurners = new ArrayList<BlockPos>();
        this.blazeBurnerConductors = Couple.create(false, false);
        this.soundQueue = new ArrivalSoundQueue();
        this.portalCutoffMin = Integer.MIN_VALUE;
        this.portalCutoffMax = Integer.MAX_VALUE;
        this.storage = new TrainCargoManager();
    }

    public void setSoundQueueOffset(int offset) {
        this.soundQueue.offset = offset;
    }

    public CarriageContraption(Direction assemblyDirection) {
        this();
        this.assemblyDirection = assemblyDirection;
        this.bogeys = 0;
    }

    @Override
    public boolean assemble(Level world, BlockPos pos) throws AssemblyException {
        if (!this.searchMovedStructure(world, pos, null)) {
            return false;
        }
        if (this.blocks.size() <= 1) {
            return false;
        }
        if (this.bogeys == 0) {
            return false;
        }
        if (this.bogeys > 2) {
            throw new AssemblyException((Component)Lang.translateDirect("train_assembly.too_many_bogeys", this.bogeys));
        }
        if (this.sidewaysControls) {
            throw new AssemblyException((Component)Lang.translateDirect("train_assembly.sideways_controls", new Object[0]));
        }
        for (BlockPos blazePos : this.assembledBlazeBurners) {
            for (Direction direction : Iterate.directionsInAxis(this.assemblyDirection.m_122434_())) {
                if (!this.inControl(blazePos, direction)) continue;
                this.blazeBurnerConductors.set(direction != this.assemblyDirection, true);
            }
        }
        for (BlockPos seatPos : this.getSeats()) {
            for (Direction direction : Iterate.directionsInAxis(this.assemblyDirection.m_122434_())) {
                if (!this.inControl(seatPos, direction)) continue;
                this.conductorSeats.computeIfAbsent(seatPos, p -> Couple.create(false, false)).set(direction != this.assemblyDirection, true);
            }
        }
        return true;
    }

    public boolean inControl(BlockPos pos, Direction direction) {
        BlockPos controlsPos = pos.m_121945_(direction);
        if (!this.blocks.containsKey(controlsPos)) {
            return false;
        }
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)this.blocks.get(controlsPos);
        if (!AllBlocks.CONTROLS.has(info.f_74676_)) {
            return false;
        }
        return info.f_74676_.m_61143_((Property)ControlsBlock.f_54117_) == direction.m_122424_();
    }

    public void swapStorageAfterAssembly(CarriageContraptionEntity cce) {
        Carriage carriage = cce.getCarriage();
        if (carriage.storage == null) {
            carriage.storage = (TrainCargoManager)this.storage;
            this.storage = new MountedStorageManager();
        }
        this.storageProxy = carriage.storage;
    }

    public void returnStorageForDisassembly(MountedStorageManager storage) {
        this.storage = storage;
    }

    @Override
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return false;
    }

    @Override
    protected Pair<StructureTemplate.StructureBlockInfo, BlockEntity> capture(Level world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        if (ArrivalSoundQueue.isPlayable(blockState)) {
            int anchorCoord = VecHelper.getCoordinate((Vec3i)this.anchor, this.assemblyDirection.m_122434_());
            int posCoord = VecHelper.getCoordinate((Vec3i)pos, this.assemblyDirection.m_122434_());
            this.soundQueue.add((posCoord - anchorCoord) * this.assemblyDirection.m_122421_().m_122540_(), this.toLocalPos(pos));
        }
        if (blockState.m_60734_() instanceof IBogeyBlock) {
            ++this.bogeys;
            if (this.bogeys == 2) {
                this.secondBogeyPos = pos;
            }
            return Pair.of((Object)new StructureTemplate.StructureBlockInfo(pos, blockState, null), null);
        }
        if (AllBlocks.BLAZE_BURNER.has(blockState) && blockState.m_61143_(BlazeBurnerBlock.HEAT_LEVEL) != BlazeBurnerBlock.HeatLevel.NONE) {
            this.assembledBlazeBurners.add(this.toLocalPos(pos));
        }
        if (AllBlocks.CONTROLS.has(blockState)) {
            Direction facing = (Direction)blockState.m_61143_((Property)ControlsBlock.f_54117_);
            if (facing.m_122434_() != this.assemblyDirection.m_122434_()) {
                this.sidewaysControls = true;
            } else {
                boolean forwards;
                boolean bl = forwards = facing == this.assemblyDirection;
                if (forwards) {
                    this.forwardControls = true;
                } else {
                    this.backwardControls = true;
                }
            }
        }
        return super.capture(world, pos);
    }

    @Override
    public CompoundTag writeNBT(boolean spawnPacket) {
        CompoundTag tag = super.writeNBT(spawnPacket);
        NBTHelper.writeEnum(tag, "AssemblyDirection", this.getAssemblyDirection());
        tag.m_128379_("FrontControls", this.forwardControls);
        tag.m_128379_("BackControls", this.backwardControls);
        tag.m_128379_("FrontBlazeConductor", ((Boolean)this.blazeBurnerConductors.getFirst()).booleanValue());
        tag.m_128379_("BackBlazeConductor", ((Boolean)this.blazeBurnerConductors.getSecond()).booleanValue());
        ListTag list = NBTHelper.writeCompoundList(this.conductorSeats.entrySet(), e -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)((BlockPos)e.getKey())));
            compoundTag.m_128379_("Forward", ((Boolean)((Couple)e.getValue()).getFirst()).booleanValue());
            compoundTag.m_128379_("Backward", ((Boolean)((Couple)e.getValue()).getSecond()).booleanValue());
            return compoundTag;
        });
        tag.m_128365_("ConductorSeats", (Tag)list);
        this.soundQueue.serialize(tag);
        return tag;
    }

    @Override
    public void readNBT(Level world, CompoundTag nbt, boolean spawnData) {
        this.assemblyDirection = NBTHelper.readEnum(nbt, "AssemblyDirection", Direction.class);
        this.forwardControls = nbt.m_128471_("FrontControls");
        this.backwardControls = nbt.m_128471_("BackControls");
        this.blazeBurnerConductors = Couple.create(nbt.m_128471_("FrontBlazeConductor"), nbt.m_128471_("BackBlazeConductor"));
        this.conductorSeats.clear();
        NBTHelper.iterateCompoundList(nbt.m_128437_("ConductorSeats", 10), c -> this.conductorSeats.put(NbtUtils.m_129239_((CompoundTag)c.m_128469_("Pos")), Couple.create(c.m_128471_("Forward"), c.m_128471_("Backward"))));
        this.soundQueue.deserialize(nbt);
        super.readNBT(world, nbt, spawnData);
    }

    @Override
    public boolean canBeStabilized(Direction facing, BlockPos localPos) {
        return false;
    }

    @Override
    protected MountedStorageManager getStorageForSpawnPacket() {
        return this.storageProxy;
    }

    @Override
    protected ContraptionType getType() {
        return ContraptionType.CARRIAGE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ContraptionLighter<?> makeLighter() {
        return new NonStationaryLighter<CarriageContraption>(this);
    }

    public Direction getAssemblyDirection() {
        return this.assemblyDirection;
    }

    public boolean hasForwardControls() {
        return this.forwardControls;
    }

    public boolean hasBackwardControls() {
        return this.backwardControls;
    }

    public BlockPos getSecondBogeyPos() {
        return this.secondBogeyPos;
    }

    @Override
    public Collection<StructureTemplate.StructureBlockInfo> getRenderedBlocks() {
        if (this.notInPortal()) {
            return super.getRenderedBlocks();
        }
        this.specialRenderedTEsOutsidePortal = new ArrayList<BlockEntity>();
        this.specialRenderedTileEntities.stream().filter(te -> !this.isHiddenInPortal(te.m_58899_())).forEach(this.specialRenderedTEsOutsidePortal::add);
        ArrayList<StructureTemplate.StructureBlockInfo> values = new ArrayList<StructureTemplate.StructureBlockInfo>();
        for (Map.Entry entry : this.blocks.entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            if (this.withinVisible(pos)) {
                values.add((StructureTemplate.StructureBlockInfo)entry.getValue());
                continue;
            }
            if (!this.atSeam(pos)) continue;
            values.add(new StructureTemplate.StructureBlockInfo(pos, Blocks.f_50210_.m_49966_(), null));
        }
        return values;
    }

    @Override
    public Collection<BlockEntity> getSpecialRenderedTEs() {
        if (this.notInPortal()) {
            return super.getSpecialRenderedTEs();
        }
        return this.specialRenderedTEsOutsidePortal;
    }

    @Override
    public Optional<List<AABB>> getSimplifiedEntityColliders() {
        if (this.notInPortal()) {
            return super.getSimplifiedEntityColliders();
        }
        return Optional.empty();
    }

    @Override
    public boolean isHiddenInPortal(BlockPos localPos) {
        if (this.notInPortal()) {
            return super.isHiddenInPortal(localPos);
        }
        return !this.withinVisible(localPos) || this.atSeam(localPos);
    }

    public boolean notInPortal() {
        return this.portalCutoffMin == Integer.MIN_VALUE && this.portalCutoffMax == Integer.MAX_VALUE;
    }

    public boolean atSeam(BlockPos localPos) {
        Direction facing = this.assemblyDirection;
        Direction.Axis axis = facing.m_122427_().m_122434_();
        int coord = axis.m_7863_(localPos.m_123343_(), localPos.m_123342_(), localPos.m_123341_()) * -facing.m_122421_().m_122540_();
        return coord == this.portalCutoffMin || coord == this.portalCutoffMax;
    }

    public boolean withinVisible(BlockPos localPos) {
        Direction facing = this.assemblyDirection;
        Direction.Axis axis = facing.m_122427_().m_122434_();
        int coord = axis.m_7863_(localPos.m_123343_(), localPos.m_123342_(), localPos.m_123341_()) * -facing.m_122421_().m_122540_();
        return coord > this.portalCutoffMin && coord < this.portalCutoffMax;
    }

    @Override
    public IItemHandlerModifiable getSharedInventory() {
        return this.storageProxy == null ? fallbackItems : this.storageProxy.getItems();
    }

    @Override
    public IFluidHandler getSharedFluidTanks() {
        return this.storageProxy == null ? fallbackFluids : this.storageProxy.getFluids();
    }

    @Override
    public void handleContraptionFluidPacket(BlockPos localPos, FluidStack containedFluid) {
        this.storage.updateContainedFluid(localPos, containedFluid);
    }

    @Override
    public void tickStorage(AbstractContraptionEntity entity) {
        if (entity.f_19853_.f_46443_) {
            this.storage.entityTick(entity);
        } else if (this.storageProxy != null) {
            this.storageProxy.entityTick(entity);
        }
    }
}

