/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.display;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplayBlock;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplayLayout;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplaySection;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplayTileEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.font.glyphs.EmptyGlyph;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

public class FlapDisplayRenderer
extends KineticTileEntityRenderer {
    public FlapDisplayRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        FontSet fontSet = fontRenderer.m_92863_(Style.f_131100_);
        float scale = 0.03125f;
        if (!(te instanceof FlapDisplayTileEntity)) {
            return;
        }
        FlapDisplayTileEntity flapTe = (FlapDisplayTileEntity)te;
        if (!flapTe.isController) {
            return;
        }
        List<FlapDisplayLayout> lines = flapTe.getLines();
        ms.m_85836_();
        ((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).centre()).rotateY((double)AngleHelper.horizontalAngle((Direction)te.m_58900_().m_61143_(FlapDisplayBlock.HORIZONTAL_FACING)))).unCentre()).translate(0.0, 0.0, -0.1875);
        ms.m_252880_(0.0f, 1.0f, 1.0f);
        ms.m_85841_(scale, scale, scale);
        ms.m_85841_(1.0f, -1.0f, 1.0f);
        ms.m_252880_(0.0f, 0.0f, 0.5f);
        for (int j = 0; j < lines.size(); ++j) {
            List<FlapDisplaySection> line = lines.get(j).getSections();
            int color = flapTe.getLineColor(j);
            ms.m_85836_();
            float w = 0.0f;
            for (FlapDisplaySection section : line) {
                w += section.getSize() + (float)(section.hasGap ? 8 : 1);
            }
            ms.m_252880_((float)(flapTe.xSize * 16) - w / 2.0f + 1.0f, 4.5f, 0.0f);
            PoseStack.Pose transform = ms.m_85850_();
            FlapDisplayRenderOutput renderOutput = new FlapDisplayRenderOutput(buffer, color, transform.m_252922_(), light, j, !te.isSpeedRequirementFulfilled(), te.m_58904_(), flapTe.isLineGlowing(j));
            for (int i = 0; i < line.size(); ++i) {
                FlapDisplaySection section = line.get(i);
                renderOutput.nextSection(section);
                int ticks = AnimationTickHolder.getTicks((LevelAccessor)te.m_58904_());
                String text = section.renderCharsIndividually() || !section.spinning[0] ? section.text : section.cyclingOptions[(ticks / 3 + i * 13) % section.cyclingOptions.length];
                StringDecomposer.m_14346_((String)text, (Style)Style.f_131099_, (FormattedCharSink)renderOutput);
                ms.m_252880_(section.size + (float)(section.hasGap ? 8 : 1), 0.0f, 0.0f);
            }
            if (buffer instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource bs = (MultiBufferSource.BufferSource)buffer;
                BakedGlyph texturedglyph = fontSet.m_95064_();
                bs.m_109912_(texturedglyph.m_181387_(Font.DisplayMode.NORMAL));
            }
            ms.m_85849_();
            ms.m_252880_(0.0f, 16.0f, 0.0f);
        }
        ms.m_85849_();
    }

    @Override
    protected SuperByteBuffer getRotatedModel(KineticTileEntity te, BlockState state) {
        return CachedBufferer.partialFacingVertical(AllBlockPartials.SHAFTLESS_COGWHEEL, state, (Direction)state.m_61143_(FlapDisplayBlock.HORIZONTAL_FACING));
    }

    public boolean shouldRenderOffScreen(KineticTileEntity pBlockEntity) {
        return ((FlapDisplayTileEntity)pBlockEntity).isController;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FlapDisplayRenderOutput
    implements FormattedCharSink {
        final MultiBufferSource bufferSource;
        final float r;
        final float g;
        final float b;
        final float a;
        final Matrix4f pose;
        final int light;
        final boolean paused;
        FlapDisplaySection section;
        float x;
        private int lineIndex;
        private Level level;

        public FlapDisplayRenderOutput(MultiBufferSource buffer, int color, Matrix4f pose, int light, int lineIndex, boolean paused, Level level, boolean glowing) {
            this.bufferSource = buffer;
            this.lineIndex = lineIndex;
            this.level = level;
            this.a = glowing ? 0.975f : 0.85f;
            this.r = (float)(color >> 16 & 0xFF) / 255.0f;
            this.g = (float)(color >> 8 & 0xFF) / 255.0f;
            this.b = (float)(color & 0xFF) / 255.0f;
            this.pose = pose;
            this.light = glowing ? 0xF000F0 : light;
            this.paused = paused;
        }

        public void nextSection(FlapDisplaySection section) {
            this.section = section;
            this.x = 0.0f;
        }

        public boolean m_6411_(int charIndex, Style style, int glyph) {
            float standardWidth;
            FontSet fontset = this.getFontSet();
            int ticks = this.paused ? 0 : AnimationTickHolder.getTicks((LevelAccessor)this.level);
            float time = this.paused ? 0.0f : AnimationTickHolder.getRenderTime((LevelAccessor)this.level);
            float dim = 1.0f;
            if (this.section.renderCharsIndividually() && this.section.spinning[Math.min(charIndex, this.section.spinning.length)]) {
                float speed = this.section.spinningTicks > 5 && this.section.spinningTicks < 20 ? 1.75f : 2.5f;
                float cycle = time / speed + (float)charIndex * 16.83f + (float)this.lineIndex * 0.75f;
                float partial = cycle % 1.0f;
                int cyclingGlyph = this.section.cyclingOptions[(int)cycle % this.section.cyclingOptions.length].charAt(0);
                glyph = this.paused ? cyclingGlyph : (partial > 0.5f ? (partial > 0.75f ? 95 : 45) : cyclingGlyph);
                dim = 0.75f;
            }
            GlyphInfo glyphinfo = fontset.m_243128_(glyph, false);
            float glyphWidth = glyphinfo.m_83827_(false);
            if (!this.section.renderCharsIndividually() && this.section.spinning[0]) {
                int n = ticks % 3 == 0 ? (glyphWidth == 6.0f ? 45 : (glyphWidth == 1.0f ? 39 : glyph)) : (glyph = glyph);
                int n2 = ticks % 3 == 2 ? (glyphWidth == 6.0f ? 95 : (glyphWidth == 1.0f ? 46 : glyph)) : (glyph = glyph);
                if (ticks % 3 != 1) {
                    dim = 0.75f;
                }
            }
            BakedGlyph bakedglyph = style.m_131176_() && glyph != 32 ? fontset.m_95067_(glyphinfo) : fontset.m_95078_(glyph);
            TextColor textcolor = style.m_131135_();
            float red = this.r * dim;
            float green = this.g * dim;
            float blue = this.b * dim;
            if (textcolor != null) {
                int i = textcolor.m_131265_();
                red = (float)(i >> 16 & 0xFF) / 255.0f;
                green = (float)(i >> 8 & 0xFF) / 255.0f;
                blue = (float)(i & 0xFF) / 255.0f;
            }
            float f = standardWidth = this.section.wideFlaps ? 9.0f : 7.0f;
            if (this.section.renderCharsIndividually()) {
                this.x += (standardWidth - glyphWidth) / 2.0f;
            }
            if (this.isNotEmpty(bakedglyph)) {
                VertexConsumer vertexconsumer = this.bufferSource.m_6299_(this.renderTypeOf(bakedglyph));
                bakedglyph.m_5626_(style.m_131161_(), this.x, 0.0f, this.pose, vertexconsumer, red, green, blue, this.a, this.light);
            }
            this.x = this.section.renderCharsIndividually() ? (this.x += standardWidth - (standardWidth - glyphWidth) / 2.0f) : (this.x += glyphWidth);
            return true;
        }

        public float finish(int bgColor) {
            if (bgColor == 0) {
                return this.x;
            }
            float a = (float)(bgColor >> 24 & 0xFF) / 255.0f;
            float r = (float)(bgColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(bgColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(bgColor & 0xFF) / 255.0f;
            BakedGlyph bakedglyph = this.getFontSet().m_95064_();
            VertexConsumer vertexconsumer = this.bufferSource.m_6299_(this.renderTypeOf(bakedglyph));
            bakedglyph.m_95220_(new BakedGlyph.Effect(-1.0f, 9.0f, this.section.size, -2.0f, 0.01f, r, g, b, a), this.pose, vertexconsumer, this.light);
            return this.x;
        }

        private FontSet getFontSet() {
            return Minecraft.m_91087_().f_91062_.m_92863_(Style.f_131100_);
        }

        private RenderType renderTypeOf(BakedGlyph bakedglyph) {
            return bakedglyph.m_181387_(Font.DisplayMode.NORMAL);
        }

        private boolean isNotEmpty(BakedGlyph bakedglyph) {
            return !(bakedglyph instanceof EmptyGlyph);
        }
    }
}

