/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.display;

import com.google.gson.JsonElement;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplayBlock;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplayLayout;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplaySection;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.DyeHelper;
import com.simibubi.create.foundation.utility.DynamicComponent;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class FlapDisplayTileEntity
extends KineticTileEntity {
    public List<FlapDisplayLayout> lines;
    public boolean isController;
    public boolean isRunning;
    public int xSize;
    public int ySize;
    public DyeColor[] colour;
    public boolean[] glowingLines;
    public boolean[] manualLines;

    public FlapDisplayTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        this.isController = false;
        this.xSize = 1;
        this.ySize = 1;
        this.colour = new DyeColor[2];
        this.manualLines = new boolean[2];
        this.glowingLines = new boolean[2];
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.updateControllerStatus();
    }

    public void updateControllerStatus() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof FlapDisplayBlock)) {
            return;
        }
        Direction leftDirection = ((Direction)blockState.m_61143_(FlapDisplayBlock.HORIZONTAL_FACING)).m_122427_();
        boolean shouldBeController = (Boolean)blockState.m_61143_((Property)FlapDisplayBlock.UP) == false && this.f_58857_.m_8055_(this.f_58858_.m_121945_(leftDirection)) != blockState;
        int newXSize = 1;
        int newYSize = 1;
        if (shouldBeController) {
            for (int xOffset = 1; xOffset < 32 && this.f_58857_.m_8055_(this.f_58858_.m_5484_(leftDirection.m_122424_(), xOffset)) == blockState; ++xOffset) {
                ++newXSize;
            }
            for (int yOffset = 0; yOffset < 32 && this.f_58857_.m_8055_(this.f_58858_.m_5484_(Direction.DOWN, yOffset)).m_61145_((Property)FlapDisplayBlock.DOWN).orElse(false).booleanValue(); ++yOffset) {
                ++newYSize;
            }
        }
        if (this.isController == shouldBeController && newXSize == this.xSize && newYSize == this.ySize) {
            return;
        }
        this.isController = shouldBeController;
        this.xSize = newXSize;
        this.ySize = newYSize;
        this.colour = Arrays.copyOf(this.colour, this.ySize * 2);
        this.glowingLines = Arrays.copyOf(this.glowingLines, this.ySize * 2);
        this.manualLines = new boolean[this.ySize * 2];
        this.lines = null;
        this.sendData();
    }

    @Override
    public void tick() {
        super.tick();
        this.isRunning = super.isSpeedRequirementFulfilled();
        if (!(this.f_58857_.f_46443_ && this.isRunning || this.isVirtual())) {
            return;
        }
        int activeFlaps = 0;
        for (FlapDisplayLayout line : this.lines) {
            for (FlapDisplaySection section : line.getSections()) {
                activeFlaps += section.tick();
            }
        }
        if (activeFlaps == 0) {
            return;
        }
        float volume = Mth.m_14036_((float)((float)activeFlaps / 20.0f), (float)0.25f, (float)1.5f);
        float bgVolume = Mth.m_14036_((float)((float)activeFlaps / 40.0f), (float)0.25f, (float)1.0f);
        BlockPos middle = this.f_58858_.m_5484_(this.getDirection().m_122427_(), this.xSize / 2).m_5484_(Direction.DOWN, this.ySize / 2);
        AllSoundEvents.SCROLL_VALUE.playAt(this.f_58857_, (Vec3i)middle, volume, 0.56f, false);
        this.f_58857_.m_7785_((double)middle.m_123341_(), (double)middle.m_123342_(), (double)middle.m_123343_(), SoundEvents.f_144094_, SoundSource.BLOCKS, 0.35f * bgVolume, 1.95f, false);
    }

    @Override
    protected boolean isNoisy() {
        return false;
    }

    @Override
    public boolean isSpeedRequirementFulfilled() {
        return this.isRunning;
    }

    public void applyTextManually(int lineIndex, String rawComponentText) {
        List<FlapDisplayLayout> lines = this.getLines();
        if (lineIndex >= lines.size()) {
            return;
        }
        FlapDisplayLayout layout = lines.get(lineIndex);
        if (!layout.isLayout("Default")) {
            layout.loadDefault(this.getMaxCharCount());
        }
        List<FlapDisplaySection> sections = layout.getSections();
        FlapDisplaySection flapDisplaySection = sections.get(0);
        if (rawComponentText == null) {
            this.manualLines[lineIndex] = false;
            flapDisplaySection.setText(Components.immutableEmpty());
            this.notifyUpdate();
            return;
        }
        JsonElement json = DynamicComponent.getJsonFromString(rawComponentText);
        if (json == null) {
            return;
        }
        this.manualLines[lineIndex] = true;
        MutableComponent text = this.isVirtual() ? Component.Serializer.m_130701_((String)rawComponentText) : DynamicComponent.parseCustomText(this.f_58857_, this.f_58858_, json);
        flapDisplaySection.setText((Component)text);
        if (this.isVirtual()) {
            flapDisplaySection.refresh(true);
        } else {
            this.notifyUpdate();
        }
    }

    public void setColour(int lineIndex, DyeColor color) {
        this.colour[lineIndex] = color == DyeColor.WHITE ? null : color;
        this.notifyUpdate();
    }

    public void setGlowing(int lineIndex) {
        this.glowingLines[lineIndex] = true;
        this.notifyUpdate();
    }

    public List<FlapDisplayLayout> getLines() {
        if (this.lines == null) {
            this.initDefaultSections();
        }
        return this.lines;
    }

    public void initDefaultSections() {
        this.lines = new ArrayList<FlapDisplayLayout>();
        for (int i = 0; i < this.ySize * 2; ++i) {
            this.lines.add(new FlapDisplayLayout(this.getMaxCharCount()));
        }
    }

    public int getMaxCharCount() {
        return this.getMaxCharCount(0);
    }

    public int getMaxCharCount(int gaps) {
        return (int)(((float)this.xSize * 16.0f - 2.0f - 4.0f * (float)gaps) / 3.5f);
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        int j;
        super.write(tag, clientPacket);
        tag.m_128379_("Controller", this.isController);
        tag.m_128405_("XSize", this.xSize);
        tag.m_128405_("YSize", this.ySize);
        for (j = 0; j < this.manualLines.length; ++j) {
            if (!this.manualLines[j]) continue;
            NBTHelper.putMarker(tag, "CustomLine" + j);
        }
        for (j = 0; j < this.glowingLines.length; ++j) {
            if (!this.glowingLines[j]) continue;
            NBTHelper.putMarker(tag, "GlowingLine" + j);
        }
        for (j = 0; j < this.colour.length; ++j) {
            if (this.colour[j] == null) continue;
            NBTHelper.writeEnum(tag, "Dye" + j, this.colour[j]);
        }
        List<FlapDisplayLayout> lines = this.getLines();
        for (int i = 0; i < lines.size(); ++i) {
            tag.m_128365_("Display" + i, (Tag)lines.get(i).write());
        }
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        int i;
        super.read(tag, clientPacket);
        boolean wasActive = this.isController;
        int prevX = this.xSize;
        int prevY = this.ySize;
        this.isController = tag.m_128471_("Controller");
        this.xSize = tag.m_128451_("XSize");
        this.ySize = tag.m_128451_("YSize");
        this.manualLines = new boolean[this.ySize * 2];
        for (i = 0; i < this.ySize * 2; ++i) {
            this.manualLines[i] = tag.m_128441_("CustomLine" + i);
        }
        this.glowingLines = new boolean[this.ySize * 2];
        for (i = 0; i < this.ySize * 2; ++i) {
            this.glowingLines[i] = tag.m_128441_("GlowingLine" + i);
        }
        this.colour = new DyeColor[this.ySize * 2];
        for (i = 0; i < this.ySize * 2; ++i) {
            this.colour[i] = tag.m_128441_("Dye" + i) ? NBTHelper.readEnum(tag, "Dye" + i, DyeColor.class) : null;
        }
        if (clientPacket && wasActive != this.isController || prevX != this.xSize || prevY != this.ySize) {
            this.invalidateRenderBoundingBox();
            this.lines = null;
        }
        List<FlapDisplayLayout> lines = this.getLines();
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            lines.get(i2).read(tag.m_128469_("Display" + i2));
        }
    }

    public int getLineIndexAt(double yCoord) {
        return (int)Mth.m_14008_((double)Math.floor(2.0 * ((double)this.f_58858_.m_123342_() - yCoord + 1.0)), (double)0.0, (double)(this.ySize * 2));
    }

    public FlapDisplayTileEntity getController() {
        if (this.isController) {
            return this;
        }
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof FlapDisplayBlock)) {
            return null;
        }
        BlockPos.MutableBlockPos pos = this.m_58899_().m_122032_();
        Direction side = ((Direction)blockState.m_61143_(FlapDisplayBlock.HORIZONTAL_FACING)).m_122427_();
        for (int i = 0; i < 64; ++i) {
            BlockState other = this.f_58857_.m_8055_((BlockPos)pos);
            if (other.m_61145_((Property)FlapDisplayBlock.UP).orElse(false).booleanValue()) {
                pos.m_122173_(Direction.UP);
                continue;
            }
            if (!this.f_58857_.m_8055_(pos.m_121945_(side)).m_61145_((Property)FlapDisplayBlock.UP).orElse(true).booleanValue()) {
                pos.m_122173_(side);
                continue;
            }
            BlockEntity found = this.f_58857_.m_7702_((BlockPos)pos);
            if (!(found instanceof FlapDisplayTileEntity)) break;
            FlapDisplayTileEntity flap = (FlapDisplayTileEntity)found;
            if (!flap.isController) break;
            return flap;
        }
        return null;
    }

    @Override
    protected AABB createRenderBoundingBox() {
        AABB aabb = new AABB(this.f_58858_);
        if (!this.isController) {
            return aabb;
        }
        Vec3i normal = this.getDirection().m_122427_().m_122436_();
        return aabb.m_82363_((double)(normal.m_123341_() * this.xSize), (double)(-this.ySize), (double)(normal.m_123343_() * this.xSize));
    }

    public Direction getDirection() {
        return this.m_58900_().m_61145_(FlapDisplayBlock.HORIZONTAL_FACING).orElse(Direction.SOUTH).m_122424_();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    public int getLineColor(int line) {
        DyeColor color = this.colour[line];
        return color == null ? -2898246 : (Integer)DyeHelper.DYE_TABLE.get(color).getFirst() | 0xFF000000;
    }

    public boolean isLineGlowing(int line) {
        return this.glowingLines[line];
    }
}

