/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.edgePoint.station;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.management.edgePoint.TrackTargetingBehaviour;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationTileEntity;
import com.simibubi.create.foundation.map.CustomRenderedMapDecoration;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Components;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.joml.Matrix4f;

public class StationMarker {
    public static final MapDecoration.Type TYPE = MapDecoration.Type.RED_MARKER;
    private final BlockPos source;
    private final BlockPos target;
    private final Component name;
    private final String id;

    public StationMarker(BlockPos source, BlockPos target, Component name) {
        this.source = source;
        this.target = target;
        this.name = name;
        this.id = "create:station-" + target.m_123341_() + "," + target.m_123342_() + "," + target.m_123343_();
    }

    public static StationMarker load(CompoundTag tag) {
        BlockPos source = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("source"));
        BlockPos target = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("target"));
        MutableComponent name = Component.Serializer.m_130701_((String)tag.m_128461_("name"));
        if (name == null) {
            name = Components.immutableEmpty();
        }
        return new StationMarker(source, target, (Component)name);
    }

    public static StationMarker fromWorld(BlockGetter level, BlockPos pos) {
        Optional stationOption = AllTileEntities.TRACK_STATION.get(level, pos);
        if (stationOption.isEmpty() || ((StationTileEntity)stationOption.get()).getStation() == null) {
            return null;
        }
        String name = ((StationTileEntity)stationOption.get()).getStation().name;
        return new StationMarker(pos, TileEntityBehaviour.get((BlockEntity)stationOption.get(), TrackTargetingBehaviour.TYPE).getPositionForMapMarker(), (Component)Components.literal(name));
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("source", (Tag)NbtUtils.m_129224_((BlockPos)this.source));
        tag.m_128365_("target", (Tag)NbtUtils.m_129224_((BlockPos)this.target));
        tag.m_128359_("name", Component.Serializer.m_130703_((Component)this.name));
        return tag;
    }

    public BlockPos getSource() {
        return this.source;
    }

    public BlockPos getTarget() {
        return this.target;
    }

    public Component getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StationMarker that = (StationMarker)o;
        if (!this.target.equals((Object)that.target)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.name);
    }

    public static class Decoration
    extends MapDecoration
    implements CustomRenderedMapDecoration {
        private static final ResourceLocation TEXTURE = Create.asResource("textures/gui/station_map_icon.png");

        public Decoration(byte x, byte y, Component name) {
            super(TYPE, x, y, (byte)0, name);
        }

        public static Decoration from(MapDecoration decoration) {
            return new Decoration(decoration.m_77804_(), decoration.m_77805_(), decoration.m_77810_());
        }

        public boolean m_77809_() {
            return true;
        }

        @Override
        public void render(PoseStack poseStack, MultiBufferSource bufferSource, boolean active, int packedLight, MapItemSavedData mapData, int index) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)this.m_77804_() / 2.0 + 64.0, (double)this.m_77805_() / 2.0 + 64.0, -0.02);
            poseStack.m_85836_();
            poseStack.m_252880_(0.5f, 0.0f, 0.0f);
            poseStack.m_85841_(4.5f, 4.5f, 3.0f);
            VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110497_((ResourceLocation)TEXTURE));
            Matrix4f mat = poseStack.m_85850_().m_252922_();
            float zOffset = -0.001f;
            buffer.m_252986_(mat, -1.0f, -1.0f, zOffset * (float)index).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(packedLight).m_5752_();
            buffer.m_252986_(mat, -1.0f, 1.0f, zOffset * (float)index).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(packedLight).m_5752_();
            buffer.m_252986_(mat, 1.0f, 1.0f, zOffset * (float)index).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_85969_(packedLight).m_5752_();
            buffer.m_252986_(mat, 1.0f, -1.0f, zOffset * (float)index).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_85969_(packedLight).m_5752_();
            poseStack.m_85849_();
            if (this.m_77810_() != null) {
                Font font = Minecraft.m_91087_().f_91062_;
                Component component = this.m_77810_();
                float f6 = font.m_92852_((FormattedText)component);
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 6.0, (double)-0.005f);
                poseStack.m_85841_(0.8f, 0.8f, 1.0f);
                poseStack.m_252880_(-f6 / 2.0f + 0.5f, 0.0f, 0.0f);
                font.m_253181_(component, 0.0f, 0.0f, -1, false, poseStack.m_85850_().m_252922_(), bufferSource, false, Integer.MIN_VALUE, 0xF000F0);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }

        public boolean render(int index) {
            return true;
        }
    }
}

